/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.videoStream.decoder;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class HttpStatusLineHelper {
    protected InputStream httpIn;
    protected String version;
    protected int statusCode;
    protected String message;

    protected void readVersion() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(8);
        int n = this.httpIn.read();
        while (n != -1 && n != 32) {
            stringBuffer.append((char)n);
            n = this.httpIn.read();
        }
        if (n == -1) {
            throw new EOFException("End of input while reading version.");
        }
        this.version = stringBuffer.toString();
    }

    public String getVersion() {
        return this.version;
    }

    protected void readStatusCode() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(3);
        int n = this.httpIn.read();
        while (n != -1 && n != 32) {
            stringBuffer.append((char)n);
            n = this.httpIn.read();
        }
        if (n == -1) {
            throw new EOFException("End of input while reading status code.");
        }
        this.statusCode = Integer.parseInt(stringBuffer.toString());
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    protected void readMessage() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(25);
        int n = this.httpIn.read();
        while (n != -1 && n != 13) {
            stringBuffer.append((char)n);
            n = this.httpIn.read();
        }
        if (n == -1) {
            throw new EOFException("End of input while reading reason phrase.");
        }
        n = this.httpIn.read();
        this.message = stringBuffer.toString();
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.version + ' ' + this.statusCode + ' ' + this.message;
    }

    public HttpStatusLineHelper(InputStream inputStream) throws IOException {
        this.httpIn = inputStream;
        this.readVersion();
        this.readStatusCode();
        this.readMessage();
    }
}

