/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.videoStream.decoder;

import com.tridium.videoDriver.videoStream.IVideoStream;
import com.tridium.videoDriver.videoStream.decoder.HttpMultipartMimeHelper;
import com.tridium.videoDriver.videoStream.decoder.VidFrame;
import com.tridium.videoDriver.videoStream.decoder.VideoDecoder;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PushbackInputStream;
import javax.baja.gx.BImage;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.ByteBuffer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GenericMjpegDecoder
extends VideoDecoder {
    public static final int MARKER_JPEG_COMMENT = 254;
    public static final int MARKER_STATE_NOT_IN_JPEG_MARKER = 0;
    public static final int MARKER_STATE_READ_JPEG_MARKER_SIZE_MSB = 1;
    public static final int MARKER_STATE_READ_JPEG_MARKER_SIZE_LSB = 2;
    public static final int MARKER_STATE_READ_JPEG_MARKER_HEADER = 3;
    protected MjpegByteBuffer mjpegByteBuffer;
    protected int positionInBuffer;
    protected byte[] buffer;

    protected InputStream makeInputStreamForDecoder(IVideoStream iVideoStream) {
        return new PushbackInputStream(iVideoStream.getInputStream(), 2);
    }

    protected void frameStarting() throws IOException {
    }

    public void readFrameData(VidFrame vidFrame) throws Exception {
        this.readUntilStartOfJpeg(vidFrame);
        this.readJpegImageToBuffer(vidFrame);
        int n = this.positionInBuffer + 1;
        this.mjpegByteBuffer.reset();
        this.mjpegByteBuffer.setBuffer(this.buffer);
        this.mjpegByteBuffer.setLength(n);
        vidFrame.rawData = this.mjpegByteBuffer;
    }

    public void decodeFrame(VidFrame vidFrame) {
        vidFrame.image = BImage.make((byte[])vidFrame.rawData.getBytes());
    }

    protected void readUntilStartOfJpeg(VidFrame vidFrame) throws IOException {
        if (this.isMultiPartMime()) {
            this.readUntilStartOfJpeg_mimeMultipart();
        } else {
            this.readUntilStartOfJpeg_driverSpecific(vidFrame);
        }
    }

    protected void readUntilStartOfJpeg_driverSpecific(VidFrame vidFrame) throws IOException {
        PushbackInputStream pushbackInputStream = (PushbackInputStream)this.videoIn;
        if (pushbackInputStream != null) {
            pushbackInputStream.read(this.buffer, 0, 2);
            int n = 1;
            while (true) {
                int n2;
                boolean bl;
                int n3 = this.buffer[n - 1] & 0xFF;
                int n4 = this.buffer[n] & 0xFF;
                boolean bl2 = false;
                if (n3 == 255) {
                    bl2 = true;
                }
                boolean bl3 = bl2;
                boolean bl4 = false;
                if (n4 == 216) {
                    bl4 = bl = true;
                }
                if (bl3 && bl) break;
                if (++n >= this.buffer.length) {
                    byte[] byArray = new byte[this.buffer.length * 2];
                    ByteArrayUtil.copy((byte[])this.buffer, (byte[])byArray);
                    this.buffer = byArray;
                }
                if ((n2 = pushbackInputStream.read()) < 0) {
                    throw new EOFException();
                }
                this.buffer[n] = (byte)n2;
            }
            pushbackInputStream.unread(this.buffer, n - 1, 2);
        }
    }

    protected void readUntilStartOfJpeg_mimeMultipart() throws IOException {
        InputStream inputStream = this.videoIn;
        if (inputStream != null) {
            HttpMultipartMimeHelper httpMultipartMimeHelper = new HttpMultipartMimeHelper(inputStream, this.getHttpPushBoundary());
            if (httpMultipartMimeHelper.getStatusLine() == null) {
                throw new IllegalStateException("Expected mime, multi-part header with an HTTP status code but did find one.");
            }
            int n = httpMultipartMimeHelper.getStatusLine().getStatusCode();
            if (n == 200) {
                return;
            }
            if (n == 100) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
                this.readUntilStartOfJpeg_mimeMultipart();
            } else {
                throw new IOException("Expected StatusCode of 200. Received " + httpMultipartMimeHelper.getStatusLine().getStatusCode());
            }
        }
    }

    protected void readJpegImageToBuffer(VidFrame vidFrame) throws IOException {
        InputStream inputStream = this.videoIn;
        if (inputStream != null) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (this.buffer.length < 2) {
                this.buffer = new byte[40960];
            }
            inputStream.read(this.buffer, 0, 2);
            this.positionInBuffer = 1;
            while (true) {
                int n5;
                boolean bl;
                int n6 = this.buffer[this.positionInBuffer - 1] & 0xFF;
                int n7 = this.buffer[this.positionInBuffer] & 0xFF;
                boolean bl2 = false;
                if (n6 == 255) {
                    bl2 = true;
                }
                boolean bl3 = bl2;
                boolean bl4 = false;
                if (n7 == 217) {
                    bl4 = bl = true;
                }
                if (bl3 && bl && n == 0) break;
                if (n == 0 && bl3 && n7 != 0 && n7 != 255 && n7 != 216) {
                    n4 = n7;
                    n = 1;
                }
                ++this.positionInBuffer;
                if (this.positionInBuffer >= this.buffer.length) {
                    byte[] byArray = new byte[this.buffer.length * 2];
                    ByteArrayUtil.copy((byte[])this.buffer, (byte[])byArray);
                    this.buffer = byArray;
                }
                if ((n5 = inputStream.read()) < 0) {
                    throw new EOFException();
                }
                this.buffer[this.positionInBuffer] = (byte)n5;
                if (n == 1) {
                    n3 = (n5 & 0xFF) << 8;
                    n = 2;
                    continue;
                }
                if (n == 2) {
                    n2 = n3 |= n5 & 0xFF;
                    n = 3;
                    continue;
                }
                if (n != 3 || --n2 != 0) continue;
                this.processMarker(vidFrame, n4, this.buffer, this.positionInBuffer - n3 + 1, n3 - 2);
                n = 0;
            }
        }
    }

    protected void processMarker(VidFrame vidFrame, int n, byte[] byArray, int n2, int n3) {
        if (n == 254) {
            this.processJpegComment(vidFrame, byArray, n2, n3);
        }
    }

    protected void processJpegComment(VidFrame vidFrame, byte[] byArray, int n, int n2) {
    }

    private final /* synthetic */ void this() {
        this.mjpegByteBuffer = new MjpegByteBuffer();
        this.positionInBuffer = 1;
        this.buffer = new byte[40960];
    }

    public GenericMjpegDecoder() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class MjpegByteBuffer
    extends ByteBuffer {
        public void setLength(int n) {
            this.length = n;
        }

        public void setBuffer(byte[] byArray) {
            this.buffer = byArray;
        }
    }
}

