/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.videoStream;

import com.tridium.util.EscUtil;
import com.tridium.videoDriver.VideoDriverLexicon;
import com.tridium.videoDriver.camera.BIRemoteVideoCamera;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.enums.BFoxVideoStreamEnum;
import com.tridium.videoDriver.ui.BIVideoPlayer;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamPane;
import com.tridium.videoDriver.ui.playback.VideoPlaybackSession;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoPlayback;
import com.tridium.videoDriver.videoStream.IVideoStream;
import com.tridium.videoDriver.videoStream.WaitForStopDecoding;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import com.tridium.videoDriver.videoStream.fox.BFoxVideoSource;
import javax.baja.driver.BDevice;
import javax.baja.log.Log;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.UnboundException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BVideoStreamBinding
extends BBinding {
    public static final Type TYPE;
    static int nextVideoStreamBindingId;
    protected static Log log;
    int videoStreamBindingId;
    protected BPlaybackParams playbackParams;
    protected BIVideoSource videoSource;
    protected BIVideoPlayer videoPlayer;
    protected IVideoStream videoStream;
    protected IVideoDecoder videoDecoder;
    protected IVideoPlayback videoPlaybackWidget;
    protected BComponent stationTargetComponent;
    protected VideoPlaybackSession videoPlaybackSession;
    protected ConnectionManager connectionManager;
    protected volatile boolean isStopped;
    static /* synthetic */ Class class$com$tridium$videoDriver$videoStream$BVideoStreamBinding;
    static /* synthetic */ Class class$com$tridium$videoDriver$videoStream$fox$BFoxVideoSource;

    public Type getType() {
        return TYPE;
    }

    public void started() {
        block3: {
            if (log.isTraceOn()) {
                this.trace("started callback");
            }
            this.connectionManager = new ConnectionManager();
            Thread thread = new Thread((Runnable)this.connectionManager, this.getResourcName());
            thread.start();
            try {
                super.started();
            }
            catch (Exception exception) {
                if (!log.isTraceOn()) break block3;
                log.trace("Exception in BVideoStreamBinding.started()", (Throwable)exception);
            }
        }
    }

    public void stopped() {
        block4: {
            this.isStopped = true;
            if (log.isTraceOn()) {
                this.trace("stopped callback.");
            }
            if (this.connectionManager != null) {
                this.connectionManager.done();
            }
            try {
                super.stopped();
            }
            catch (Exception exception) {
                if (!log.isTraceOn()) break block4;
                log.trace("Exception in BVideoStreamBinding.stopped()", (Throwable)exception);
            }
        }
    }

    public void targetChanged() {
        if (log.isTraceOn()) {
            this.trace("targetChanged callback");
        }
        this.applyDegradeBehavior();
        BWidget bWidget = this.getWidget();
        if (bWidget != null) {
            bWidget.relayout();
        } else {
            new BNullWidget().add("placeHolder?", (BValue)this);
        }
        this.connectionManager.decode();
    }

    public boolean firedOnWidget(Topic topic, BValue bValue, Context context) {
        if (this.getWidget() instanceof BIVideoPlayer && topic != null && this.videoPlayer != null && this.videoPlayer.getReloadVideoTopic() != null && topic.equals((Object)this.videoPlayer.getReloadVideoTopic())) {
            if (log.isTraceOn()) {
                this.trace("firedOnWidget - topic equals videoPlayer.getReloadVideoTopic()");
            }
            this.connectionManager.restart();
            return true;
        }
        return super.firedOnWidget(topic, bValue, context);
    }

    private final boolean initiateStream(boolean bl) {
        if (log.isTraceOn()) {
            this.trace("initiateStream");
        }
        try {
            if (bl && !this.videoDecoder.isFinished()) {
                if (log.isTraceOn()) {
                    this.trace("stopDecoding");
                }
                this.videoPlaybackSession.stopDecoding(this.videoDecoder, this.videoStream);
            }
            if (!this.resolveFresh()) {
                return false;
            }
            try {
                Thread.sleep((int)(Math.random() * 500.0));
            }
            catch (Exception exception) {}
            if (this.isStopped) {
                return false;
            }
            this.videoStream = this.videoPlaybackSession.establishVideoStream(this.videoSource, this.playbackParams, this.videoDecoder, this);
            boolean bl2 = false;
            if (this.videoStream != null) {
                bl2 = true;
            }
            return bl2;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void shutDown() {
        if (this.videoPlaybackSession != null) {
            if (log.isTraceOn()) {
                this.trace("Stopping video session.");
            }
            this.videoPlaybackSession.stopVideoSession();
        }
        if (this.videoDecoder == null) return;
        if (log.isTraceOn()) {
            this.trace("Stopping decoder.");
        }
        WaitForStopDecoding waitForStopDecoding = new WaitForStopDecoding();
        WaitForStopDecoding waitForStopDecoding2 = waitForStopDecoding;
        synchronized (waitForStopDecoding2) {
            try {
                this.videoDecoder.stopDecoding(waitForStopDecoding);
                waitForStopDecoding.wait(5000L);
            }
            catch (Throwable throwable) {}
            return;
        }
    }

    protected boolean resolveFresh() {
        if (this.resolveVideoPlayer() && this.resolveStationTarget() && this.resolveVideoSource()) {
            this.resolveVideoPlaybackSession();
            this.resolvePlaybackParams();
            if (this.resolveVideoDecoder()) {
                return true;
            }
        }
        return false;
    }

    protected boolean resolveVideoPlayer() {
        BWidget bWidget;
        if (log.isTraceOn()) {
            this.trace("resolveVideoPlayer...");
        }
        if ((bWidget = this.getWidget()) == null || !(bWidget instanceof BIVideoPlayer)) {
            if (log.isTraceOn()) {
                this.trace("The expected boundWidget is not a BIVideoPlayer.");
            }
            return false;
        }
        this.videoPlayer = (BIVideoPlayer)bWidget;
        if (bWidget instanceof BVideoMultistreamPane) {
            return true;
        }
        BVideoMultistreamPane bVideoMultistreamPane = BVideoMultistreamPane.getVideoMultistreamPane(bWidget);
        boolean bl = false;
        if (bVideoMultistreamPane == null) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean resolveStationTarget() {
        if (log.isTraceOn()) {
            this.trace("resolveStationTarget...");
        }
        BObject bObject = null;
        BComponent bComponent = null;
        try {
            try {
                bObject = this.get();
                if (bObject instanceof BComponent && bObject instanceof BIVideoSource) {
                    bComponent = (BComponent)bObject;
                }
            }
            catch (UnboundException unboundException) {
                if (log.isTraceOn()) {
                    this.trace("Unable to resolve station target: " + (Object)((Object)unboundException));
                }
                bObject = null;
                bComponent = null;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.stationTargetComponent = bComponent;
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.stationTargetComponent = bComponent;
            boolean bl = false;
            if (bComponent == null) return bl;
        }
        return true;
    }

    protected boolean resolveVideoSource() {
        boolean bl;
        Object object;
        BIVideoSource bIVideoSource = (BIVideoSource)this.stationTargetComponent;
        if (bIVideoSource instanceof BDevice) {
            object = (BDevice)bIVideoSource;
            if (object.isFault()) {
                if (object instanceof BIVideoCamera) {
                    this.videoPlayer.setMessage(VideoDriverLexicon.getLexString("VideoStreamBinding.cameraDeviceFault", ((BIVideoCamera)object).getCameraDescription(), object.getFaultCause()));
                } else {
                    this.videoPlayer.setMessage(VideoDriverLexicon.getLexString("VideoStreamBinding.cameraDeviceFault", object.getName(), object.getFaultCause()));
                }
                return false;
            }
        } else if (bIVideoSource instanceof BIRemoteVideoCamera) {
            this.videoPlayer.setMessage(VideoDriverLexicon.LEX.getText("VideoStreamBiding.ResolvingThroughNiagaraStation"));
            boolean bl2 = ((BIRemoteVideoCamera)bIVideoSource).isCameraFault();
            if (bl2) {
                String string = ((BIRemoteVideoCamera)bIVideoSource).getCameraDescription();
                String string2 = ((BIRemoteVideoCamera)bIVideoSource).getCameraFaultCause();
                this.videoPlayer.setMessage(VideoDriverLexicon.getLexString("VideoStreamBinding.cameraDeviceFault", string, string2));
                return false;
            }
        }
        if ((object = this.videoPlayer.getVideoStreamFox()) == BFoxVideoStreamEnum.yes) {
            bl = true;
        } else if (object == BFoxVideoStreamEnum.no) {
            bl = false;
        } else if (object == BFoxVideoStreamEnum.inherit) {
            bl = bIVideoSource.isFoxVideoStreamPreferred();
        } else {
            throw new IllegalStateException("Unrecognized foxStreamEnum: " + object);
        }
        if (bl) {
            return this.resolveFoxVideoSource();
        }
        this.videoSource = bIVideoSource;
        return true;
    }

    protected void resolveVideoPlaybackSession() {
        if (this.videoPlaybackSession == null) {
            if (log.isTraceOn()) {
                this.trace("Allocating video playback session object.");
            }
            this.videoPlaybackSession = this.videoSource.newPlaybackSession(this.videoPlaybackWidget);
        }
    }

    protected void resolvePlaybackParams() {
        if (log.isTraceOn()) {
            this.trace("resolvePlaybackParams...");
        }
        BPlaybackParams bPlaybackParams = (BPlaybackParams)this.videoPlayer.getPlaybackParams().newCopy();
        bPlaybackParams.setVideoSourceOrd(this.videoSource.getSlotPathOrd());
        this.videoSource.initPlaybackParams(bPlaybackParams, this.videoPlaybackSession);
        this.playbackParams = bPlaybackParams;
    }

    protected boolean resolveVideoDecoder() {
        IVideoDecoder iVideoDecoder = this.videoSource.makeVideoDecoder(this.playbackParams);
        if (iVideoDecoder == null) {
            if (log.isTraceOn()) {
                this.trace("ERROR : videoSource.makeVideoDecoder Returned null");
            }
            return false;
        }
        try {
            iVideoDecoder.init(this.videoSource, this.videoPlayer, BRelTime.makeSeconds((int)10), this.videoPlaybackSession);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        this.videoPlayer.setVideoDecoder(iVideoDecoder);
        this.videoDecoder = iVideoDecoder;
        return true;
    }

    protected boolean resolveFoxVideoSource() {
        BFoxVideoSource[] bFoxVideoSourceArray;
        BFoxVideoSource bFoxVideoSource = null;
        Class clazz = class$com$tridium$videoDriver$videoStream$fox$BFoxVideoSource;
        if (clazz == null) {
            clazz = class$com$tridium$videoDriver$videoStream$fox$BFoxVideoSource = BVideoStreamBinding.class("[Lcom.tridium.videoDriver.videoStream.fox.BFoxVideoSource;", false);
        }
        if ((bFoxVideoSourceArray = (BFoxVideoSource[])this.stationTargetComponent.getChildren(clazz)) != null && bFoxVideoSourceArray.length > 0) {
            bFoxVideoSource = bFoxVideoSourceArray[0];
        } else {
            bFoxVideoSource = new BFoxVideoSource();
            try {
                String string = EscUtil.slot.escape("Fox Video Source");
                Mark mark = new Mark((BObject)bFoxVideoSource, string);
                mark.copyTo((BObject)this.stationTargetComponent, null);
            }
            catch (Exception exception) {
                log.error("Unexpected scenario: Unable to create Fox Video Source");
                bFoxVideoSource = null;
            }
        }
        this.videoSource = bFoxVideoSource;
        boolean bl = false;
        if (bFoxVideoSource != null) {
            bl = true;
        }
        return bl;
    }

    protected void trace(String string) {
        log.trace("[" + this.videoStreamBindingId + "] " + string);
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    String getResourcName() {
        return "VideoStreamBinding" + this.videoStreamBindingId;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.isStopped = false;
    }

    public BVideoStreamBinding(boolean bl) {
        this.this();
        if (nextVideoStreamBindingId == Integer.MAX_VALUE) {
            nextVideoStreamBindingId = 0;
        }
        this.videoStreamBindingId = nextVideoStreamBindingId++;
    }

    public BVideoStreamBinding() {
        this.this();
        if (nextVideoStreamBindingId == Integer.MAX_VALUE) {
            nextVideoStreamBindingId = 0;
        }
        this.videoStreamBindingId = nextVideoStreamBindingId++;
        if (log.isTraceOn()) {
            this.trace(((Object)((Object)this)).getClass().getName());
        }
        this.videoPlaybackWidget = new IVideoPlayback(){

            public final void changePlayback(BPlaybackParams bPlaybackParams) {
                if (BVideoStreamBinding.this.connectionManager != null) {
                    BVideoStreamBinding.this.connectionManager.restart();
                }
            }
        };
    }

    public BVideoStreamBinding(IVideoPlayback iVideoPlayback) {
        this();
        this.videoPlaybackWidget = iVideoPlayback;
    }

    static {
        Class clazz = class$com$tridium$videoDriver$videoStream$BVideoStreamBinding;
        if (clazz == null) {
            clazz = class$com$tridium$videoDriver$videoStream$BVideoStreamBinding = BVideoStreamBinding.class("[Lcom.tridium.videoDriver.videoStream.BVideoStreamBinding;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        nextVideoStreamBindingId = 0;
        log = Log.getLog((String)"videoDriver.videoStreamBinding");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ConnectionManager
    extends Thread {
        static final int IDLE = 1;
        static final int ESTABLISH = 2;
        static final int REESTABLISH = 3;
        static final int DECODING = 4;
        static final int STOP = 5;
        int state;
        boolean done;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (!this.done) {
                long l = -1;
                if (log.isTraceOn()) {
                    BVideoStreamBinding.this.trace("ConnectionManager " + this.stateToString());
                }
                switch (this.state) {
                    case 1: 
                    case 4: {
                        break;
                    }
                    case 2: {
                        if (BVideoStreamBinding.this.initiateStream(false)) {
                            this.state = 4;
                            break;
                        }
                        l = 3000L;
                        break;
                    }
                    case 3: {
                        if (BVideoStreamBinding.this.initiateStream(true)) {
                            this.state = 4;
                            break;
                        }
                        l = 10000L;
                        break;
                    }
                    case 5: {
                        return;
                    }
                }
                if (this.done) break;
                ConnectionManager connectionManager = this;
                synchronized (connectionManager) {
                    block19: {
                        block18: {
                            if (l <= 0L) break block18;
                            try {
                                this.wait(l);
                            }
                            catch (Throwable throwable) {}
                            break block19;
                        }
                        try {
                            this.wait();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            if (log.isTraceOn()) {
                BVideoStreamBinding.this.trace("ConnectionManager shutDown");
            }
            BVideoStreamBinding.this.shutDown();
        }

        synchronized void decode() {
            if (this.state == 1) {
                this.state = 2;
            }
            this.notify();
        }

        synchronized void restart() {
            if (this.state == 1) {
                this.state = 2;
            } else if (this.state == 4) {
                this.state = 3;
            }
            this.notify();
        }

        synchronized void done() {
            this.state = 5;
            this.done = true;
            this.notify();
        }

        String stateToString() {
            switch (this.state) {
                case 1: {
                    return "IDLE";
                }
                case 2: {
                    return "ESTABLISH";
                }
                case 3: {
                    return "REESTABLISH";
                }
                case 4: {
                    return "DECODING";
                }
                case 5: {
                    return "STOP";
                }
            }
            return "invalid state";
        }

        private final /* synthetic */ void this() {
            this.state = 1;
            this.done = false;
        }

        ConnectionManager() {
            this.this();
        }
    }
}

