/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.playback;

import com.tridium.videoDriver.ui.playback.BVideoPlayback;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.BVideoStreamBinding;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoPlayback;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.IVideoStream;
import com.tridium.videoDriver.videoStream.WaitForStopDecoding;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import com.tridium.videoDriver.videoStream.fox.FoxVideoStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class VideoPlaybackSession
implements IVideoSession,
IVideoDestination {
    protected static int nextVideoSessionId = 0;
    public static final String[] DOTS = new String[]{".", "..", "...", "....", "....."};
    public static final String ESTABLISH_STREAM_TIMEOUT = BVideoPlayback.LEX.getText("VideoPlaybackSession.EstablishStreamTimeout");
    public static final String ESTABLISH_STREAM_MESSAGE = "   " + BVideoPlayback.LEX.getText("VideoPlaybackSession.EstablishingStream") + "   ";
    public static final Log log = Log.getLog((String)"videoDriver.VideoPlaybackSession");
    protected IVideoPlayback videoPlaybackWidget;
    protected int videoSessionId;
    protected Object waitForStreamMonitor;
    protected boolean waitingForStream;
    protected boolean waitingForDataInStream;
    protected IVideoStream videoStream;
    protected IVideoDecoder videoDecoder;
    protected Array establishVideoStreamThreads;
    protected boolean stopVideoSession;
    static /* synthetic */ Class class$java$lang$Thread;

    public void changePlayback(BPlaybackParams bPlaybackParams) {
        if (this.videoPlaybackWidget != null) {
            this.videoPlaybackWidget.changePlayback(bPlaybackParams);
        }
    }

    public int getVideoSessionId() {
        return this.videoSessionId;
    }

    public void stopVideoSession() {
        this.stopVideoSession = true;
        Thread[] threadArray = (Thread[])this.establishVideoStreamThreads.trim();
        if (threadArray != null) {
            int n = 0;
            while (n < threadArray.length) {
                threadArray[n].interrupt();
                ++n;
            }
        }
    }

    public IVideoSession getVideoSession() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void receiveVideoStream(IVideoStream var1_1) {
        block18: {
            if (VideoPlaybackSession.log.isTraceOn()) {
                this.trace("receiveVideoStream - was waiting->" + this.waitingForStream);
            }
            if (!(var1_1 instanceof FoxVideoStream)) break block18;
            var2_2 = this.waitForStreamMonitor;
            synchronized (var2_2) {
                ** try [egrp 1[TRYBLOCK] [2 : 52->104)] { 
lbl8:
                // 1 sources

                {
                    try {
                        if (this.stopVideoSession || var1_1 != null && var1_1.getInputStream() != null && var1_1.getInputStream().available() > 0) {
                            this.waitingForDataInStream = false;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Exception var7_3) {
                        throw new BajaRuntimeException((Throwable)var7_3);
                    }
                }
lbl17:
                // 1 sources

                catch (Throwable var4_4) {
                    var5_5 = null;
                    if (this.stopVideoSession == false) throw var4_4;
                    try {
                        var1_1.closeVideoStream();
                        throw var4_4;
                    }
                    catch (IOException var6_7) {
                        var6_7.printStackTrace();
                    }
                    throw var4_4;
                }
lbl-1000:
                // 1 sources

                {
                    var5_6 = null;
                    if (this.stopVideoSession) {
                        ** try [egrp 3[TRYBLOCK] [3 : 121->130)] { 
lbl30:
                        // 1 sources

                        var1_1.closeVideoStream();
                        break block18;
lbl32:
                        // 1 sources

                        catch (IOException var6_8) {
                            var6_8.printStackTrace();
                        }
                    }
                }
            }
        }
        if (this.videoDecoder.getVideoPlayer() != null) {
            this.videoDecoder.getVideoPlayer().setMessage("");
        }
        if (this.waitingForStream == false) return;
        this.waitingForStream = false;
        this.videoStream = var1_1;
        this.videoDecoder.receiveVideoStream(var1_1);
        var2_2 = this.waitForStreamMonitor;
        synchronized (var2_2) {
            this.waitForStreamMonitor.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void videoStreamTimeout() {
        if (log.isTraceOn()) {
            this.trace("videoStreamTimeout");
        }
        this.videoDecoder.getVideoPlayer().setMessage(ESTABLISH_STREAM_TIMEOUT);
        if (!this.waitingForStream) return;
        Object object = this.waitForStreamMonitor;
        synchronized (object) {
            this.videoStream = null;
            this.waitingForStream = false;
            this.waitForStreamMonitor.notifyAll();
            return;
        }
    }

    public IVideoDecoder getVideoDecoder() {
        return this.videoDecoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IVideoStream establishVideoStream(final BIVideoSource bIVideoSource, final BPlaybackParams bPlaybackParams, IVideoDecoder iVideoDecoder, BVideoStreamBinding bVideoStreamBinding) {
        if (log.isTraceOn()) {
            this.trace("establishVideoStream");
        }
        Object object = this.waitForStreamMonitor;
        synchronized (object) {
            this.videoStream = null;
            this.videoDecoder = iVideoDecoder;
            this.waitingForStream = true;
            this.waitingForDataInStream = true;
            Thread thread = new Thread(Thread.currentThread().getName() + "_ConnectStream"){

                public final void run() {
                    try {
                        bIVideoSource.streamToDestination(bPlaybackParams, VideoPlaybackSession.this);
                        return;
                    }
                    catch (BajaRuntimeException bajaRuntimeException) {
                        if (bajaRuntimeException.getCause() instanceof InterruptedIOException) {
                            if (log.isTraceOn()) {
                                VideoPlaybackSession.this.trace("Interrupted while asking the Niagara server to establish the video stream.");
                            }
                        } else {
                            log.error("BajaRuntimeException connecting stream. Cause = " + bajaRuntimeException.getCause() + " Video Decoder Finished = " + VideoPlaybackSession.this.videoDecoder.isFinished());
                        }
                    }
                    catch (Throwable throwable) {
                        log.error("Exception connecting stream. Exception = " + throwable + "+ Video Decoder Finished = " + VideoPlaybackSession.this.videoDecoder.isFinished());
                    }
                    VideoPlaybackSession.this.waitingForStream = false;
                }
            };
            this.establishVideoStreamThreads.add((Object)thread);
            thread.start();
            try {
                try {
                    if (log.isTraceOn()) {
                        this.trace("Waiting for stream");
                    }
                    long l = Clock.ticks();
                    String string = ESTABLISH_STREAM_MESSAGE;
                    int n = 0;
                    while (!bVideoStreamBinding.isStopped() && this.waitingForStream && Clock.ticks() - l < 30000L) {
                        string = ESTABLISH_STREAM_MESSAGE + DOTS[n / 10 % 5];
                        if (iVideoDecoder.getVideoPlayer() != null) {
                            iVideoDecoder.getVideoPlayer().setMessage(string);
                        }
                        if (log.isTraceOn()) {
                            this.trace("<wait_for_stream>");
                        }
                        ++n;
                        this.waitForStreamMonitor.wait(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (log.isTraceOn()) {
                        this.trace("establishVideoStream Interrupted While Waiting for waitForStreamMonitor");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (log.isTraceOn()) {
                    this.trace("Finished waiting for stream");
                }
                throw throwable;
            }
            {
                Object var10_13 = null;
            }
            if (log.isTraceOn()) {
                this.trace("Finished waiting for stream");
            }
            return this.videoStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopDecoding(IVideoDecoder iVideoDecoder, IVideoStream iVideoStream) {
        WaitForStopDecoding waitForStopDecoding = new WaitForStopDecoding();
        WaitForStopDecoding waitForStopDecoding2 = waitForStopDecoding;
        synchronized (waitForStopDecoding2) {
            block10: {
                try {
                    iVideoDecoder.stopDecoding(waitForStopDecoding);
                    if (waitForStopDecoding.isStopped()) break block10;
                    if (log.isTraceOn()) {
                        this.trace("<wait_for_stop>");
                    }
                    waitForStopDecoding.wait(1000L);
                    try {
                        if (iVideoStream != null) {
                            iVideoStream.closeVideoStream();
                        }
                    }
                    catch (IOException iOException) {
                        if (log.isTraceOn()) {
                            this.trace("stopDecoding - IOException when called videoStream.closeVideoStream()");
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!log.isTraceOn()) break block10;
                    this.trace("stopDecoding Interrupted While Waiting for waitForStreamMonitor");
                }
            }
            return;
        }
    }

    protected void trace(String string) {
        log.trace("[" + this.videoSessionId + "] " + string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.videoSessionId = nextVideoSessionId++;
        this.waitForStreamMonitor = new Object();
        this.waitingForStream = false;
        this.waitingForDataInStream = false;
        Class clazz = class$java$lang$Thread;
        if (clazz == null) {
            clazz = class$java$lang$Thread = VideoPlaybackSession.class("[Ljava.lang.Thread;", false);
        }
        this.establishVideoStreamThreads = new Array(clazz);
        this.stopVideoSession = false;
    }

    public VideoPlaybackSession(IVideoPlayback iVideoPlayback) {
        this.this();
        this.videoPlaybackWidget = iVideoPlayback;
    }
}

