/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.playback;

import com.tridium.videoDriver.enums.BPlaybackSpeedEnum;
import com.tridium.videoDriver.enums.BPlaybackTypeEnum;
import com.tridium.videoDriver.ui.playback.BPlaybackButton;
import com.tridium.videoDriver.ui.playback.BVideoPlayback;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;

public class PlaybackGroup
extends ToggleCommandGroup {
    protected final BVideoPlayback videoPlayback;

    protected BPlaybackButton getPlaybackButton(ToggleCommand toggleCommand) {
        if (toggleCommand == this.videoPlayback.rwdCmd) {
            return this.videoPlayback.rwdButton;
        }
        if (toggleCommand == this.videoPlayback.ffwdCmd) {
            return this.videoPlayback.ffwdButton;
        }
        if (toggleCommand == this.videoPlayback.liveCmd) {
            return this.videoPlayback.liveButton;
        }
        if (toggleCommand == this.videoPlayback.srwdCmd) {
            return this.videoPlayback.srwdButton;
        }
        if (toggleCommand == this.videoPlayback.sfwdCmd) {
            return this.videoPlayback.sfwdButton;
        }
        if (toggleCommand == this.videoPlayback.playCmd) {
            return this.videoPlayback.playButton;
        }
        if (toggleCommand == this.videoPlayback.pauseCmd) {
            return this.videoPlayback.pauseButton;
        }
        throw new BajaRuntimeException("Not implemented for command " + toggleCommand);
    }

    protected void denySelection() {
        this.videoPlayback.changePlaybackControlDenied();
    }

    protected void allowSelection(BPlaybackTypeEnum bPlaybackTypeEnum, BPlaybackSpeedEnum bPlaybackSpeedEnum) {
        this.videoPlayback.changePlaybackAllowed(this.getSelected(), bPlaybackTypeEnum, bPlaybackSpeedEnum, false);
    }

    public void selected(ToggleCommand toggleCommand) {
        if (this.videoPlayback.isRunning()) {
            BPlaybackButton bPlaybackButton = this.getPlaybackButton(toggleCommand);
            int n = bPlaybackButton.getIntensity();
            if (n < 0) {
                throw new IllegalStateException("MultiSpeedToggleCommand command.getIntensity() should not be less than zero.");
            }
            if (n == 0) {
                return;
            }
            int n2 = bPlaybackButton.getIntensity() - 1;
            if (n2 > 9) {
                this.denySelection();
            } else {
                BPlaybackSpeedEnum bPlaybackSpeedEnum = BPlaybackSpeedEnum.make(n2);
                if (toggleCommand == this.videoPlayback.rwdCmd) {
                    this.allowSelection(BPlaybackTypeEnum.fastRew, bPlaybackSpeedEnum);
                } else if (toggleCommand == this.videoPlayback.ffwdCmd) {
                    if (this.videoPlayback.mostRecentValidSelection == this.videoPlayback.liveCmd) {
                        this.denySelection();
                    } else {
                        this.allowSelection(BPlaybackTypeEnum.fastFwd, bPlaybackSpeedEnum);
                    }
                } else if (toggleCommand == this.videoPlayback.playCmd) {
                    this.allowSelection(BPlaybackTypeEnum.play, bPlaybackSpeedEnum);
                } else if (toggleCommand == this.videoPlayback.srwdCmd) {
                    this.allowSelection(BPlaybackTypeEnum.slowRew, bPlaybackSpeedEnum);
                } else if (toggleCommand == this.videoPlayback.sfwdCmd) {
                    if (this.videoPlayback.mostRecentValidSelection == this.videoPlayback.liveCmd) {
                        this.denySelection();
                    } else {
                        this.allowSelection(BPlaybackTypeEnum.slowFwd, bPlaybackSpeedEnum);
                    }
                } else if (toggleCommand == this.videoPlayback.liveCmd) {
                    if (bPlaybackButton.getIntensity() == 1 && this.videoPlayback.mostRecentValidSelection != this.videoPlayback.liveCmd) {
                        this.allowSelection(BPlaybackTypeEnum.live, bPlaybackSpeedEnum);
                    }
                } else if (toggleCommand == this.videoPlayback.pauseCmd) {
                    if (bPlaybackButton.getIntensity() == 1) {
                        this.allowSelection(BPlaybackTypeEnum.pause, bPlaybackSpeedEnum);
                    } else {
                        this.denySelection();
                    }
                } else {
                    throw new BajaRuntimeException("Video player selection not implemented: " + toggleCommand);
                }
            }
        }
    }

    public PlaybackGroup(BVideoPlayback bVideoPlayback) {
        this.videoPlayback = bVideoPlayback;
    }
}

