/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.playback;

import com.tridium.ui.theme.Theme;
import com.tridium.videoDriver.camera.BIRemoteVideoCamera;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.camera.control.BIVideoFocusControl;
import com.tridium.videoDriver.camera.control.BIVideoIrisControl;
import com.tridium.videoDriver.camera.control.BIVideoPanTiltControl;
import com.tridium.videoDriver.camera.control.BIVideoPlaybackIndividualControls;
import com.tridium.videoDriver.camera.control.BIVideoStorePresetControl;
import com.tridium.videoDriver.camera.control.BIVideoZoomControl;
import com.tridium.videoDriver.camera.control.BPlaybackControlInfo;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import com.tridium.videoDriver.enums.BFoxVideoStreamEnum;
import com.tridium.videoDriver.enums.BPlaybackSpeedEnum;
import com.tridium.videoDriver.enums.BPlaybackTypeEnum;
import com.tridium.videoDriver.enums.BVideoFocusEnum;
import com.tridium.videoDriver.enums.BVideoIrisEnum;
import com.tridium.videoDriver.enums.BVideoPanTiltEnum;
import com.tridium.videoDriver.enums.BVideoZoomEnum;
import com.tridium.videoDriver.event.BIVideoEventProvider;
import com.tridium.videoDriver.event.BRetrieveActionParam;
import com.tridium.videoDriver.event.BRetrieveTopicEvent;
import com.tridium.videoDriver.event.BVideoEvent;
import com.tridium.videoDriver.event.BVideoEventRecall;
import com.tridium.videoDriver.ui.BVideoPlayer;
import com.tridium.videoDriver.ui.camera.BVideoCameraPickerFE;
import com.tridium.videoDriver.ui.camera.BVideoEventChooser;
import com.tridium.videoDriver.ui.camera.BVideoLayerPane;
import com.tridium.videoDriver.ui.camera.BVideoPanTiltJoystick;
import com.tridium.videoDriver.ui.camera.BVideoPtzDialogPane;
import com.tridium.videoDriver.ui.camera.BVideoZoomSlider;
import com.tridium.videoDriver.ui.playback.BPlaybackButton;
import com.tridium.videoDriver.ui.playback.BVideoOverlayLabel;
import com.tridium.videoDriver.ui.playback.BVideoPlaybackCenterPane;
import com.tridium.videoDriver.ui.playback.PlaybackGroup;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.BVideoStreamBinding;
import com.tridium.videoDriver.videoStream.IVideoPlayback;
import com.tridium.videoDriver.videoStream.fox.BFoxVideoSource;
import java.util.Comparator;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.BSize;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.security.BPermissions;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BVideoPlayback
extends BWbComponentView
implements IVideoPlayback,
BVideoEventChooser.EventPlayback {
    public static final Action zoom = BVideoPlayback.newAction((int)0, (BValue)BVideoZoomEnum.none, null);
    public static final Action move = BVideoPlayback.newAction((int)0, (BValue)BVideoPanTiltEnum.none, null);
    public static final Action adjustIrisAction = BVideoPlayback.newAction((int)0, (BValue)BVideoIrisEnum.none, null);
    public static final Action adjustFocusAction = BVideoPlayback.newAction((int)0, (BValue)BVideoFocusEnum.none, null);
    public static final Topic adjustIris = BVideoPlayback.newTopic((int)0, null);
    public static final Topic adjustFocus = BVideoPlayback.newTopic((int)0, null);
    public static final Topic adjustZoom = BVideoPlayback.newTopic((int)0, null);
    public static final Type TYPE;
    public static final Lexicon LEX;
    public static double TOP_TOOL_PADDING;
    public static final String REFRESH_IMAGE_MSG;
    public static final BImage REFRESH_IMAGE_ICON;
    public static final Log log;
    protected static Comparator B_ABS_TIME_COMPARATOR_DESCENDING;
    private static final BIcon icon;
    static boolean hasOperatorInvoke;
    static boolean hasAdminInvoke;
    static boolean isMoveOperatorFlag;
    static boolean isZoomOperatorFlag;
    boolean initialized;
    protected BVideoEventChooser videoEventChooser;
    protected Command browseEventsCmd;
    protected Command playFromTimeIndexCmd;
    protected ToggleCommand playCmd;
    protected ToggleCommand pauseCmd;
    protected ToggleCommand rwdCmd;
    protected ToggleCommand ffwdCmd;
    protected ToggleCommand srwdCmd;
    protected ToggleCommand sfwdCmd;
    protected ToggleCommand liveCmd;
    protected BPlaybackButton playButton;
    protected BPlaybackButton pauseButton;
    protected BPlaybackButton rwdButton;
    protected BPlaybackButton ffwdButton;
    protected BPlaybackButton srwdButton;
    protected BPlaybackButton sfwdButton;
    protected BPlaybackButton liveButton;
    protected ToggleCommand mostRecentValidSelection;
    protected PlaybackGroup group;
    protected BLabel currentEventInfo;
    protected BPane currentEventInfoPane;
    protected BIVideoCamera videoCamera;
    protected BVideoPlaybackCenterPane videoPlayerPane;
    protected BVideoZoomSlider videoZoomSlider;
    protected BVideoPanTiltJoystick videoPanTiltJoystick;
    protected BEdgePane viewPane;
    protected BLabel loadingLabel;
    BPane browseEvent;
    protected BVideoLayerPane centerLayerPane;
    BEdgePane cameraPickerTop;
    protected BEdgePane centerEdgePane;
    protected BVideoPlayer videoPlayer;
    protected BPane presetIrisFocusPane;
    protected BBorderPane bottomPane;
    protected boolean viewLoaded;
    protected BVideoStreamBinding videoStreamBinding;
    protected String startPlayingEventText;
    protected BAbsTime startPlayingEventTimeStamp;
    protected boolean shouldBeLive;
    protected BVideoCameraPickerFE cameraPicker;
    protected BEdgePane cameraPickerPane;
    protected String cachedVideoCameraDescription;
    protected BIVideoDvr cachedDvr;
    protected boolean hasSuccessfullyTriedToCache;
    static /* synthetic */ Class class$com$tridium$videoDriver$ui$playback$BVideoPlayback;

    public void zoom(BVideoZoomEnum bVideoZoomEnum) {
        this.invoke(zoom, (BValue)bVideoZoomEnum, null);
    }

    public void move(BVideoPanTiltEnum bVideoPanTiltEnum) {
        this.invoke(move, (BValue)bVideoPanTiltEnum, null);
    }

    public void adjustIrisAction(BVideoIrisEnum bVideoIrisEnum) {
        this.invoke(adjustIrisAction, (BValue)bVideoIrisEnum, null);
    }

    public void adjustFocusAction(BVideoFocusEnum bVideoFocusEnum) {
        this.invoke(adjustFocusAction, (BValue)bVideoFocusEnum, null);
    }

    public void fireAdjustIris(BVideoIrisEnum bVideoIrisEnum) {
        this.fire(adjustIris, (BValue)bVideoIrisEnum, null);
    }

    public void fireAdjustFocus(BVideoFocusEnum bVideoFocusEnum) {
        this.fire(adjustFocus, (BValue)bVideoFocusEnum, null);
    }

    public void fireAdjustZoom(BVideoZoomEnum bVideoZoomEnum) {
        this.fire(adjustZoom, (BValue)bVideoZoomEnum, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BToolBar getViewToolBar() {
        BToolBar bToolBar = new BToolBar();
        bToolBar.add("frwd", (Command)this.rwdCmd);
        bToolBar.add("ffwd", (Command)this.ffwdCmd);
        bToolBar.add("srwd", (Command)this.srwdCmd);
        bToolBar.add("sfwd", (Command)this.sfwdCmd);
        bToolBar.add("play", (Command)this.playCmd);
        bToolBar.add("pause", (Command)this.pauseCmd);
        bToolBar.add("live", (Command)this.liveCmd);
        bToolBar.add("browseEvents", this.browseEventsCmd);
        bToolBar.add("playFromTimeIndex", this.playFromTimeIndexCmd);
        return bToolBar;
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        if (log.isTraceOn()) {
            log.trace("Do load value " + (bObject != null ? ((BComplex)bObject).getName() : "null"));
        }
        super.doLoadValue(bObject, context);
        this.hasSuccessfullyTriedToCache = false;
        this.videoCamera = BVideoPlayback.getVideoSource((BIVideoCamera)bObject);
        this.drawView();
        if (this.videoCamera != null) {
            if (log.isTraceOn()) {
                log.trace("Attempting to hook up the view.");
            }
            this.loadViewAsync();
        }
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        BPane bPane;
        if (bComponentEvent.getId() == 0 && bComponentEvent.getSourceComponent() instanceof BIVideoStorePresetControl && this.presetIrisFocusPane != null && this.presetIrisFocusPane.getParent() != null) {
            bPane = this.drawIrisFocusPresetPane();
            this.presetIrisFocusPane.getParent().set(this.presetIrisFocusPane.getPropertyInParent(), (BValue)bPane);
            this.presetIrisFocusPane = bPane;
        }
        if (bComponentEvent.getSourceComponent() instanceof BVideoEventRecall && bComponentEvent.getId() == 5) {
            BRetrieveActionParam bRetrieveActionParam;
            if (bComponentEvent.getSlot().equals((Object)BVideoEventRecall.retrieveOk)) {
                BRetrieveTopicEvent bRetrieveTopicEvent;
                bPane = bComponentEvent.getValue();
                if (bPane instanceof BRetrieveTopicEvent && (bRetrieveTopicEvent = (BRetrieveTopicEvent)bPane).getRetrieveParam().getClientSessionId() == BFoxVideoSource.getFoxWorkbenchRemoteSessionId(this.getCurrentValue())) {
                    BVideoEvent[] bVideoEventArray = bRetrieveTopicEvent.getEventsArray();
                    if (this.videoEventChooser != null) {
                        this.videoEventChooser.updateEventList(bVideoEventArray);
                        this.videoPlayerPane.getStatusOverlayBottom().getMessage1().setText(REFRESH_IMAGE_MSG);
                        this.videoPlayerPane.getStatusOverlayBottom().getMessage1().setImage(REFRESH_IMAGE_ICON);
                        this.videoPlayerPane.getStatusOverlayBottom().getMessage2().setText(REFRESH_IMAGE_MSG);
                        this.videoPlayerPane.getStatusOverlayBottom().getMessage2().setImage(REFRESH_IMAGE_ICON);
                        this.videoPlayerPane.getStatusOverlayBottom().clearSoon();
                    }
                }
            } else if (bComponentEvent.getSlot().equals((Object)BVideoEventRecall.retrieveFailed) && (bPane = bComponentEvent.getValue()) instanceof BRetrieveActionParam && (bRetrieveActionParam = (BRetrieveActionParam)bPane).getClientSessionId() == BFoxVideoSource.getFoxWorkbenchRemoteSessionId(this.getCurrentValue()) && this.videoEventChooser != null) {
                this.videoEventChooser.updateEventListFailed(bRetrieveActionParam.getFaultCause().format(null));
                this.videoPlayerPane.getStatusOverlayBottom().getMessage1().setText(REFRESH_IMAGE_MSG);
                this.videoPlayerPane.getStatusOverlayBottom().getMessage1().setImage(REFRESH_IMAGE_ICON);
                this.videoPlayerPane.getStatusOverlayBottom().getMessage1().setText("");
                this.videoPlayerPane.getStatusOverlayBottom().getMessage1().setImage(BImage.make((BIcon)BIcon.std((String)"job/failed.png")));
                this.videoPlayerPane.getStatusOverlayBottom().clearSoon();
            }
        }
    }

    public void retrieveDriverEvents(BAbsTime bAbsTime, int n) {
        if (this.videoCamera instanceof BIVideoEventProvider) {
            BIVideoEventProvider bIVideoEventProvider = (BIVideoEventProvider)((Object)this.videoCamera);
            BVideoEventRecall bVideoEventRecall = bIVideoEventProvider.getEventRecaller();
            if (bVideoEventRecall instanceof BComponent) {
                this.registerForComponentEvents((BComponent)bVideoEventRecall);
            }
            BRetrieveActionParam bRetrieveActionParam = new BRetrieveActionParam();
            bRetrieveActionParam.setTimeIndex(bAbsTime);
            bRetrieveActionParam.setNumEvents(n);
            bRetrieveActionParam.setClientSessionId(BFoxVideoSource.getFoxWorkbenchRemoteSessionId(this.getCurrentValue()));
            bVideoEventRecall.retrieveEvents(bRetrieveActionParam);
        }
    }

    public void playEvent(BVideoEvent bVideoEvent) {
        this.playFromTimeIndex(bVideoEvent.toString(null), bVideoEvent.getTimestamp());
    }

    public void overrideCurrentInfoMessage(String string) {
        if (this.currentEventInfo != null) {
            this.currentEventInfo.setText(string);
        }
    }

    public void playFromTimeIndex(String string, BAbsTime bAbsTime) {
        this.currentEventInfo.setText(string);
        BPlaybackControlInfo bPlaybackControlInfo = new BPlaybackControlInfo(BPlaybackTypeEnum.play, BPlaybackSpeedEnum.x1, bAbsTime);
        this.controlPlayback(bPlaybackControlInfo);
        this.mostRecentValidSelection = this.playCmd;
        this.playButton.invokeAction();
    }

    public void updateControls() {
        if (this.videoCamera instanceof BIVideoPlaybackIndividualControls) {
            BIVideoPlaybackIndividualControls bIVideoPlaybackIndividualControls = (BIVideoPlaybackIndividualControls)((Object)this.videoCamera);
            if (!bIVideoPlaybackIndividualControls.isFastForwardEnabled()) {
                this.ffwdButton.setEnabled(false);
            }
            if (!bIVideoPlaybackIndividualControls.isSlowForwardEnabled()) {
                this.sfwdButton.setEnabled(false);
            }
            if (!bIVideoPlaybackIndividualControls.isFastRewindEnabled()) {
                this.rwdButton.setEnabled(false);
            }
            if (!bIVideoPlaybackIndividualControls.isSlowRewindEnabled()) {
                this.srwdButton.setEnabled(false);
            }
            if (!bIVideoPlaybackIndividualControls.isPauseEnabled()) {
                this.pauseButton.setEnabled(false);
            }
        }
    }

    public void drawView() {
        if (!this.initialized) {
            this.initView();
        }
        if (this.videoCamera != null) {
            this.fillView();
        }
    }

    private final void initView() {
        this.initialized = true;
        this.viewPane = new BEdgePane();
        this.currentEventInfoPane = this.drawCurrentEventInfoPane();
        this.setViewPaneTop((BWidget)this.currentEventInfoPane);
        BPane bPane = this.drawCenter();
        this.viewPane.setCenter((BWidget)bPane);
        this.bottomPane = this.drawBottom();
        this.viewPane.setBottom((BWidget)this.bottomPane);
        BVideoLayerPane bVideoLayerPane = new BVideoLayerPane();
        bVideoLayerPane.add("viewPane", (BValue)this.viewPane);
        BEdgePane bEdgePane = new BEdgePane();
        this.loadingLabel = new BLabel(BImage.make((String)LEX.getText("VideoMultistreamViewer.Loading.Icon")), LEX.getText("VideoMultistreamViewer.Loading.Label"));
        this.loadingLabel.setFont(Theme.label().getLargeBoldFont());
        bEdgePane.setCenter((BWidget)this.loadingLabel);
        bVideoLayerPane.add("loadingPane", (BValue)bEdgePane);
        this.setContent((BWidget)bVideoLayerPane);
    }

    private final void fillView() {
        Object object;
        BColor bColor;
        BIVideoSource bIVideoSource;
        if (this.videoCamera instanceof BIVideoSource) {
            bIVideoSource = (BIVideoSource)((Object)this.videoCamera);
            bColor = bIVideoSource.getPreferredBackgroundColor();
            if (bColor != null) {
                this.videoPlayer.setBackgroundColor(bIVideoSource.getPreferredBackgroundColor());
            }
            if ((object = bIVideoSource.getPreferredAspectRatio()) != null) {
                this.videoPlayer.setAspectRatio(bIVideoSource.getPreferredAspectRatio());
            }
            if (!bIVideoSource.supportsPlaybackControl()) {
                this.hideButtons(this.bottomPane.getContent());
            }
        }
        bIVideoSource = (BUserService)BOrd.make((String)"service:baja:UserService").get((BObject)((BComponent)this.videoCamera));
        bIVideoSource.lease();
        bColor = null;
        try {
            object = BOrd.toSession((BObject)((BComponent)this.videoCamera));
            if (object != null) {
                bColor = object.getSessionContext();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = ((BString)bColor.getFacet("username")).getString();
        BUser bUser = (BUser)bIVideoSource.get((String)object);
        bUser.lease();
        BPermissions bPermissions = bUser.getPermissions((Context)bColor);
        hasOperatorInvoke = bPermissions.hasOperatorInvoke();
        hasAdminInvoke = bPermissions.hasAdminInvoke();
        BComponent bComponent = (BComponent)this.videoCamera;
        int n = 0;
        if ((bComponent.getFlags(bComponent.getSlot("move")) & 0x100) == 0) {
            n = 1;
        }
        isMoveOperatorFlag = 1 - n;
        int n2 = 0;
        if ((bComponent.getFlags(bComponent.getSlot("zoom")) & 0x100) == 0) {
            n2 = 1;
        }
        isZoomOperatorFlag = 1 - n2;
        this.videoPanTiltJoystick.setVisible(this.isPanTiltAvailable());
        this.videoZoomSlider.setVisible(this.isZoomAvailable());
        this.browseEvent.setVisible(this.videoCamera instanceof BIVideoEventProvider);
        this.presetIrisFocusPane = this.drawIrisFocusPresetPane();
    }

    protected BPane drawCenter() {
        this.centerEdgePane = new BEdgePane();
        this.videoPlayerPane = new BVideoPlaybackCenterPane();
        this.videoPlayer = this.videoPlayerPane.getVideoPlayer();
        this.centerLayerPane = new BVideoLayerPane();
        this.centerLayerPane.add("videoPlayer", (BValue)this.videoPlayerPane);
        this.videoPanTiltJoystick = new BVideoPanTiltJoystick();
        this.centerLayerPane.add("panTiltJoystick", (BValue)this.videoPanTiltJoystick);
        this.videoZoomSlider = new BVideoZoomSlider();
        this.centerEdgePane.setRight((BWidget)this.videoZoomSlider);
        this.centerEdgePane.setCenter((BWidget)this.centerLayerPane);
        BBorderPane bBorderPane = new BBorderPane((BWidget)this.centerEdgePane, BBorder.inset);
        bBorderPane.setPadding(BInsets.make((double)0.0));
        return bBorderPane;
    }

    private final BPane drawCurrentEventInfoPane() {
        this.currentEventInfo = new BLabel("");
        BButton bButton = new BButton(BImage.make((BIcon)BIcon.std((String)"moveDown.png")));
        bButton.setButtonStyle(BButtonStyle.toolBar);
        bButton.computePreferredSize();
        BConstrainedPane bConstrainedPane = new BConstrainedPane();
        bConstrainedPane.setMinSize(bButton.getPreferredWidth(), bButton.getPreferredHeight());
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setRight((BWidget)bConstrainedPane);
        bEdgePane.setCenter((BWidget)this.currentEventInfo);
        return new BBorderPane((BWidget)bEdgePane, BBorder.inset, BInsets.make((double)TOP_TOOL_PADDING));
    }

    private final BPane drawIrisFocusPresetPane() {
        BPane bPane = BVideoPtzDialogPane.makePresetsPane((BWidget)this, this.videoCamera, false);
        BPane bPane2 = BVideoPtzDialogPane.makeIrisFocusButtonPane((BWidget)this, (BWidget)bPane, this.videoCamera, adjustIris, adjustFocus, false);
        if (bPane2 == null) {
            this.currentEventInfo.setText("");
            return this.currentEventInfoPane;
        }
        return bPane2;
    }

    private final BBorderPane drawBottom() {
        BGridPane bGridPane = new BGridPane(2);
        this.browseEvent = this.drawBrowseEventPane();
        bGridPane.add("playbackControlButtons", (BValue)this.drawPlaybackControlButtons());
        bGridPane.add("browseEventPane", (BValue)this.browseEvent);
        BBorderPane bBorderPane = new BBorderPane((BWidget)bGridPane, BBorder.none);
        bBorderPane.setPadding(BInsets.make((double)6.0));
        return bBorderPane;
    }

    private final BPane drawBrowseEventPane() {
        BFlowPane bFlowPane = new BFlowPane();
        bFlowPane.add(null, (BValue)new BButton(this.browseEventsCmd));
        bFlowPane.add(null, (BValue)new BButton(this.playFromTimeIndexCmd));
        this.browseEventsCmd.setEnabled(false);
        this.playFromTimeIndexCmd.setEnabled(false);
        return bFlowPane;
    }

    private final BPane drawPlaybackControlButtons() {
        BGridPane bGridPane = new BGridPane(12);
        this.playCmd = new ToggleCommand((BWidget)this, LEX, "videoPlaybackControls.play");
        this.pauseCmd = new ToggleCommand((BWidget)this, LEX, "videoPlaybackControls.pause");
        this.rwdCmd = new ToggleCommand((BWidget)this, LEX, "videoPlaybackControls.rwd");
        this.ffwdCmd = new ToggleCommand((BWidget)this, LEX, "videoPlaybackControls.ffwd");
        this.srwdCmd = new ToggleCommand((BWidget)this, LEX, "videoPlaybackControls.srwd");
        this.sfwdCmd = new ToggleCommand((BWidget)this, LEX, "videoPlaybackControls.sfwd");
        this.liveCmd = new ToggleCommand((BWidget)this, LEX, "videoPlaybackControls.live");
        this.playButton = new BPlaybackButton((Command)this.playCmd);
        this.pauseButton = new BPlaybackButton((Command)this.pauseCmd);
        this.rwdButton = new BPlaybackButton((Command)this.rwdCmd);
        this.ffwdButton = new BPlaybackButton((Command)this.ffwdCmd);
        this.srwdButton = new BPlaybackButton((Command)this.srwdCmd);
        this.sfwdButton = new BPlaybackButton((Command)this.sfwdCmd);
        this.liveButton = new BPlaybackButton((Command)this.liveCmd);
        bGridPane.add("empty1", (BValue)new BNullWidget());
        bGridPane.add("rwdButton", (BValue)this.rwdButton);
        bGridPane.add("ffwdButton", (BValue)this.ffwdButton);
        bGridPane.add("empty2", (BValue)new BNullWidget());
        bGridPane.add("swdButton", (BValue)this.srwdButton);
        bGridPane.add("sfwdButton", (BValue)this.sfwdButton);
        bGridPane.add("empty3", (BValue)new BNullWidget());
        bGridPane.add("playButton", (BValue)this.playButton);
        bGridPane.add("pauseButton", (BValue)this.pauseButton);
        bGridPane.add("empty4", (BValue)new BNullWidget());
        bGridPane.add("liveButton", (BValue)this.liveButton);
        this.group = new PlaybackGroup(this);
        this.group.add(this.liveCmd);
        this.group.add(this.rwdCmd);
        this.group.add(this.ffwdCmd);
        this.group.add(this.srwdCmd);
        this.group.add(this.sfwdCmd);
        this.group.add(this.playCmd);
        this.group.add(this.pauseCmd);
        if (this.videoCamera instanceof BIVideoPlaybackIndividualControls) {
            BIVideoPlaybackIndividualControls bIVideoPlaybackIndividualControls = (BIVideoPlaybackIndividualControls)((Object)this.videoCamera);
            this.ffwdButton.setEnabled(bIVideoPlaybackIndividualControls.isFastForwardEnabled());
            this.sfwdButton.setEnabled(bIVideoPlaybackIndividualControls.isSlowForwardEnabled());
            this.rwdButton.setEnabled(bIVideoPlaybackIndividualControls.isFastRewindEnabled());
            this.srwdButton.setEnabled(bIVideoPlaybackIndividualControls.isSlowRewindEnabled());
            this.pauseButton.setEnabled(bIVideoPlaybackIndividualControls.isPauseEnabled());
        }
        if (this.videoCamera == null) {
            this.rwdCmd.setEnabled(false);
            this.ffwdCmd.setEnabled(false);
            this.liveCmd.setEnabled(false);
            this.srwdCmd.setEnabled(false);
            this.sfwdCmd.setEnabled(false);
            this.playCmd.setEnabled(false);
            this.pauseCmd.setEnabled(false);
        }
        return bGridPane;
    }

    private final void setViewPaneTop(BWidget bWidget) {
        if (this.cameraPickerPane == null) {
            this.viewPane.setTop(bWidget);
        } else {
            this.cameraPickerPane.setCenter(bWidget);
        }
    }

    private final void displayLoading(boolean bl) {
        block2: {
            try {
                this.loadingLabel.setVisible(bl);
                ((BWidget)this.loadingLabel.getParent()).setVisible(bl);
            }
            catch (Exception exception) {
                if (!log.isTraceOn()) break block2;
                log.trace("VideoPlayback.UpdateView - Exception calling displayLoading().", (Throwable)exception);
            }
        }
    }

    private final void hideButtons(BWidget bWidget) {
        if (!(bWidget instanceof BConstrainedPane)) {
            BConstrainedPane bConstrainedPane = new BConstrainedPane();
            bConstrainedPane.setMinSize(BSize.make((double)bWidget.getWidth(), (double)bWidget.getHeight()));
            bConstrainedPane.setMaxSize(BSize.make((double)bWidget.getWidth(), (double)bWidget.getHeight()));
            this.bottomPane.setContent((BWidget)bConstrainedPane);
        }
    }

    private final void loadViewAsync() {
        if (log.isTraceOn()) {
            log.trace("loadViewAsync");
        }
        new Thread("VideoPlayback.UpdateView"){

            /*
             * Exception decompiling
             */
            public final void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 270->273)] java.lang.Throwable
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }.start();
    }

    private final void tryLoadViewAsync() {
        block5: {
            try {
                if (this.videoCamera != null) {
                    if (this.shouldBeLive) {
                        this.liveCmd.setSelected(true);
                        this.changePlaybackAllowed(this.liveCmd, BPlaybackTypeEnum.live, BPlaybackSpeedEnum.x1, false);
                    } else {
                        this.playFromTimeIndex(this.startPlayingEventText, this.startPlayingEventTimeStamp);
                    }
                    this.hookWidgetsToDriver();
                }
            }
            catch (Exception exception) {
                if (!log.isTraceOn()) break block5;
                log.trace("VideoPlayback.UpdateView - Exception calling tryLoadViewAsync().", (Throwable)exception);
            }
        }
    }

    protected void changePlaybackControlDenied() {
        BVideoOverlayLabel bVideoOverlayLabel = this.videoPlayerPane.getStatusOverlayTop().getMessage1();
        BImage bImage = this.mostRecentValidSelection.getIcon();
        if (bImage == null) {
            bImage = BImage.NULL;
        }
        bVideoOverlayLabel.setImage(bImage);
        String string = this.mostRecentValidSelection.getLabel();
        if (string == null) {
            string = "";
        }
        bVideoOverlayLabel.setText(string);
        BVideoOverlayLabel bVideoOverlayLabel2 = this.videoPlayerPane.getStatusOverlayTop().getMessage2();
        bVideoOverlayLabel2.setText("");
        bVideoOverlayLabel2.setImage(BImage.make((BIcon)BIcon.std((String)"job/failed.png")));
        this.mostRecentValidSelection.setSelected(true);
        this.videoPlayerPane.getStatusOverlayTop().clearSoon();
    }

    protected void enableWidgetRecursive(BWidget bWidget, boolean bl) {
        bWidget.setEnabled(bl);
        BWidget[] bWidgetArray = bWidget.getChildWidgets();
        int n = 0;
        while (n < bWidgetArray.length) {
            this.enableWidgetRecursive(bWidgetArray[n], bl);
            ++n;
        }
    }

    public void changePlayback(BPlaybackParams bPlaybackParams) {
        ToggleCommand toggleCommand = null;
        BPlaybackButton bPlaybackButton = null;
        switch (bPlaybackParams.getPlaybackType().getOrdinal()) {
            case 0: {
                toggleCommand = this.liveCmd;
                bPlaybackButton = this.liveButton;
                break;
            }
            case 1: {
                toggleCommand = this.playCmd;
                bPlaybackButton = this.liveButton;
                break;
            }
            case 2: {
                toggleCommand = this.ffwdCmd;
                bPlaybackButton = this.ffwdButton;
                break;
            }
            case 3: {
                toggleCommand = this.sfwdCmd;
                bPlaybackButton = this.sfwdButton;
                break;
            }
            case 4: {
                toggleCommand = this.rwdCmd;
                bPlaybackButton = this.rwdButton;
                break;
            }
            case 5: {
                toggleCommand = this.srwdCmd;
                bPlaybackButton = this.srwdButton;
                break;
            }
            case 6: {
                toggleCommand = this.pauseCmd;
                bPlaybackButton = this.pauseButton;
                break;
            }
        }
        if (toggleCommand.isEnabled()) {
            if (toggleCommand.isSelected()) {
                this.changePlaybackAllowed(toggleCommand, bPlaybackParams.getPlaybackType(), bPlaybackParams.getPlaybackSpeed(), true);
            } else {
                toggleCommand.setSelected(true);
                bPlaybackButton.setSelected(true);
                bPlaybackButton.invokeAction();
            }
        }
    }

    protected void controlPlayback(BPlaybackControlInfo bPlaybackControlInfo) {
        this.videoPlayer.changePlaybackControl(bPlaybackControlInfo);
    }

    private final void updateUiForNewPlayback(BPlaybackTypeEnum bPlaybackTypeEnum) {
        block8: {
            if (bPlaybackTypeEnum == BPlaybackTypeEnum.live) {
                this.setViewPaneTop((BWidget)this.presetIrisFocusPane);
                this.enableWidgetRecursive(this.viewPane.getTop(), true);
                this.videoPanTiltJoystick.setEnabled(true);
                this.videoZoomSlider.setEnabled(true);
                this.playCmd.setEnabled(false);
                this.ffwdCmd.setEnabled(false);
                this.sfwdCmd.setEnabled(false);
                this.rwdCmd.setEnabled(true);
                this.srwdCmd.setEnabled(true);
                this.pauseCmd.setEnabled(true);
                try {
                    String string;
                    BIVideoDvr bIVideoDvr;
                    if (this.hasSuccessfullyTriedToCache) {
                        bIVideoDvr = this.cachedDvr;
                        string = this.cachedVideoCameraDescription;
                    } else {
                        bIVideoDvr = this.cachedDvr = this.videoCamera.getDvr();
                        string = this.videoCamera.getCameraDescription();
                        this.hasSuccessfullyTriedToCache = true;
                    }
                    if (bIVideoDvr == null) {
                        this.currentEventInfo.setText(LEX.getText("LiveVideo.status.standAloneCamera", new Object[]{string}));
                        break block8;
                    }
                    this.currentEventInfo.setText(LEX.getText("LiveVideo.status.dvrCamera", new Object[]{bIVideoDvr.getDvrDescription(), string}));
                }
                catch (UnresolvedException unresolvedException) {
                    System.out.println("BVideoPlayback - switch to live - remote station offline - don't forget to implement some code for this");
                }
            } else {
                if (bPlaybackTypeEnum != BPlaybackTypeEnum.play) {
                    this.currentEventInfo.setText("");
                }
                this.setViewPaneTop((BWidget)this.currentEventInfoPane);
                this.enableWidgetRecursive(this.viewPane.getTop(), false);
                this.videoPanTiltJoystick.setEnabled(false);
                this.videoZoomSlider.setEnabled(false);
                this.playCmd.setEnabled(true);
                this.ffwdCmd.setEnabled(true);
                this.sfwdCmd.setEnabled(true);
                this.rwdCmd.setEnabled(true);
                this.srwdCmd.setEnabled(true);
                this.pauseCmd.setEnabled(true);
            }
        }
        this.browseEventsCmd.setEnabled(true);
        this.playFromTimeIndexCmd.setEnabled(true);
        this.liveCmd.setEnabled(true);
        this.centerEdgePane.relayout();
        this.centerEdgePane.repaint();
    }

    protected void changePlaybackAllowed(ToggleCommand toggleCommand, BPlaybackTypeEnum bPlaybackTypeEnum, BPlaybackSpeedEnum bPlaybackSpeedEnum, boolean bl) {
        Object object;
        this.updateUiForNewPlayback(bPlaybackTypeEnum);
        BVideoOverlayLabel bVideoOverlayLabel = this.videoPlayerPane.getStatusOverlayTop().getMessage1();
        BVideoOverlayLabel bVideoOverlayLabel2 = this.videoPlayerPane.getStatusOverlayTop().getMessage2();
        BImage bImage = toggleCommand.getIcon();
        if (bImage == null) {
            bImage = BImage.NULL;
        }
        bVideoOverlayLabel.setImage(bImage);
        bVideoOverlayLabel2.setImage(bImage);
        String string = toggleCommand.getLabel();
        if (string == null) {
            string = "";
        }
        bVideoOverlayLabel.setText(string);
        bVideoOverlayLabel2.setText(string);
        if (bPlaybackTypeEnum != BPlaybackTypeEnum.play && bPlaybackTypeEnum == this.videoPlayer.getPlaybackParams().getPlaybackType()) {
            object = this.videoPlayerPane.getStatusOverlayBottom().getMessage1();
            BVideoOverlayLabel bVideoOverlayLabel3 = this.videoPlayerPane.getStatusOverlayBottom().getMessage2();
            object.setText(bPlaybackSpeedEnum.getDisplayTag(null));
            bVideoOverlayLabel3.setText(bPlaybackSpeedEnum.getDisplayTag(null));
            this.videoPlayerPane.getStatusOverlayBottom().clearSoon();
        }
        if (bl || bPlaybackTypeEnum != BPlaybackTypeEnum.play || this.mostRecentValidSelection != this.playCmd) {
            object = new BPlaybackControlInfo(bPlaybackTypeEnum, bPlaybackSpeedEnum, this.videoPlayer.getPlaybackParams().getTimeIndex());
            this.controlPlayback((BPlaybackControlInfo)((Object)object));
        }
        this.mostRecentValidSelection = toggleCommand;
        if (bPlaybackTypeEnum != BPlaybackTypeEnum.pause) {
            this.videoPlayerPane.getStatusOverlayTop().clearSoon();
        }
    }

    private final void hookWidgetsToDriver() {
        this.hookVideoPlayerToDriver();
        if (this.isZoomAvailable()) {
            this.hookZoomSliderToDriver();
        }
        if (this.isPanTiltAvailable()) {
            this.hookPanTiltJoystickToDriver();
        }
        if (BVideoPtzDialogPane.isIrisFocusOrBothAvailable(this.videoCamera)) {
            this.hookIrisFocusControlsToDriver();
        }
    }

    private final void hookIrisFocusControlsToDriver() {
        this.linkTo((BComponent)this, (Slot)adjustFocus, (Slot)adjustFocusAction);
        this.linkTo((BComponent)this, (Slot)adjustIris, (Slot)adjustIrisAction);
    }

    public void doAdjustIrisAction(BVideoIrisEnum bVideoIrisEnum) {
        if (this.videoCamera instanceof BIVideoIrisControl) {
            ((BIVideoIrisControl)((Object)this.videoCamera)).irisControl(bVideoIrisEnum);
        }
    }

    public void doAdjustFocusAction(BVideoFocusEnum bVideoFocusEnum) {
        if (this.videoCamera instanceof BIVideoFocusControl) {
            ((BIVideoFocusControl)((Object)this.videoCamera)).focusControl(bVideoFocusEnum);
        }
    }

    private final void hookZoomSliderToDriver() {
        this.linkTo((BComponent)this.videoZoomSlider, (Slot)BVideoZoomSlider.zoom, (Slot)zoom);
    }

    public void doZoom(BVideoZoomEnum bVideoZoomEnum) {
        if (this.videoCamera instanceof BIVideoZoomControl) {
            ((BIVideoZoomControl)((Object)this.videoCamera)).zoom(bVideoZoomEnum);
        }
    }

    private final void hookPanTiltJoystickToDriver() {
        this.linkTo((BComponent)this.videoPanTiltJoystick, (Slot)BVideoPanTiltJoystick.move, (Slot)move);
    }

    public void doMove(BVideoPanTiltEnum bVideoPanTiltEnum) {
        if (this.videoCamera instanceof BIVideoPanTiltControl) {
            ((BIVideoPanTiltControl)((Object)this.videoCamera)).move(bVideoPanTiltEnum);
        }
    }

    private final boolean isPanTiltAvailable() {
        try {
            boolean bl = false;
            if (this.videoCamera instanceof BIVideoPanTiltControl && ((BIVideoPanTiltControl)((Object)this.videoCamera)).isPanTiltEnabled() && (hasAdminInvoke || isMoveOperatorFlag && hasOperatorInvoke)) {
                bl = true;
            }
            return bl;
        }
        catch (UnresolvedException unresolvedException) {
            return false;
        }
    }

    private final boolean isZoomAvailable() {
        try {
            boolean bl = false;
            if (this.videoCamera instanceof BIVideoZoomControl && ((BIVideoZoomControl)((Object)this.videoCamera)).isZoomEnabled() && (hasAdminInvoke || isZoomOperatorFlag && hasOperatorInvoke)) {
                bl = true;
            }
            return bl;
        }
        catch (UnresolvedException unresolvedException) {
            return false;
        }
    }

    private final void configureVideoPlayerSettings() {
        if (this.videoCamera instanceof BIVideoSource) {
            this.videoPlayer.setCompression(((BIVideoSource)((Object)this.videoCamera)).getPreferredCompression());
            this.videoPlayer.setFrameRate(((BIVideoSource)((Object)this.videoCamera)).getPreferredFrameRate());
            this.videoPlayer.setResolution(((BIVideoSource)((Object)this.videoCamera)).getPreferredResolution());
            this.videoPlayer.setShowTimeIndex(((BIVideoSource)((Object)this.videoCamera)).isTimestampPreferred());
            this.videoPlayer.setAspectRatio(((BIVideoSource)((Object)this.videoCamera)).getPreferredAspectRatio());
            this.videoPlayer.setBackgroundColor(((BIVideoSource)((Object)this.videoCamera)).getPreferredBackgroundColor());
            if (((BIVideoSource)((Object)this.videoCamera)).isFoxVideoStreamPreferred()) {
                this.videoPlayer.setVideoStreamFox(BFoxVideoStreamEnum.yes);
            } else {
                this.videoPlayer.setVideoStreamFox(BFoxVideoStreamEnum.no);
            }
        } else {
            log.warning("The video camera does not implement BIVideoSource!");
        }
    }

    private final void hookVideoPlayerToDriver() {
        BOrd bOrd = null;
        if (this.videoCamera != null && this.videoCamera instanceof BComponent) {
            BComponent bComponent = (BComponent)this.videoCamera;
            bOrd = BOrd.make((String)("station:|" + bComponent.getSlotPathOrd()));
        }
        if (this.videoCamera != null && this.videoCamera instanceof BIVideoSource && bOrd != null) {
            this.configureVideoPlayerSettings();
            if (this.videoStreamBinding != null) {
                this.videoStreamBinding.stop();
            }
            this.videoStreamBinding = new BVideoStreamBinding(this);
            this.videoStreamBinding.setOrd(bOrd);
            if (this.videoPlayer.get("cameraBinding") == null) {
                this.videoPlayer.add("cameraBinding", (BValue)this.videoStreamBinding);
            } else {
                this.videoPlayer.set("cameraBinding", (BValue)this.videoStreamBinding);
            }
        }
    }

    protected void doBrowseEvents() {
        if (this.videoEventChooser == null && this.videoCamera instanceof BIVideoEventProvider) {
            BVideoEventRecall bVideoEventRecall = ((BIVideoEventProvider)((Object)this.videoCamera)).getEventRecaller();
            this.videoEventChooser = new BVideoEventChooser((BWidget)this, bVideoEventRecall, this);
            this.videoEventChooser.setBoundsCenteredOnOwner();
        }
        this.retrieveDriverEvents(BAbsTime.now(), -20);
        this.videoEventChooser.open();
    }

    protected void doPlayFromTimeIndex() {
        BAbsTime bAbsTime;
        BAbsTime bAbsTime2;
        try {
            bAbsTime2 = this.videoPlayer.getPlaybackParams().getTimeIndex();
        }
        catch (Exception exception) {
            bAbsTime2 = BAbsTime.now();
        }
        bAbsTime2 = bAbsTime2.toLocalTime();
        try {
            bAbsTime = (BAbsTime)BWbFieldEditor.dialog((BWidget)this, (String)LEX.getText("VideoPlaybackView.PlayFromTimeIndex.title"), (BObject)bAbsTime2, (Context)BVideoEvent.EVENT_TIME_STAMP_TO_STRING_FACETS);
        }
        catch (Exception exception) {
            bAbsTime = BAbsTime.NULL;
        }
        if (bAbsTime != null && !bAbsTime.isNull()) {
            this.playFromTimeIndex(LEX.getText("VideoPlaybackView.PlayFromTimeIndex.StatusText", new Object[]{bAbsTime.toString((Context)BVideoEvent.EVENT_TIME_STAMP_TO_STRING_FACETS)}), bAbsTime);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public static BIVideoCamera getVideoSource(BIVideoCamera bIVideoCamera) {
        if (bIVideoCamera instanceof BIRemoteVideoCamera) {
            try {
                BIRemoteVideoCamera bIRemoteVideoCamera = (BIRemoteVideoCamera)bIVideoCamera;
                return (BIVideoCamera)bIRemoteVideoCamera.getRemoteVideoOrd().get((BObject)bIVideoCamera);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
        if (bIVideoCamera instanceof BIVideoCamera) {
            return bIVideoCamera;
        }
        throw new BajaRuntimeException("uknown source:" + bIVideoCamera.getType());
    }

    static final /* synthetic */ void access$0(BVideoPlayback bVideoPlayback, boolean bl) {
        bVideoPlayback.displayLoading(bl);
    }

    static final /* synthetic */ void access$1(BVideoPlayback bVideoPlayback) {
        bVideoPlayback.tryLoadViewAsync();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.initialized = false;
        this.browseEventsCmd = new Command((BWidget)this, LEX, "VideoEventChooser"){

            public final CommandArtifact doInvoke() throws Exception {
                BVideoPlayback.this.doBrowseEvents();
                return null;
            }
        };
        this.playFromTimeIndexCmd = new Command((BWidget)this, LEX, "VideoPlaybackView.PlayFromTimeIndex"){

            public final CommandArtifact doInvoke() throws Exception {
                BVideoPlayback.this.doPlayFromTimeIndex();
                return null;
            }
        };
        this.mostRecentValidSelection = this.liveCmd;
        this.viewLoaded = false;
        this.shouldBeLive = true;
        this.cachedVideoCameraDescription = "";
        this.hasSuccessfullyTriedToCache = false;
    }

    public BVideoPlayback() {
        this.this();
    }

    public BVideoPlayback(BVideoCameraPickerFE bVideoCameraPickerFE, BEdgePane bEdgePane) {
        this.this();
        this.cameraPicker = bVideoCameraPickerFE;
        this.cameraPickerPane = bEdgePane;
    }

    public BVideoPlayback(String string, BAbsTime bAbsTime, boolean bl) {
        this.this();
        this.startPlayingEventText = string;
        this.startPlayingEventTimeStamp = bAbsTime;
        this.shouldBeLive = bl;
    }

    static {
        Class clazz = class$com$tridium$videoDriver$ui$playback$BVideoPlayback;
        if (clazz == null) {
            clazz = class$com$tridium$videoDriver$ui$playback$BVideoPlayback = BVideoPlayback.class("[Lcom.tridium.videoDriver.ui.playback.BVideoPlayback;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$videoDriver$ui$playback$BVideoPlayback;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$videoDriver$ui$playback$BVideoPlayback = BVideoPlayback.class("[Lcom.tridium.videoDriver.ui.playback.BVideoPlayback;", false);
        }
        LEX = Lexicon.make((Class)clazz2);
        TOP_TOOL_PADDING = 2;
        REFRESH_IMAGE_MSG = LEX.get("videoPlaybackControls.refreshEvents..", "");
        String string = LEX.get("videoPlaybackControls.refreshEvents.label", null);
        REFRESH_IMAGE_ICON = string == null ? BImage.NULL : BImage.make((BIcon)BIcon.make((String)LEX.getText("videoPlaybackControls.refreshEvents.label")));
        log = Log.getLog((String)"videoDriver.videoPlaybackView");
        B_ABS_TIME_COMPARATOR_DESCENDING = new Comparator(){

            public final int compare(Object object, Object object2) {
                return -1 * ((BVideoEvent)((Object)object)).getTimestamp().compareTo((Object)((BVideoEvent)((Object)object2)).getTimestamp());
            }
        };
        icon = BIcon.std((String)"animate.png");
        hasOperatorInvoke = false;
        hasAdminInvoke = false;
        isMoveOperatorFlag = false;
        isZoomOperatorFlag = false;
    }
}

