/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.camera;

import com.tridium.ui.theme.Theme;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.camera.control.BIVideoFocusControl;
import com.tridium.videoDriver.camera.control.BIVideoIrisControl;
import com.tridium.videoDriver.camera.control.BIVideoMoveToPresetControl;
import com.tridium.videoDriver.camera.control.BIVideoPanTiltControl;
import com.tridium.videoDriver.camera.control.BIVideoStorePresetControl;
import com.tridium.videoDriver.camera.control.BIVideoZoomControl;
import com.tridium.videoDriver.enums.BFoxVideoStreamEnum;
import com.tridium.videoDriver.enums.BPlaybackTypeEnum;
import com.tridium.videoDriver.enums.BVideoAspectRatioEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFocusEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoIrisEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.enums.BVideoZoomEnum;
import com.tridium.videoDriver.ui.BVideoPlayer;
import com.tridium.videoDriver.ui.camera.BVideoCameraWidget;
import com.tridium.videoDriver.ui.camera.BVideoLayerPane;
import com.tridium.videoDriver.ui.camera.BVideoPanTiltJoystick;
import com.tridium.videoDriver.ui.camera.BVideoPtzBinding;
import com.tridium.videoDriver.ui.camera.BVideoPtzCameraWidgetBinding;
import com.tridium.videoDriver.ui.camera.BVideoZoomSlider;
import com.tridium.videoDriver.ui.camera.GotoPresetCommand;
import com.tridium.videoDriver.ui.camera.StorePresetCommand;
import com.tridium.videoDriver.ui.holdDownButton.BHoldDownButton;
import com.tridium.videoDriver.ui.playback.BVideoPlayback;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.BVideoStreamBinding;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.BSize;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.security.BPermissions;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BVideoPtzDialogPane
extends BEdgePane {
    public static final Action videoPlaybackChanged = BVideoPtzDialogPane.newAction((int)0, null);
    public static final Topic adjustIris = BVideoPtzDialogPane.newTopic((int)0, null);
    public static final Topic adjustFocus = BVideoPtzDialogPane.newTopic((int)0, null);
    public static final Topic adjustZoom = BVideoPtzDialogPane.newTopic((int)0, null);
    public static final Type TYPE;
    public static final Lexicon LEX;
    static boolean hasOperatorInvoke;
    static boolean hasAdminInvoke;
    static boolean isMoveOperatorFlag;
    static boolean isZoomOperatorFlag;
    static boolean isIrisOperatorFlag;
    static boolean isFocusOperatorFlag;
    static boolean isMovePresetOperatorFlag;
    static boolean isStorePresetOperatorFlag;
    public BVideoPlayer videoPlayer;
    public final BIVideoCamera videoCamera;
    public BVideoPanTiltJoystick joystick;
    public BVideoZoomSlider zoomSlider;
    public final BPane bottomPane;
    public BVideoStreamBinding videoStreamBinding;
    public final BSize preferedSize;
    static /* synthetic */ Class class$com$tridium$videoDriver$ui$camera$BVideoPtzDialogPane;

    public void videoPlaybackChanged() {
        this.invoke(videoPlaybackChanged, null, null);
    }

    public void fireAdjustIris(BVideoIrisEnum bVideoIrisEnum) {
        this.fire(adjustIris, (BValue)bVideoIrisEnum, null);
    }

    public void fireAdjustFocus(BVideoFocusEnum bVideoFocusEnum) {
        this.fire(adjustFocus, (BValue)bVideoFocusEnum, null);
    }

    public void fireAdjustZoom(BVideoZoomEnum bVideoZoomEnum) {
        this.fire(adjustZoom, (BValue)bVideoZoomEnum, null);
    }

    public Type getType() {
        return TYPE;
    }

    private static final BColor getBackgroundColor(BIVideoCamera bIVideoCamera) {
        if (bIVideoCamera instanceof BIVideoSource) {
            return ((BIVideoSource)((Object)bIVideoCamera)).getPreferredBackgroundColor();
        }
        return BColor.black;
    }

    private static final BVideoAspectRatioEnum getAspectRatio(BIVideoCamera bIVideoCamera) {
        if (bIVideoCamera instanceof BIVideoSource) {
            return ((BIVideoSource)((Object)bIVideoCamera)).getPreferredAspectRatio();
        }
        return BVideoAspectRatioEnum.standard_def;
    }

    private static final BVideoResolutionEnum getResolution(BIVideoCamera bIVideoCamera) {
        if (bIVideoCamera instanceof BIVideoSource) {
            return ((BIVideoSource)((Object)bIVideoCamera)).getPreferredResolution();
        }
        return BVideoResolutionEnum.high;
    }

    private static final BVideoFrameRateEnum getFrameRate(BIVideoCamera bIVideoCamera) {
        if (bIVideoCamera instanceof BIVideoSource) {
            return ((BIVideoSource)((Object)bIVideoCamera)).getPreferredFrameRate();
        }
        return BVideoFrameRateEnum.low;
    }

    private static final BVideoCompressionEnum getCompression(BIVideoCamera bIVideoCamera) {
        if (bIVideoCamera instanceof BIVideoSource) {
            return ((BIVideoSource)((Object)bIVideoCamera)).getPreferredCompression();
        }
        return BVideoCompressionEnum.medium;
    }

    private static final boolean getTimestampPreferred(BIVideoCamera bIVideoCamera) {
        if (bIVideoCamera instanceof BIVideoSource) {
            return ((BIVideoSource)((Object)bIVideoCamera)).isTimestampPreferred();
        }
        return false;
    }

    private static final BFoxVideoStreamEnum getFoxStreamPreferred(BIVideoCamera bIVideoCamera) {
        if (bIVideoCamera instanceof BIVideoSource) {
            if (((BIVideoSource)((Object)bIVideoCamera)).isFoxVideoStreamPreferred()) {
                return BFoxVideoStreamEnum.yes;
            }
            return BFoxVideoStreamEnum.no;
        }
        return BFoxVideoStreamEnum.no;
    }

    protected boolean isPanTiltAvailable() {
        boolean bl = false;
        if (this.videoCamera instanceof BIVideoPanTiltControl && ((BIVideoPanTiltControl)((Object)this.videoCamera)).isPanTiltEnabled() && (hasAdminInvoke || isMoveOperatorFlag && hasOperatorInvoke)) {
            bl = true;
        }
        return bl;
    }

    protected void makePanTiltJoystick(BWidget bWidget, BBorder bBorder, BRelTime bRelTime) {
        if (this.isPanTiltAvailable()) {
            this.joystick = new BVideoPanTiltJoystick();
            this.joystick.setBackground(BBrush.makeSolid((BColor)BColor.transparent));
            this.joystick.setBorder(bBorder);
            this.joystick.setBallPercent(0.1);
            this.joystick.setFillBallDragging(BBrush.makeSolid((BColor)BColor.transparent));
            this.joystick.setFillBallNormal(BBrush.makeSolid((BColor)BColor.transparent));
            this.joystick.setKeepDownInterval(bRelTime);
            if (bWidget != null) {
                this.joystick.add("cameraBinding", (BValue)new BVideoPtzCameraWidgetBinding(bWidget));
            }
        } else {
            this.joystick = null;
        }
    }

    protected boolean isZoomAvailable() {
        boolean bl = false;
        if (this.videoCamera instanceof BIVideoZoomControl && ((BIVideoZoomControl)((Object)this.videoCamera)).isZoomEnabled() && (hasAdminInvoke || isZoomOperatorFlag && hasOperatorInvoke)) {
            bl = true;
        }
        return bl;
    }

    protected void makeZoomSlider(BWidget bWidget, BBorder bBorder, BBrush bBrush, BRelTime bRelTime) {
        if (this.isZoomAvailable()) {
            this.zoomSlider = new BVideoZoomSlider();
            this.zoomSlider.setBackground(bBrush);
            this.zoomSlider.setBorder(bBorder);
            this.zoomSlider.setKeepDownInterval(bRelTime);
            if (bWidget != null) {
                this.zoomSlider.add("cameraBinding", (BValue)new BVideoPtzCameraWidgetBinding(bWidget));
            }
        } else {
            this.zoomSlider = null;
        }
    }

    protected boolean isVideoAvailable() {
        return this.videoCamera instanceof BIVideoSource;
    }

    protected void makeVideoPlayer(BWidget bWidget, int n, BPlaybackParams bPlaybackParams, BFoxVideoStreamEnum bFoxVideoStreamEnum) {
        if (this.isVideoAvailable()) {
            this.videoPlayer = new BVideoPlayer();
            this.videoPlayer.setThrottleRefreshRate(n);
            this.videoPlayer.setBackgroundColor(bPlaybackParams.getBackgroundColor());
            this.videoPlayer.setAspectRatio(bPlaybackParams.getAspectRatio());
            this.videoPlayer.setResolution(bPlaybackParams.getResolution());
            this.videoPlayer.setFrameRate(bPlaybackParams.getFrameRate());
            this.videoPlayer.setCompression(bPlaybackParams.getCompression());
            this.videoPlayer.setStreamFacets(bPlaybackParams.getVideoFacets());
            this.videoPlayer.setVideoStreamFox(bFoxVideoStreamEnum);
            this.videoPlayer.setShowTimeIndex(BVideoPtzDialogPane.getTimestampPreferred(this.videoCamera));
            BOrd bOrd = null;
            if (this.videoCamera != null && this.videoCamera instanceof BComponent) {
                BComponent bComponent = (BComponent)this.videoCamera;
                bOrd = BOrd.make((String)("station:|" + bComponent.getSlotPathOrd()));
            }
            if (this.isPanTiltAvailable()) {
                this.configurePanTiltBinding(bWidget, bOrd);
            }
            if (BVideoPtzDialogPane.isIrisFocusOrBothAvailable(this.videoCamera)) {
                this.configureIrisFocusBinding(bWidget, bOrd);
            }
        } else {
            this.videoPlayer = null;
        }
    }

    protected void startVideoPlayerBinding() {
        Object object;
        BOrd bOrd = null;
        if (this.videoCamera != null && this.videoCamera instanceof BComponent) {
            object = (BComponent)this.videoCamera;
            bOrd = BOrd.make((String)("station:|" + object.getSlotPathOrd()));
        }
        if (this.videoCamera != null && this.videoCamera instanceof BIVideoSource && bOrd != null) {
            object = new BVideoStreamBinding();
            object.setOrd(bOrd);
            this.videoPlayer.add("cameraBinding", (BValue)object);
        }
    }

    protected void configureIrisFocusBinding(BWidget bWidget, BOrd bOrd) {
        BVideoPtzBinding bVideoPtzBinding = new BVideoPtzBinding();
        bVideoPtzBinding.setOrd(bOrd);
        this.add("irisFocusBinding", (BValue)bVideoPtzBinding);
        BVideoPtzCameraWidgetBinding bVideoPtzCameraWidgetBinding = new BVideoPtzCameraWidgetBinding(bWidget);
        this.add("parentBinding", (BValue)bVideoPtzCameraWidgetBinding);
    }

    protected void configurePanTiltBinding(BWidget bWidget, BOrd bOrd) {
        if (bWidget != null) {
            boolean bl = false;
            BBinding[] bBindingArray = bWidget.getBindings();
            int n = 0;
            while (n < bBindingArray.length) {
                if (bBindingArray[n] instanceof BVideoPtzBinding) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                BVideoPtzBinding bVideoPtzBinding = new BVideoPtzBinding();
                bVideoPtzBinding.setOrd(bOrd);
                bWidget.add("videoPtzBinding?", (BValue)bVideoPtzBinding);
                bVideoPtzBinding.start();
                OrdTarget ordTarget = bOrd.resolve((BObject)((BComponent)this.videoCamera));
                bVideoPtzBinding.fw(303, ordTarget, null, null, null);
            }
        }
    }

    protected BPane overlayPanTiltJoystickOnVideoPlayer() {
        BVideoLayerPane bVideoLayerPane = new BVideoLayerPane();
        bVideoLayerPane.add("videoPlayer", (BValue)this.videoPlayer);
        if (this.joystick != null) {
            bVideoLayerPane.add("joystick", (BValue)this.joystick);
        }
        BBorderPane bBorderPane = new BBorderPane((BWidget)bVideoLayerPane, BBorder.inset);
        bBorderPane.setPadding(BInsets.make((double)0.0));
        return bBorderPane;
    }

    public void computePreferredSize() {
        double d = this.preferedSize.width();
        double d2 = this.preferedSize.height();
        if (d < 50.0 || d2 < 50.0) {
            super.computePreferredSize();
        } else {
            this.setPreferredSize(this.preferedSize.width(), this.preferedSize.height());
        }
    }

    protected BGridPane makeTitlePane() {
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setStretchColumn(1);
        bGridPane.setColumnGap(20.0);
        BVideoCameraWidget bVideoCameraWidget = new BVideoCameraWidget();
        bVideoCameraWidget.setEnabled(false);
        bGridPane.add("graphic", (BValue)bVideoCameraWidget);
        bGridPane.add("title", (BValue)new BLabel(this.videoCamera.getCameraDescription()));
        return bGridPane;
    }

    public static boolean isIrisAvailable(BIVideoCamera bIVideoCamera) {
        boolean bl = false;
        if (bIVideoCamera instanceof BIVideoIrisControl && ((BIVideoIrisControl)((Object)bIVideoCamera)).isIrisEnabled() && (hasAdminInvoke || isIrisOperatorFlag && hasOperatorInvoke)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isFocusAvailable(BIVideoCamera bIVideoCamera) {
        boolean bl = false;
        if (bIVideoCamera instanceof BIVideoIrisControl && ((BIVideoFocusControl)((Object)bIVideoCamera)).isFocusEnabled() && (hasAdminInvoke || isFocusOperatorFlag && hasOperatorInvoke)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isIrisFocusOrBothAvailable(BIVideoCamera bIVideoCamera) {
        boolean bl = false;
        if (BVideoPtzDialogPane.isIrisAvailable(bIVideoCamera) || BVideoPtzDialogPane.isFocusAvailable(bIVideoCamera)) {
            bl = true;
        }
        return bl;
    }

    public static BPane makeIrisFocusButtonPane(BWidget bWidget, BWidget bWidget2, BIVideoCamera bIVideoCamera, Topic topic, Topic topic2, boolean bl) {
        BEdgePane bEdgePane = new BEdgePane();
        if (BVideoPtzDialogPane.isIrisFocusOrBothAvailable(bIVideoCamera)) {
            BPane bPane = null;
            if (BVideoPtzDialogPane.isIrisAvailable(bIVideoCamera)) {
                bPane = BVideoPtzDialogPane.makeCameraControlPane(bWidget, " " + LEX.getText("Iris") + ' ', topic, (BValue)BVideoIrisEnum.brightenFast, (BValue)BVideoIrisEnum.none, (BValue)BVideoIrisEnum.dimFast, (BValue)BVideoIrisEnum.none, bl);
            }
            BPane bPane2 = null;
            if (BVideoPtzDialogPane.isFocusAvailable(bIVideoCamera)) {
                bPane2 = BVideoPtzDialogPane.makeCameraControlPane(bWidget, " " + LEX.getText("Focus") + ' ', topic2, (BValue)BVideoFocusEnum.focusInFast, (BValue)BVideoFocusEnum.none, (BValue)BVideoFocusEnum.focusOutFast, (BValue)BVideoFocusEnum.none, bl);
            }
            if (BVideoPtzDialogPane.isIrisAvailable(bIVideoCamera)) {
                bEdgePane.setLeft((BWidget)new BBorderPane(bPane, BInsets.make((double)0.0)));
            } else {
                bEdgePane.setLeft((BWidget)new BBorderPane());
            }
            if (BVideoPtzDialogPane.isFocusAvailable(bIVideoCamera)) {
                bEdgePane.setRight((BWidget)new BBorderPane(bPane2, BInsets.make((double)0.0)));
            } else {
                bEdgePane.setRight((BWidget)new BBorderPane());
            }
        } else if (bWidget2 == null) {
            return null;
        }
        if (bWidget2 != null) {
            bEdgePane.setCenter(bWidget2);
        }
        return bEdgePane;
    }

    protected static BPane makeCameraControlPane(BWidget bWidget, String string, Topic topic, BValue bValue, BValue bValue2, BValue bValue3, BValue bValue4, boolean bl) {
        BGridPane bGridPane = new BGridPane(2 - bl);
        BHoldDownButton bHoldDownButton = new BHoldDownButton(bWidget, topic, bValue, bValue2, BImage.make((BIcon)BIcon.std((String)"moveUp.png")));
        BHoldDownButton bHoldDownButton2 = new BHoldDownButton(bWidget, topic, bValue3, bValue4, BImage.make((BIcon)BIcon.std((String)"moveDown.png")));
        bHoldDownButton.setButtonStyle(BButtonStyle.toolBar);
        bHoldDownButton2.setButtonStyle(BButtonStyle.toolBar);
        bGridPane.add("plusButton", (BValue)bHoldDownButton);
        bGridPane.add("minusButton", (BValue)bHoldDownButton2);
        if (bl) {
            return new BBorderPane((BWidget)bGridPane, string);
        }
        return new BBorderPane((BWidget)new BGridPane(2, new BWidget[]{new BLabel(string + ':'), bGridPane}), BBorder.inset, BInsets.make((double)BVideoPlayback.TOP_TOOL_PADDING));
    }

    public static BPane makePresetsPane(BWidget bWidget, BIVideoCamera bIVideoCamera, boolean bl) {
        Action action;
        boolean bl2;
        BGridPane bGridPane = new BGridPane(2 - bl);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setHalign(BHalign.center);
        boolean bl3 = false;
        if (bIVideoCamera instanceof BIVideoMoveToPresetControl && ((BIVideoMoveToPresetControl)((Object)bIVideoCamera)).isMoveToPresetEnabled()) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        boolean bl5 = false;
        if (bIVideoCamera instanceof BIVideoStorePresetControl && ((BIVideoStorePresetControl)((Object)bIVideoCamera)).isStorePresetEnabled()) {
            bl5 = bl2 = true;
        }
        if (bl4 && bl2 && (hasAdminInvoke || isMovePresetOperatorFlag && hasOperatorInvoke) && (hasAdminInvoke || isStorePresetOperatorFlag && hasOperatorInvoke)) {
            action = ((BIVideoMoveToPresetControl)((Object)bIVideoCamera)).getMoveToPresetAction();
            BValue bValue = ((BComponent)bIVideoCamera).getActionParameterDefault(action);
            Action action2 = ((BIVideoStorePresetControl)((Object)bIVideoCamera)).getStorePresetAction();
            BValue bValue2 = ((BComponent)bIVideoCamera).getActionParameterDefault(action2);
            BWbFieldEditor bWbFieldEditor = BWbFieldEditor.makeFor((BObject)bValue);
            bWbFieldEditor.loadValue((BObject)bValue);
            if (bValue2.getType() == bValue.getType()) {
                bGridPane.add("editor", (BValue)bWbFieldEditor);
                BGridPane bGridPane2 = new BGridPane(2);
                bGridPane2.setUniformColumnWidth(true);
                bGridPane2.setColumnAlign(BHalign.fill);
                bGridPane2.setHalign(BHalign.center);
                BButton bButton = new BButton((Command)new GotoPresetCommand(bWidget, bWbFieldEditor, bIVideoCamera));
                bGridPane2.add("go", (BValue)bButton);
                BButton bButton2 = new BButton((Command)new StorePresetCommand(bWidget, bWbFieldEditor, bIVideoCamera));
                bGridPane2.add("store", (BValue)bButton2);
                if (!bl) {
                    bButton.setButtonStyle(BButtonStyle.toolBar);
                    bButton2.setButtonStyle(BButtonStyle.toolBar);
                }
                bGridPane.add("presetButtonPane", (BValue)bGridPane2);
            } else {
                BWbFieldEditor bWbFieldEditor2 = BWbFieldEditor.makeFor((BObject)bValue2);
                bWbFieldEditor2.loadValue((BObject)bValue2);
                BGridPane bGridPane3 = new BGridPane(bl ? 2 : 6);
                bGridPane3.add("editor", (BValue)bWbFieldEditor);
                BButton bButton = new BButton((Command)new GotoPresetCommand(bWidget, bWbFieldEditor, bIVideoCamera));
                bGridPane3.add("go", (BValue)bButton);
                if (!bl) {
                    BBorderPane bBorderPane = new BBorderPane();
                    bBorderPane.setPadding(BInsets.make((double)10.0, (double)10.0, (double)30.0, (double)30.0));
                    bGridPane3.add(null, (BValue)bBorderPane);
                }
                bGridPane3.add("storeEditor", (BValue)bWbFieldEditor2);
                BButton bButton3 = new BButton((Command)new StorePresetCommand(bWidget, bWbFieldEditor2, bIVideoCamera));
                bGridPane3.add("store", (BValue)bButton3);
                if (!bl) {
                    bButton.setButtonStyle(BButtonStyle.toolBar);
                    bButton3.setButtonStyle(BButtonStyle.toolBar);
                }
                bGridPane.add("goStorePane", (BValue)bGridPane3);
            }
        } else if (bl4 && (hasAdminInvoke || isMovePresetOperatorFlag && hasOperatorInvoke)) {
            action = ((BIVideoMoveToPresetControl)((Object)bIVideoCamera)).getMoveToPresetAction();
            BValue bValue = ((BComponent)bIVideoCamera).getActionParameterDefault(action);
            BWbFieldEditor bWbFieldEditor = BWbFieldEditor.makeFor((BObject)bValue);
            bWbFieldEditor.loadValue((BObject)bValue);
            BGridPane bGridPane4 = new BGridPane(2 - bl);
            bGridPane4.setColumnAlign(BHalign.fill);
            bGridPane4.add("editor", (BValue)bWbFieldEditor);
            BButton bButton = new BButton((Command)new GotoPresetCommand(bWidget, bWbFieldEditor, bIVideoCamera));
            bGridPane4.add("go", (BValue)bButton);
            if (!bl) {
                bButton.setButtonStyle(BButtonStyle.toolBar);
            }
            bGridPane.add("goPane", (BValue)bGridPane4);
        } else if (bl2 && (hasAdminInvoke || isStorePresetOperatorFlag && hasOperatorInvoke)) {
            action = ((BIVideoStorePresetControl)((Object)bIVideoCamera)).getStorePresetAction();
            BValue bValue = ((BComponent)bIVideoCamera).getActionParameterDefault(action);
            BWbFieldEditor bWbFieldEditor = BWbFieldEditor.makeFor((BObject)bValue);
            bWbFieldEditor.loadValue((BObject)bValue);
            BGridPane bGridPane5 = new BGridPane(2 - bl);
            bGridPane5.setColumnAlign(BHalign.fill);
            bGridPane5.add("editor", (BValue)bWbFieldEditor);
            BButton bButton = new BButton((Command)new StorePresetCommand(bWidget, bWbFieldEditor, bIVideoCamera));
            bGridPane5.add("store", (BValue)bButton);
            if (!bl) {
                bButton.setButtonStyle(BButtonStyle.toolBar);
            }
            bGridPane.add("storePane", (BValue)bGridPane5);
        } else {
            return null;
        }
        if (bl) {
            action = new BBorderPane((BWidget)bGridPane, " " + LEX.getText("Presets") + ' ');
            return action;
        }
        return new BBorderPane((BWidget)new BGridPane(2, new BWidget[]{new BLabel(" " + LEX.getText("Presets") + " :"), bGridPane}), BBorder.inset, BInsets.make((double)BVideoPlayback.TOP_TOOL_PADDING));
    }

    public void doVideoPlaybackChanged() {
        if (this.videoPlayer.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.live) {
            if (this.joystick != null) {
                this.joystick.setVisible(true);
            }
            if (this.zoomSlider != null) {
                this.zoomSlider.setVisible(true);
            }
            this.bottomPane.setVisible(true);
        } else {
            if (this.joystick != null) {
                this.joystick.setVisible(false);
            }
            if (this.zoomSlider != null) {
                this.zoomSlider.setVisible(false);
            }
            this.bottomPane.setVisible(false);
        }
        this.relayout();
        this.repaint();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BVideoPtzDialogPane() {
        this((BIVideoCamera)null, (BWidget)null, (BRelTime)null, (BRelTime)null);
    }

    public BVideoPtzDialogPane(BIVideoCamera bIVideoCamera, BWidget bWidget) {
        this(bIVideoCamera, bWidget, BRelTime.makeSeconds((int)1), BRelTime.makeSeconds((int)1));
    }

    public BVideoPtzDialogPane(BIVideoCamera bIVideoCamera, BWidget bWidget, BRelTime bRelTime, BRelTime bRelTime2) {
        this(bIVideoCamera, bWidget, BSize.make((double)0.0, (double)0.0), BBorder.inset, bRelTime, Theme.scrollBar().getControlBackground(), bRelTime2, 25, new BPlaybackParams(BVideoPtzDialogPane.getBackgroundColor(bIVideoCamera), BVideoPtzDialogPane.getAspectRatio(bIVideoCamera), BVideoPtzDialogPane.getResolution(bIVideoCamera), BVideoPtzDialogPane.getFrameRate(bIVideoCamera), BVideoPtzDialogPane.getCompression(bIVideoCamera)), BVideoPtzDialogPane.getFoxStreamPreferred(bIVideoCamera));
    }

    public BVideoPtzDialogPane(BIVideoCamera bIVideoCamera, BWidget bWidget, BSize bSize, BPlaybackParams bPlaybackParams) {
        this.videoCamera = bIVideoCamera;
        this.bottomPane = null;
        this.preferedSize = bSize;
        BFoxVideoStreamEnum bFoxVideoStreamEnum = BVideoPtzDialogPane.getFoxStreamPreferred(bIVideoCamera);
        this.makeVideoPlayer(bWidget, 50, bPlaybackParams, bFoxVideoStreamEnum);
        this.setCenter((BWidget)new BBorderPane((BWidget)this.videoPlayer, BBorder.inset, BInsets.NULL));
        this.startVideoPlayerBinding();
    }

    public BVideoPtzDialogPane(BIVideoCamera bIVideoCamera, BWidget bWidget, BSize bSize, BBorder bBorder, BRelTime bRelTime, BBrush bBrush, BRelTime bRelTime2, int n, BPlaybackParams bPlaybackParams, BFoxVideoStreamEnum bFoxVideoStreamEnum) {
        Object object;
        this.videoCamera = bIVideoCamera;
        this.preferedSize = bSize;
        BUserService bUserService = (BUserService)BOrd.make((String)"service:baja:UserService").get((BObject)((BComponent)bIVideoCamera));
        bUserService.lease();
        Context context = null;
        try {
            object = BOrd.toSession((BObject)((BComponent)bIVideoCamera));
            if (object != null) {
                context = object.getSessionContext();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = ((BString)context.getFacet("username")).getString();
        BUser bUser = (BUser)bUserService.get((String)object);
        bUser.lease();
        BPermissions bPermissions = bUser.getPermissions(context);
        hasOperatorInvoke = bPermissions.hasOperatorInvoke();
        hasAdminInvoke = bPermissions.hasAdminInvoke();
        BComponent bComponent = (BComponent)bIVideoCamera;
        int n2 = 0;
        if ((bComponent.getFlags(bComponent.getSlot("move")) & 0x100) == 0) {
            n2 = 1;
        }
        isMoveOperatorFlag = 1 - n2;
        int n3 = 0;
        if ((bComponent.getFlags(bComponent.getSlot("zoom")) & 0x100) == 0) {
            n3 = 1;
        }
        isZoomOperatorFlag = 1 - n3;
        int n4 = 0;
        if ((bComponent.getFlags(bComponent.getSlot("irisControl")) & 0x100) == 0) {
            n4 = 1;
        }
        isIrisOperatorFlag = 1 - n4;
        int n5 = 0;
        if ((bComponent.getFlags(bComponent.getSlot("focusControl")) & 0x100) == 0) {
            n5 = 1;
        }
        isFocusOperatorFlag = 1 - n5;
        int n6 = 0;
        if ((bComponent.getFlags(bComponent.getSlot("moveToPreset")) & 0x100) == 0) {
            n6 = 1;
        }
        isMovePresetOperatorFlag = 1 - n6;
        int n7 = 0;
        if ((bComponent.getFlags(bComponent.getSlot("storePreset")) & 0x100) == 0) {
            n7 = 1;
        }
        isStorePresetOperatorFlag = 1 - n7;
        this.makePanTiltJoystick(bWidget, bBorder, bRelTime);
        this.makeZoomSlider(bWidget, bBorder, bBrush, bRelTime2);
        this.makeVideoPlayer(bWidget, n, bPlaybackParams, bFoxVideoStreamEnum);
        BPane bPane = this.overlayPanTiltJoystickOnVideoPlayer();
        this.setCenter((BWidget)bPane);
        if (this.isZoomAvailable()) {
            this.setRight(this.zoomSlider);
        }
        BPane bPane2 = BVideoPtzDialogPane.makeIrisFocusButtonPane((BWidget)this, null, bIVideoCamera, adjustIris, adjustFocus, true);
        BPane bPane3 = BVideoPtzDialogPane.makePresetsPane((BWidget)this, bIVideoCamera, true);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setColumnGap((double)5);
        bGridPane.setRowGap((double)5);
        if (bPane2 != null) {
            bGridPane.add("buttonPane", (BValue)bPane2);
        }
        if (bPane3 != null) {
            bGridPane.add("presetsPane", (BValue)bPane3);
        }
        this.bottomPane = new BBorderPane((BWidget)bGridPane, BInsets.make((double)1.0));
        this.setBottom((BWidget)this.bottomPane);
        this.setTop((BWidget)new BBorderPane((BWidget)this.makeTitlePane(), BInsets.make((double)3)));
        this.startVideoPlayerBinding();
        this.linkTo((BComponent)this.videoPlayer, (Slot)BVideoPlayer.reloadVideo, (Slot)videoPlaybackChanged);
        this.videoPlaybackChanged();
    }

    public BVideoPtzDialogPane(BVideoCameraWidget bVideoCameraWidget, BIVideoCamera bIVideoCamera) {
        this(bIVideoCamera, bVideoCameraWidget, bVideoCameraWidget.getPtzDialogSize(), bVideoCameraWidget.getPtzBorder(), bVideoCameraWidget.getPanTiltKeepDownInterval(), bVideoCameraWidget.getZoomBackground(), bVideoCameraWidget.getZoomKeepDownInterval(), bVideoCameraWidget.getRefreshRate(), new BPlaybackParams(bVideoCameraWidget.getResolution(), bVideoCameraWidget.getFrameRate(), bVideoCameraWidget.getStreamFacets()), bVideoCameraWidget.getVideoStreamFox());
    }

    static {
        Class clazz = class$com$tridium$videoDriver$ui$camera$BVideoPtzDialogPane;
        if (clazz == null) {
            clazz = class$com$tridium$videoDriver$ui$camera$BVideoPtzDialogPane = BVideoPtzDialogPane.class("[Lcom.tridium.videoDriver.ui.camera.BVideoPtzDialogPane;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$videoDriver$ui$camera$BVideoPtzDialogPane;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$videoDriver$ui$camera$BVideoPtzDialogPane = BVideoPtzDialogPane.class("[Lcom.tridium.videoDriver.ui.camera.BVideoPtzDialogPane;", false);
        }
        LEX = Lexicon.make((Class)clazz2);
        hasOperatorInvoke = false;
        hasAdminInvoke = false;
        isMoveOperatorFlag = false;
        isZoomOperatorFlag = false;
        isIrisOperatorFlag = false;
        isFocusOperatorFlag = false;
        isMovePresetOperatorFlag = false;
        isStorePresetOperatorFlag = false;
    }
}

