/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.camera;

import com.tridium.ui.PaintUtil;
import com.tridium.ui.theme.palladium.PalladiumButtonTheme;
import com.tridium.videoDriver.enums.BVideoPanTiltEnum;
import com.tridium.videoDriver.ui.camera.BVideoPtzCtrlPanel;
import com.tridium.videoDriver.ui.holdDownButton.BHoldDownButton;
import javax.baja.gx.BBrush;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.Point;
import javax.baja.gx.PolygonGeom;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.event.BMouseEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BVideoPanTiltArrowButton
extends BHoldDownButton {
    public static final Property numArrows = BVideoPanTiltArrowButton.newProperty((int)0, (int)1, null);
    public static final Property direction = BVideoPanTiltArrowButton.newProperty((int)0, (int)6, null);
    public static final Type TYPE;
    protected static Point noOffset;
    protected static Point pressedOffset;
    private static final double PERCENTAGE_EMPTY_PER_ARROW = 0.25;
    private static final double HALF_PERCENTAGE_EMPTY_PER_ARROW = 0.125;
    protected DiagonalButtonScheme dbs;
    private boolean mousePressed;
    static /* synthetic */ Class class$com$tridium$videoDriver$ui$camera$BVideoPanTiltArrowButton;

    public int getNumArrows() {
        return this.getInt(numArrows);
    }

    public void setNumArrows(int n) {
        this.setInt(numArrows, n, null);
    }

    public int getDirection() {
        return this.getInt(direction);
    }

    public void setDirection(int n) {
        this.setInt(direction, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected Point computeMidpoint(Point point, Point point2) {
        double d = point.x();
        double d2 = point.y();
        double d3 = point2.x();
        double d4 = point2.y();
        return new Point((d + d3) / (double)2, (d2 + d4) / (double)2);
    }

    protected double computeSlope(Point point, Point point2) {
        return (point2.y - point.y) / (point2.x - point.x);
    }

    protected double computeB(Point point, Point point2) {
        double d = this.computeSlope(point, point2);
        return this.computeB(d, point);
    }

    protected double computeB(double d, Point point) {
        return -1.0 * d * point.x + point.y;
    }

    protected double computeDistance(Point point, Point point2) {
        double d = point2.x() - point.x();
        double d2 = point2.y() - point.y();
        double d3 = d * d;
        double d4 = d2 * d2;
        return Math.sqrt(d3 + d4);
    }

    protected void drawArrowLine(Graphics graphics, Point point, Point point2) {
        Point point3 = new Point();
        Point point4 = new Point();
        point3.x = this.computeStartArrowX(point, point2);
        point4.x = this.computeEndArrowX(point, point2);
        double d = this.computeSlope(point, point2);
        double d2 = this.computeB(d, point);
        point3.y = d * point3.x + d2;
        point4.y = d * point4.x + d2;
        graphics.strokeLine(point3.x, point3.y, point4.x, point4.y);
    }

    protected void drawArrowHashes(Graphics graphics, Line line, Line line2, Line line3) {
        int n = this.getNumArrows();
        boolean bl = this.isRightToLeft();
        int n2 = 0;
        while (n2 < n) {
            Line line4 = line.getLineDivision(n2, n);
            Line line5 = line4.getPaddedLine();
            Point point = line5.computeMidpoint();
            Line line6 = bl ? new Line(line5.p1, point) : new Line(line5.p2, point);
            Point point2 = line6.computeMidpoint();
            Point point3 = bl ? line5.p1 : line5.p2;
            Point point4 = bl ? line5.p2 : line5.p1;
            Point point5 = new Point();
            Point point6 = new Point();
            if (this.isDiagonalArrow()) {
                double d = line2.computeSlope();
                double d2 = line2.computeB();
                double d3 = d;
                double d4 = line3.computeB();
                double d5 = -1.0 / d;
                double d6 = this.computeB(d5, point4);
                point5.x = (d6 - d2) / (d - d5);
                point5.y = d * point5.x + d2;
                point6.x = (d6 - d4) / (d3 - d5);
                point6.y = d3 * point6.x + d4;
            } else if (this.isHorizontalArrow()) {
                point5.x = point2.x;
                point5.y = line2.p1.y;
                point6.x = point2.x;
                point6.y = line3.p1.y;
            } else if (this.isVerticalArrow()) {
                point5.x = line2.p1.x;
                point5.y = point2.y;
                point6.x = line3.p1.x;
                point6.y = point2.y;
            } else {
                throw new IllegalStateException("Unrecognized arrow orientation");
            }
            Line line7 = new Line(point3, this.computeMidpoint(point4, point5));
            Line line8 = new Line(point3, this.computeMidpoint(point4, point6));
            line7.draw(graphics);
            line8.draw(graphics);
            ++n2;
        }
    }

    protected void drawArrowHashes(Graphics graphics, Point point, Point point2, Point point3, Point point4) {
        Line line;
        Line line2;
        Line line3;
        int n = this.getDirection();
        switch (n) {
            case 7: {
                line3 = new Line(this.computeMidpoint(point3, point4), this.computeMidpoint(point, point2));
                line2 = new Line(point3, point);
                line = new Line(point4, point2);
                break;
            }
            case 3: {
                line3 = new Line(this.computeMidpoint(point, point2), this.computeMidpoint(point3, point4));
                line2 = new Line(point, point3);
                line = new Line(point2, point4);
                break;
            }
            case 1: {
                line3 = new Line(this.computeMidpoint(point3, point), this.computeMidpoint(point4, point2));
                line2 = new Line(point2, point);
                line = new Line(point4, point3);
                break;
            }
            case 9: {
                line3 = new Line(this.computeMidpoint(point, point3), this.computeMidpoint(point2, point4));
                line2 = new Line(point, point2);
                line = new Line(point3, point4);
                break;
            }
            case 8: {
                line3 = new Line(point3, point2);
                line2 = new Line(new Point(point3.x * 0.2, point3.y), new Point(point2.x * 0.2, point2.y));
                line = new Line(new Point(point3.x * 1.8, point3.y), new Point(point2.x * 1.8, point2.y));
                break;
            }
            case 2: {
                line3 = new Line(point2, point3);
                line2 = new Line(new Point(point2.x * 0.2, point2.y), new Point(point3.x * 0.2, point3.y));
                line = new Line(new Point(point2.x * 1.8, point2.y), new Point(point3.x * 1.8, point3.y));
                break;
            }
            case 6: {
                line3 = new Line(point, point4);
                line2 = new Line(new Point(point.x, point.y * 0.2), new Point(point4.x, point4.y * 0.2));
                line = new Line(new Point(point.x, point.y * 1.8), new Point(point4.x, point4.y * 1.8));
                line3 = line3.getPaddedLine();
                line2 = line2.getPaddedLine();
                line = line.getPaddedLine();
                break;
            }
            case 4: {
                line3 = new Line(point4, point);
                line2 = new Line(new Point(point4.x, point4.y * 0.2), new Point(point.x, point.y * 0.2));
                line = new Line(new Point(point4.x, point4.y * 1.8), new Point(point.x, point.y * 1.8));
                line3 = line3.getPaddedLine();
                line2 = line2.getPaddedLine();
                line = line.getPaddedLine();
                break;
            }
            default: {
                throw new IllegalArgumentException("Direction must be 1,2,3,4,6,7,8,9; not " + n);
            }
        }
        this.drawArrowHashes(graphics, line3.getPaddedLine(), line2.getPaddedLine(), line.getPaddedLine());
    }

    protected boolean isRightToLeft() {
        int n = this.getDirection();
        switch (n) {
            case 1: 
            case 4: 
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
        }
        return false;
    }

    protected boolean isDiagonalArrow() {
        int n = this.getDirection();
        switch (n) {
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    protected boolean isHorizontalArrow() {
        int n = this.getDirection();
        switch (n) {
            case 4: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    protected boolean isVerticalArrow() {
        int n = this.getDirection();
        switch (n) {
            case 2: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    protected void drawArrowLines(Graphics graphics, Line line, int n) {
        int n2 = 0;
        while (n2 < n) {
            line.getLineDivision(n2, n).getPaddedLine().draw(graphics);
            ++n2;
        }
    }

    protected void drawArrows(Graphics graphics) {
        BBrush bBrush = this.dbs.getTextBrush(this.getEnabled());
        graphics.setBrush(bBrush);
        graphics.setPen(BPen.make((double)1.0));
        double d = this.getWidth();
        double d2 = this.getHeight();
        if (d > d2) {
            d = d2;
        }
        if (d2 > d) {
            d2 = d;
        }
        double d3 = d / (double)2;
        double d4 = d2 / (double)2;
        Point point = new Point(0.0, d4);
        Point point2 = new Point(d3, 0.0);
        Point point3 = new Point(d - 1.0, d4);
        Point point4 = new Point(d3, d2 - 1.0);
        this.drawArrowHashes(graphics, point, point2, point4, point3);
    }

    public double computeStartArrowX(Point point, Point point2) {
        double d = point.x();
        double d2 = point2.x();
        return d + 0.125 * (d2 - d);
    }

    public double computeStartArrowY(Point point, Point point2) {
        double d = point.y();
        double d2 = point2.y();
        return d + 0.125 * (d2 - d);
    }

    public double computeEndArrowX(Point point, Point point2) {
        double d = point.x();
        double d2 = point2.x();
        return d2 - 0.125 * (d2 - d);
    }

    public double computeEndArrowY(Point point, Point point2) {
        double d = point.y();
        double d2 = point2.y();
        return d2 - 0.125 * (d2 - d);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.useAntiAliasing(true);
        this.drawArrows(graphics);
    }

    protected void paintDiamondBackground(Graphics graphics) {
        graphics.useAntiAliasing(true);
        BVideoPanTiltArrowButton bVideoPanTiltArrowButton = this;
        boolean bl = bVideoPanTiltArrowButton.getEnabled();
        boolean bl2 = bVideoPanTiltArrowButton.isMouseOver();
        boolean bl3 = bVideoPanTiltArrowButton.isPressed();
        boolean bl4 = bVideoPanTiltArrowButton.isMenuPressed();
        boolean bl5 = false;
        if (bVideoPanTiltArrowButton.getMenuController() != null) {
            bl5 = true;
        }
        boolean bl6 = bl5;
        boolean bl7 = false;
        if (bl6) {
            bl7 = bVideoPanTiltArrowButton.getMenuController().isMenuDistinct();
        }
        boolean bl8 = bl7;
        boolean bl9 = false;
        graphics.setPen(BPen.make((double)1.0));
        double d = bVideoPanTiltArrowButton.getWidth();
        double d2 = bVideoPanTiltArrowButton.getHeight();
        if (d > d2) {
            d = d2;
        } else if (d2 > d) {
            d2 = d;
        }
        double d3 = this.getMenuWidth();
        if (bl6) {
            d -= this.getMenuWidth();
        }
        boolean bl10 = true;
        boolean bl11 = true;
        if (!bl6) {
            bl8 = true;
        }
        if (!(bVideoPanTiltArrowButton.getButtonStyle() != BButtonStyle.toolBar || bl2 && bl || bl4)) {
            bl10 = false;
            if (!bl9) {
                bl11 = false;
            }
        }
        double d4 = d / (double)2;
        double d5 = d2 / (double)2;
        graphics.setBrush(this.dbs.getBackground((BAbstractButton)bVideoPanTiltArrowButton, bl3, bl9));
        graphics.fill((IGeom)new PolygonGeom(new double[]{1.0, d4, d - (double)2, d4}, new double[]{d5, 1.0, d5, d2 - (double)2}, 4));
        if (bl10) {
            if (bl) {
                graphics.setBrush(this.dbs.getControlForeground());
            } else {
                graphics.setBrush(this.dbs.getControlShadow());
            }
            double[] dArray = new double[4];
            dArray[1] = d4;
            dArray[2] = d - 1.0;
            dArray[3] = d4;
            double[] dArray2 = new double[4];
            dArray2[0] = d5;
            dArray2[2] = d5;
            dArray2[3] = d2 - 1.0;
            graphics.stroke((IGeom)new PolygonGeom(dArray, dArray2, 4));
        }
        if (bl11) {
            if (bl4 && !bl8 || !bl4 && bl3 && bl2 || bl9) {
                graphics.setBrush(this.dbs.getControlShadow());
            } else {
                graphics.setBrush(this.dbs.getControlHighlight());
            }
            graphics.strokeLine((double)2, d5, d4, (double)2);
            graphics.strokeLine(d4, (double)2, d - (double)3, d5);
            if (bl || bl9) {
                graphics.setBrush(this.dbs.getControlShadow());
            } else {
                graphics.setBrush(this.dbs.getControlAuxiliary());
            }
            graphics.strokeLine((double)2, d5, d4, d2 - (double)3);
            graphics.strokeLine(d4, d2 - (double)3, d - (double)3, d5);
            if (bl6 && bl8 && (bVideoPanTiltArrowButton.getButtonStyle() != BButtonStyle.toolBar || bl3 || bl2)) {
                graphics.strokeLine(d + d3 - (double)2, 1.0, d + d3 - (double)2, d2 - (double)2);
                graphics.strokeLine(d, d2 - (double)2, d + d3 - (double)2, d2 - (double)2);
            }
        }
        if (bVideoPanTiltArrowButton.hasFocus() && bVideoPanTiltArrowButton.getButtonStyle() != BButtonStyle.toolBar) {
            this.dbs.paintFocus(graphics, new RectGeom((double)3, (double)3, d - 7.0, d2 - 7.0));
        }
        this.dbs.paintDefaultBorder(graphics, (BAbstractButton)bVideoPanTiltArrowButton, bl3);
        graphics.useAntiAliasing(false);
    }

    public void paintBackground(Graphics graphics) {
        if (this.isDiagonalArrow()) {
            this.paintDiamondBackground(graphics);
        } else {
            super.paintBackground(graphics);
        }
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        if (this.isDiagonalArrow()) {
            if (this.isMouseInButton(bMouseEvent)) {
                this.mousePressed = true;
                super.mousePressed(bMouseEvent);
            }
        } else {
            this.mousePressed = true;
            super.mousePressed(bMouseEvent);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mouseReleased(BMouseEvent bMouseEvent) {
        try {
            if (this.mousePressed) {
                super.mouseReleased(bMouseEvent);
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mousePressed = false;
            throw throwable;
        }
        {
            Object var3_4 = null;
            this.mousePressed = false;
            return;
        }
    }

    protected boolean isMouseInButton(BMouseEvent bMouseEvent) {
        if (this.isDiagonalArrow()) {
            double d;
            double d2 = bMouseEvent.getX();
            double d3 = bMouseEvent.getY();
            double d4 = this.getWidth();
            if (d4 > (d = this.getHeight())) {
                d4 = d;
            } else if (d > d4) {
                d = d4;
            }
            double d5 = d4 / (double)2;
            double d6 = d / (double)2;
            PolygonGeom polygonGeom = new PolygonGeom(new double[]{1.0, d5, d4 - (double)2, d5}, new double[]{d6, 1.0, d6, d - (double)2}, 4);
            return polygonGeom.contains(d2, d3);
        }
        throw new IllegalStateException("Should only compute 'isMouseInButton' for diamond button mode.");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.dbs = new DiagonalButtonScheme();
        this.mousePressed = false;
    }

    public BVideoPanTiltArrowButton() {
        this.this();
    }

    public BVideoPanTiltArrowButton(BVideoPtzCtrlPanel bVideoPtzCtrlPanel, BVideoPanTiltEnum bVideoPanTiltEnum, BVideoPanTiltEnum bVideoPanTiltEnum2, int n, int n2) {
        super((BWidget)bVideoPtzCtrlPanel, BVideoPtzCtrlPanel.move, (BValue)bVideoPanTiltEnum, (BValue)bVideoPanTiltEnum2);
        this.this();
        this.setNumArrows(n);
        this.setDirection(n2);
    }

    static {
        Class clazz = class$com$tridium$videoDriver$ui$camera$BVideoPanTiltArrowButton;
        if (clazz == null) {
            clazz = class$com$tridium$videoDriver$ui$camera$BVideoPanTiltArrowButton = BVideoPanTiltArrowButton.class("[Lcom.tridium.videoDriver.ui.camera.BVideoPanTiltArrowButton;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        noOffset = new Point(0.0, 0.0);
        pressedOffset = new Point(1.0, 1.0);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Line {
        Point p1;
        Point p2;

        double computeSlope() {
            return BVideoPanTiltArrowButton.this.computeSlope(this.p1, this.p2);
        }

        double computeB() {
            return BVideoPanTiltArrowButton.this.computeB(this.p1, this.p2);
        }

        Point computeMidpoint() {
            return BVideoPanTiltArrowButton.this.computeMidpoint(this.p1, this.p2);
        }

        double dx() {
            return Math.abs(this.p1.x - this.p2.x);
        }

        double dy() {
            return Math.abs(this.p1.y - this.p2.y);
        }

        void draw(Graphics graphics) {
            graphics.strokeLine(this.p1.x, this.p1.y, this.p2.x, this.p2.y);
        }

        Line getPaddedLine() {
            double d = this.computeSlope();
            double d2 = this.computeB();
            Point point = new Point();
            Point point2 = new Point();
            double d3 = this.dx();
            if (d3 < 1.0E-4 && this.dx() > -1.0E-4) {
                point.x = this.p1.x;
                point.y = BVideoPanTiltArrowButton.this.computeStartArrowY(this.p1, this.p2);
                point2.x = this.p2.x;
                point2.y = BVideoPanTiltArrowButton.this.computeEndArrowY(this.p1, this.p2);
                return new Line(point, point2);
            }
            point.x = BVideoPanTiltArrowButton.this.computeStartArrowX(this.p1, this.p2);
            point.y = d * point.x + d2;
            point2.x = BVideoPanTiltArrowButton.this.computeEndArrowX(this.p1, this.p2);
            point2.y = d * point2.x + d2;
            return new Line(point, point2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Line getLineDivision(int n, int n2) {
            double d = n;
            double d2 = n2;
            double d3 = this.dx();
            double d4 = this.computeB();
            double d5 = this.computeSlope();
            Point point = new Point();
            Point point2 = new Point();
            if (d3 < 1.0E-4 && d3 > -1.0E-4) {
                if (!(this.p1.y < this.p2.y)) return new Line(this.p2, this.p1).getLineDivision(n, n2);
                double d6 = this.dy();
                point.x = this.p1.x;
                point.y = this.p1.y + d / d2 * d6;
                point2.x = this.p2.x;
                point2.y = this.p1.y + (d + 1.0) / d2 * d6;
                return new Line(point, point2);
            } else {
                if (!(this.p1.x < this.p2.x)) return new Line(this.p2, this.p1).getLineDivision(n, n2);
                point.x = this.p1.x + d / d2 * d3;
                point.y = d5 * point.x + d4;
                point2.x = this.p1.x + (d + 1.0) / d2 * d3;
                point2.y = d5 * point2.x + d4;
            }
            return new Line(point, point2);
        }

        Line(Point point, Point point2) {
            this.p1 = point;
            this.p2 = point2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DiagonalButtonScheme
    extends PalladiumButtonTheme {
        public BBrush getBackground(BAbstractButton bAbstractButton, boolean bl, boolean bl2) {
            return super.getBackground(bAbstractButton, bl, bl2);
        }

        public void paintDefaultBorder(Graphics graphics, BAbstractButton bAbstractButton, boolean bl) {
            super.paintDefaultBorder(graphics, bAbstractButton, bl);
        }

        public void paintFocus(Graphics graphics, PolygonGeom polygonGeom) {
            graphics.setBrush(focusBrush);
            double[] dArray = polygonGeom.x();
            double[] dArray2 = polygonGeom.y();
            if (dArray.length > 1) {
                int n = 0;
                while (n < dArray.length - 1) {
                    PaintUtil.drawDashedLine((Graphics)graphics, (double)dArray[n], (double)dArray2[n], (double)dArray[n + 1], (double)dArray2[n + 1]);
                    ++n;
                }
            }
        }

        DiagonalButtonScheme() {
        }
    }
}

