/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.alarm;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.BStationRecipient;
import com.tridium.videoDriver.alarm.BIVideoAlarmRecorder;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.camera.control.BIVideoMoveToPresetControl;
import com.tridium.videoDriver.display.BIVideoDisplay;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import com.tridium.videoDriver.ui.display.BIVideoDisplayLayout;
import javax.baja.agent.AgentList;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.collection.BICollection;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BVideoAlarmRecipient
extends BConsoleRecipient {
    public static final Property presetOnNormal = BVideoAlarmRecipient.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE;
    protected static Worker backgroundWorker;
    protected static Queue backgroundQueue;
    public static final Log log;
    protected BAlarmService alarmService;
    static /* synthetic */ Class class$com$tridium$videoDriver$alarm$BVideoAlarmRecipient;
    static /* synthetic */ Class class$com$tridium$alarm$BStationRecipient;
    static /* synthetic */ Class class$java$lang$String;

    public boolean getPresetOnNormal() {
        return this.getBoolean(presetOnNormal);
    }

    public void setPresetOnNormal(boolean bl) {
        this.setBoolean(presetOnNormal, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected static BStationRecipient[] filterStationRecipientsForAlarmClass(String string, BStationRecipient[] bStationRecipientArray) {
        Class clazz = class$com$tridium$alarm$BStationRecipient;
        if (clazz == null) {
            clazz = class$com$tridium$alarm$BStationRecipient = BVideoAlarmRecipient.class("[Lcom.tridium.alarm.BStationRecipient;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < bStationRecipientArray.length) {
            String[] stringArray = BVideoAlarmRecipient.getAlarmClassesForRecipient((BAlarmRecipient)bStationRecipientArray[n]);
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equals(string)) {
                    array.add((Object)bStationRecipientArray[n]);
                    break;
                }
                ++n2;
            }
            ++n;
        }
        return (BStationRecipient[])array.trim();
    }

    protected BStationRecipient[] getStationRecipients() {
        BICollection bICollection = (BICollection)BOrd.make((String)"slot:/|bql:select from alarm:StationRecipient").get((BObject)this);
        Class clazz = class$com$tridium$alarm$BStationRecipient;
        if (clazz == null) {
            clazz = class$com$tridium$alarm$BStationRecipient = BVideoAlarmRecipient.class("[Lcom.tridium.alarm.BStationRecipient;", false);
        }
        Array array = new Array(clazz);
        Cursor cursor = bICollection.cursor();
        while (cursor.next()) {
            array.add((Object)cursor.get());
        }
        return (BStationRecipient[])array.trim();
    }

    protected static String[] getAlarmClassesForRecipient(BAlarmRecipient bAlarmRecipient) {
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = BVideoAlarmRecipient.class("[Ljava.lang.String;", false);
        }
        Array array = new Array(clazz);
        Object[] objectArray = bAlarmRecipient.getSubscribedAlarmClasses();
        array.addAll(objectArray);
        int n = 1;
        while (n <= 3) {
            Object[] objectArray2 = bAlarmRecipient.getSubscribedEscalatedAlarmClasses(n);
            array.addAll(objectArray2);
            ++n;
        }
        return (String[])array.trim();
    }

    public void started() throws Exception {
        super.started();
        if (backgroundQueue == null) {
            backgroundQueue = new Queue();
            backgroundWorker = new Worker((Worker.ITodo)backgroundQueue);
            backgroundWorker.start("VideoAlarmRecipient.worker");
        }
    }

    public void handleAlarm(BAlarmRecord bAlarmRecord) {
        super.handleAlarm(bAlarmRecord);
        BObject bObject = this.getCameraObject(bAlarmRecord);
        if (bObject != null) {
            this.addFieldDeviceCameraTime(bAlarmRecord, bObject);
            if (this.getStartRecording(bAlarmRecord)) {
                this.startRecording(bAlarmRecord, bObject);
            }
            if (BVideoAlarmRecipient.isVideoAlarm(bAlarmRecord) && this.getSendAlarmToDisplay(bAlarmRecord)) {
                this.sendAlarmToDisplay(bAlarmRecord, bObject);
            }
        }
    }

    protected BAlarmService getAlarmService() {
        if (this.alarmService == null) {
            this.alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        }
        return this.alarmService;
    }

    protected void addFieldDeviceCameraTime(BAlarmRecord bAlarmRecord, BObject bObject) {
        BFacets bFacets = bAlarmRecord.getAlarmData();
        BAbsTime bAbsTime = (BAbsTime)bFacets.get("videoEventTimestamp");
        if ((bAbsTime == null || bAbsTime.isNull()) && bObject instanceof BIVideoCamera) {
            backgroundQueue.enqueue((Object)new AddFieldDeviceCameraTimeRunnable(bAlarmRecord, bObject));
        }
    }

    protected static boolean isVideoAlarm(BAlarmRecord bAlarmRecord) {
        String string = bAlarmRecord.getAlarmData().gets("cameraOrd", null);
        String string2 = bAlarmRecord.getAlarmData().gets("cameraHandleOrd", null);
        boolean bl = false;
        if (string == null && string2 == null) {
            bl = true;
        }
        return bl ^ true;
    }

    protected void startRecording(final BAlarmRecord bAlarmRecord, final BObject bObject) {
        Runnable runnable = new Runnable(){

            public final void run() {
                boolean bl;
                BValue bValue = BVideoAlarmRecipient.this.getCameraPreset(bAlarmRecord);
                if (bValue != null && bObject instanceof BIVideoMoveToPresetControl && (!(bl = bAlarmRecord.isNormal()) || BVideoAlarmRecipient.this.getPresetOnNormal())) {
                    ((BIVideoMoveToPresetControl)bObject).moveToPreset(bValue);
                }
                if (bObject instanceof BIVideoAlarmRecorder) {
                    ((BIVideoAlarmRecorder)bObject).startRecordingAlarm(bAlarmRecord);
                }
            }
        };
        backgroundQueue.enqueue((Object)runnable);
    }

    protected void sendAlarmToDisplay(final BAlarmRecord bAlarmRecord, final BObject bObject) {
        Runnable runnable = new Runnable(){

            public final void run() {
                if (bObject != null && bObject instanceof BIVideoCamera) {
                    BIVideoCamera bIVideoCamera = (BIVideoCamera)bObject;
                    BIVideoDvr bIVideoDvr = bIVideoCamera.getDvr();
                    if (bIVideoDvr == null) {
                        return;
                    }
                    BIVideoDisplay[] bIVideoDisplayArray = bIVideoCamera.getDvr().getDisplayExt().getAllDisplays();
                    if (bIVideoDisplayArray.length > 0) {
                        BIVideoDisplay bIVideoDisplay = bIVideoDisplayArray[0];
                        if (bIVideoDisplay == null) {
                            return;
                        }
                        BFrozenEnum bFrozenEnum = bIVideoDisplay.getVideoDisplayMultistream().getLayout();
                        if (bFrozenEnum instanceof BIVideoDisplayLayout) {
                            BIVideoDisplayLayout bIVideoDisplayLayout = ((BIVideoDisplayLayout)bFrozenEnum).getSingleSegmentLayout();
                            bIVideoDisplay.switchToLayout(bIVideoDisplayLayout);
                            BOrd bOrd = bObject.asComponent().getHandleOrd();
                            bIVideoDisplay.mapCamerasToLayout(new BOrd[]{bOrd}, bIVideoDisplayLayout);
                            BAbsTime bAbsTime = bAlarmRecord.getTimestamp();
                            bIVideoDisplay.gotoPlaybackTime(bAbsTime);
                        }
                    }
                }
            }
        };
        backgroundQueue.enqueue((Object)runnable);
    }

    protected BValue getCameraPreset(BAlarmRecord bAlarmRecord) {
        return (BValue)bAlarmRecord.getAlarmData().get("cameraPreset");
    }

    protected boolean getStartRecording(BAlarmRecord bAlarmRecord) {
        return bAlarmRecord.getAlarmData().getb("startRecording", true);
    }

    protected boolean getSendAlarmToDisplay(BAlarmRecord bAlarmRecord) {
        return bAlarmRecord.getAlarmData().getb("sendAlarmToDisplay", false);
    }

    protected BObject getCameraObject(BAlarmRecord bAlarmRecord) {
        BObject bObject;
        String string = bAlarmRecord.getAlarmData().gets("cameraOrd", null);
        if (string != null) {
            BOrd bOrd;
            try {
                bOrd = BOrd.make((String)string);
            }
            catch (Exception exception) {
                bOrd = null;
            }
            if (bOrd == null || bOrd.equals((Object)BOrd.NULL)) {
                bObject = null;
            } else {
                try {
                    bObject = bOrd.get((BObject)this);
                }
                catch (Exception exception) {
                    bObject = null;
                }
            }
        } else {
            bObject = null;
        }
        return bObject;
    }

    public AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        int n = agentList.indexOf("alarm:AlarmConsole");
        if (n != -1) {
            agentList.remove(n);
        }
        return agentList;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$videoDriver$alarm$BVideoAlarmRecipient;
        if (clazz == null) {
            clazz = class$com$tridium$videoDriver$alarm$BVideoAlarmRecipient = BVideoAlarmRecipient.class("[Lcom.tridium.videoDriver.alarm.BVideoAlarmRecipient;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"alarm.videoAlarmRecipient");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class AddFieldDeviceCameraTimeRunnable
    implements Runnable {
        protected long startTicks;
        protected BAlarmRecord alarmRecord;
        protected BObject cameraObject;

        public void run() {
            BIVideoCamera bIVideoCamera = (BIVideoCamera)this.cameraObject;
            BAbsTime bAbsTime = bIVideoCamera.getCameraTime();
            if (bAbsTime != null && !bAbsTime.isNull()) {
                BFacets bFacets = this.alarmRecord.getAlarmData();
                long l = Clock.ticks() - this.startTicks;
                if (l < 0L) {
                    l = 0L;
                }
                bAbsTime = bAbsTime.subtract(BRelTime.make((long)l));
                BFacets bFacets2 = BFacets.make((String)"videoEventTimestamp", (BIDataValue)bAbsTime);
                this.alarmRecord.setAlarmData(BFacets.make((BFacets)bFacets, (BFacets)bFacets2));
                BAlarmService bAlarmService = BVideoAlarmRecipient.this.getAlarmService();
                try {
                    bAlarmService.getAlarmDb().update(this.alarmRecord);
                    this.reRouteToStationRecipients();
                }
                catch (Exception exception) {
                    log.error("Cannot add field-device camera time to alarm.", (Throwable)exception);
                }
            }
        }

        protected void reRouteToStationRecipients() {
            BStationRecipient[] bStationRecipientArray = BVideoAlarmRecipient.this.getStationRecipients();
            String[] stringArray = BVideoAlarmRecipient.getAlarmClassesForRecipient((BAlarmRecipient)BVideoAlarmRecipient.this);
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                BStationRecipient[] bStationRecipientArray2 = BVideoAlarmRecipient.filterStationRecipientsForAlarmClass(string, bStationRecipientArray);
                int n2 = 0;
                while (n2 < bStationRecipientArray2.length) {
                    try {
                        bStationRecipientArray2[n2].routeAlarm(this.alarmRecord);
                    }
                    catch (RuntimeException runtimeException) {
                        log.error("Unable to re-route updated alarm record to station recipient. Alarm record = [" + this.alarmRecord + "] station recipient = [" + bStationRecipientArray2[n2].getSlotPath() + ']', (Throwable)runtimeException);
                    }
                    ++n2;
                }
                ++n;
            }
        }

        public AddFieldDeviceCameraTimeRunnable(BAlarmRecord bAlarmRecord, BObject bObject) {
            this.alarmRecord = bAlarmRecord;
            this.cameraObject = bObject;
            this.startTicks = Clock.ticks();
        }
    }
}

