/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.alarm;

import com.tridium.videoDriver.alarm.BIVideoAlarmRecorder;
import com.tridium.videoDriver.camera.BIRemoteVideoCamera;
import com.tridium.videoDriver.camera.control.BIVideoMoveToPresetControl;
import javax.baja.agent.AgentList;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BVideoAlarmExtParameters
extends BComponent {
    public static final Property videoCamera = BVideoAlarmExtParameters.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property startRecording = BVideoAlarmExtParameters.newProperty((int)8, (BValue)new BStatusBoolean(true), null);
    public static final Property gotoPreset = BVideoAlarmExtParameters.newProperty((int)0, (boolean)false, null);
    public static final Property cameraPreset = BVideoAlarmExtParameters.newProperty((int)0, (BValue)BString.make((String)""), null);
    public static final Property wasThisAlarmExtParametersJustAdded = BVideoAlarmExtParameters.newProperty((int)69, (boolean)false, null);
    public static final Property sendAlarmToDisplay = BVideoAlarmExtParameters.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE;
    private static final BIcon icon;
    protected AlarmExtSubscriber alarmExtSubscriber;
    protected BAlarmSourceExt alarmSourceExt;
    static /* synthetic */ Class class$com$tridium$videoDriver$alarm$BVideoAlarmExtParameters;

    public BOrd getVideoCamera() {
        return (BOrd)this.get(videoCamera);
    }

    public void setVideoCamera(BOrd bOrd) {
        this.set(videoCamera, (BValue)bOrd, null);
    }

    public BStatusBoolean getStartRecording() {
        return (BStatusBoolean)this.get(startRecording);
    }

    public void setStartRecording(BStatusBoolean bStatusBoolean) {
        this.set(startRecording, (BValue)bStatusBoolean, null);
    }

    public boolean getGotoPreset() {
        return this.getBoolean(gotoPreset);
    }

    public void setGotoPreset(boolean bl) {
        this.setBoolean(gotoPreset, bl, null);
    }

    public BValue getCameraPreset() {
        return this.get(cameraPreset);
    }

    public void setCameraPreset(BValue bValue) {
        this.set(cameraPreset, bValue, null);
    }

    public boolean getWasThisAlarmExtParametersJustAdded() {
        return this.getBoolean(wasThisAlarmExtParametersJustAdded);
    }

    public void setWasThisAlarmExtParametersJustAdded(boolean bl) {
        this.setBoolean(wasThisAlarmExtParametersJustAdded, bl, null);
    }

    public boolean getSendAlarmToDisplay() {
        return this.getBoolean(sendAlarmToDisplay);
    }

    public void setSendAlarmToDisplay(boolean bl) {
        this.setBoolean(sendAlarmToDisplay, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        agentList.add("workbench:NavMenuAgent");
        return agentList;
    }

    public void started() {
        this.alarmExtSubscriber = new AlarmExtSubscriber();
        this.autoConfigureCamera();
        this.mergeMetaData();
    }

    protected BIVideoAlarmRecorder getParentCamera() {
        BComplex bComplex = this.getParent();
        while (bComplex != null && !(bComplex instanceof BIVideoAlarmRecorder)) {
            bComplex = bComplex.getParent();
        }
        return (BIVideoAlarmRecorder)bComplex;
    }

    protected void autoConfigureCamera() {
        BIVideoAlarmRecorder bIVideoAlarmRecorder = this.getParentCamera();
        if (bIVideoAlarmRecorder != null) {
            if (bIVideoAlarmRecorder instanceof BComponent) {
                this.setVideoCamera(BOrd.make((String)("station:|" + ((BComponent)bIVideoAlarmRecorder).getSlotPathOrd().toString())));
            } else {
                throw new IllegalStateException("Nav ancestor is a BIVideoAlarmRecorder but is not a BComponent.");
            }
        }
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && context != Context.decoding) {
            if (property.equals((Object)videoCamera)) {
                try {
                    BObject bObject = this.getVideoCamera().get((BObject)this);
                    if (bObject instanceof BComponent) {
                        BComponent bComponent = (BComponent)bObject;
                        if (bObject instanceof BIVideoMoveToPresetControl) {
                            BIVideoMoveToPresetControl bIVideoMoveToPresetControl = (BIVideoMoveToPresetControl)bObject;
                            Action action = bIVideoMoveToPresetControl.getMoveToPresetAction();
                            BValue bValue = bComponent.getActionParameterDefault(action);
                            this.setCameraPreset(bValue);
                        }
                    }
                }
                catch (Exception exception) {}
            }
            this.mergeMetaData();
        }
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BAlarmSourceExt;
    }

    public boolean isNavChild() {
        Property property = this.getPropertyInParent();
        if (property == null) {
            return false;
        }
        BComplex bComplex = this.getParent();
        if (bComplex == null) {
            return false;
        }
        BFacets bFacets = bComplex.getSlotFacets((Slot)property);
        boolean bl = bFacets.getb("forceNav", false);
        return bl;
    }

    public BAlarmSourceExt getAlarmExt() {
        if (this.alarmSourceExt == null) {
            this.alarmSourceExt = (BAlarmSourceExt)this.getParent();
        }
        return this.alarmSourceExt;
    }

    protected void cleanupMetaData() {
        BFacets bFacets = this.getAlarmExt().getMetaData();
        BFacets bFacets2 = bFacets;
        if (bFacets2.get("cameraOrd") != null) {
            bFacets2 = BFacets.makeRemove((BFacets)bFacets2, (String)"cameraOrd");
        }
        if (bFacets2.get("cameraHandleOrd") != null) {
            bFacets2 = BFacets.makeRemove((BFacets)bFacets2, (String)"cameraHandleOrd");
        }
        if (bFacets2.get("cameraPreset") != null) {
            bFacets2 = BFacets.makeRemove((BFacets)bFacets2, (String)"cameraPreset");
        }
        if (bFacets2.get("startRecording") != null) {
            bFacets2 = BFacets.makeRemove((BFacets)bFacets2, (String)"startRecording");
        }
        if (bFacets2 != bFacets) {
            this.getAlarmExt().setMetaData(bFacets2);
        }
    }

    protected String getAbsoluteOrdSting(BComponent bComponent) {
        BOrd bOrd = bComponent.getAbsoluteOrd();
        String string = bOrd.toString();
        if (string.startsWith("local:|")) {
            return string.substring(7);
        }
        return string;
    }

    protected BOrd checkForRemoteCameraOrd(BOrd bOrd, BComponent bComponent, boolean bl) {
        if (bComponent instanceof BIRemoteVideoCamera) {
            BIRemoteVideoCamera bIRemoteVideoCamera = (BIRemoteVideoCamera)bComponent;
            return bIRemoteVideoCamera.getRemoteVideoOrd();
        }
        return null;
    }

    protected void mergeMetaData() {
        BFacets bFacets = this.getAlarmExt().getMetaData();
        BOrd bOrd = this.getVideoCamera();
        boolean bl = this.getStartRecording().getValue();
        boolean bl2 = this.getGotoPreset();
        boolean bl3 = this.getSendAlarmToDisplay();
        BValue bValue = this.getCameraPreset();
        if (bOrd != null && !bOrd.isNull() && bOrd.toString().trim().length() > 0) {
            BFacets bFacets2;
            BObject bObject = bOrd.get((BObject)this);
            if (bObject instanceof BComponent && (bFacets2 = this.checkForRemoteCameraOrd(bOrd, (BComponent)bObject, false)) != null) {
                bOrd = bFacets2;
            }
            bFacets2 = BVideoAlarmExtParameters.mergeCameraOrd(bFacets, bOrd);
            if (bObject instanceof BComponent) {
                BOrd bOrd2;
                BOrd bOrd3 = bObject.asComponent().getHandleOrd();
                if (Sys.atSteadyState() && (bOrd2 = this.checkForRemoteCameraOrd(bOrd, (BComponent)bObject, true)) != null) {
                    bOrd3 = bOrd2;
                }
                bFacets2 = BVideoAlarmExtParameters.mergeCameraHandleOrd(bFacets2, bOrd3);
            }
            bFacets2 = BVideoAlarmExtParameters.mergeStartRecording(bFacets2, bl);
            bFacets2 = BVideoAlarmExtParameters.mergeCameraPreset(bFacets2, bl, bValue, bl2, bOrd);
            if ((bFacets2 = BVideoAlarmExtParameters.mergeSendAlarmToDisplay(bFacets2, bl3)) != bFacets) {
                this.getAlarmExt().setMetaData(bFacets2);
            }
        }
    }

    protected static BFacets mergeCameraPreset(BFacets bFacets, boolean bl, BValue bValue, boolean bl2, BOrd bOrd) {
        BObject bObject = bFacets.get("cameraPreset");
        if (!bOrd.equals((Object)BOrd.NULL) && bl2 && bl) {
            if (bObject == null && bValue != null || bObject != null && !bObject.equals((Object)bValue.toDataValue())) {
                bFacets = BFacets.make((BFacets)bFacets, (BFacets)BFacets.make((String)"cameraPreset", (BIDataValue)bValue.toDataValue()));
            }
        } else if (bFacets.get("cameraPreset") != null) {
            bFacets = BFacets.makeRemove((BFacets)bFacets, (String)"cameraPreset");
        }
        return bFacets;
    }

    protected static BFacets mergeStartRecording(BFacets bFacets, boolean bl) {
        BObject bObject = bFacets.get("startRecording");
        if (bObject == null) {
            bFacets = BFacets.make((BFacets)bFacets, (String)"startRecording", (BIDataValue)BBoolean.make((boolean)bl));
        } else if (bObject instanceof BBoolean) {
            if (((BBoolean)bObject).getBoolean() != bl) {
                bFacets = BFacets.make((BFacets)bFacets, (String)"startRecording", (BIDataValue)BBoolean.make((boolean)bl));
            }
        } else {
            bFacets = BFacets.make((BFacets)bFacets, (String)"startRecording", (BIDataValue)BBoolean.make((boolean)bl));
        }
        return bFacets;
    }

    protected static BFacets mergeSendAlarmToDisplay(BFacets bFacets, boolean bl) {
        BObject bObject = bFacets.get("sendAlarmToDisplay");
        if (bObject == null) {
            bFacets = BFacets.make((BFacets)bFacets, (String)"sendAlarmToDisplay", (BIDataValue)BBoolean.make((boolean)bl));
        } else if (bObject instanceof BBoolean) {
            if (((BBoolean)bObject).getBoolean() != bl) {
                bFacets = BFacets.make((BFacets)bFacets, (String)"sendAlarmToDisplay", (BIDataValue)BBoolean.make((boolean)bl));
            }
        } else {
            bFacets = BFacets.make((BFacets)bFacets, (String)"sendAlarmToDisplay", (BIDataValue)BBoolean.make((boolean)bl));
        }
        return bFacets;
    }

    protected static BFacets mergeCameraHandleOrd(BFacets bFacets, BOrd bOrd) {
        String string = bFacets.gets("cameraHandleOrd", null);
        if (string == null) {
            if (bOrd.equals((Object)BOrd.NULL)) {
                return bFacets;
            }
            return BFacets.make((BFacets)bFacets, (BFacets)BFacets.make((String)"cameraHandleOrd", (String)bOrd.toString()));
        }
        if (bOrd.equals((Object)BOrd.NULL)) {
            return BFacets.makeRemove((BFacets)bFacets, (String)"cameraHandleOrd");
        }
        if (bOrd.toString().equals(string)) {
            return bFacets;
        }
        return BFacets.make((BFacets)bFacets, (BFacets)BFacets.make((String)"cameraHandleOrd", (String)bOrd.toString()));
    }

    protected static BFacets mergeCameraOrd(BFacets bFacets, BOrd bOrd) {
        String string = bFacets.gets("cameraOrd", null);
        if (string == null) {
            if (bOrd.equals((Object)BOrd.NULL)) {
                return bFacets;
            }
            return BFacets.make((BFacets)bFacets, (BFacets)BFacets.make((String)"cameraOrd", (BIDataValue)bOrd.toDataValue()));
        }
        if (bOrd.equals((Object)BOrd.NULL)) {
            return BFacets.makeRemove((BFacets)bFacets, (String)"cameraOrd");
        }
        if (bOrd.toString().equals(string)) {
            return bFacets;
        }
        return BFacets.make((BFacets)bFacets, (BFacets)BFacets.make((String)"cameraOrd", (BIDataValue)bOrd.toDataValue()));
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$videoDriver$alarm$BVideoAlarmExtParameters;
        if (clazz == null) {
            clazz = class$com$tridium$videoDriver$alarm$BVideoAlarmExtParameters = BVideoAlarmExtParameters.class("[Lcom.tridium.videoDriver.alarm.BVideoAlarmExtParameters;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://videoDriver/icons/alarmExtParmeters.png");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class AlarmExtSubscriber
    extends Subscriber {
        public void event(BComponentEvent bComponentEvent) {
            if (bComponentEvent.getId() == 0) {
                if (bComponentEvent.getSourceComponent() == BVideoAlarmExtParameters.this.getAlarmExt() && (bComponentEvent.getSlot().equals((Object)BAlarmSourceExt.metaData) || bComponentEvent.getSlot().equals((Object)BAlarmSourceExt.status))) {
                    BVideoAlarmExtParameters.this.mergeMetaData();
                }
            } else if (bComponentEvent.getId() == 2 && bComponentEvent.getValue() == BVideoAlarmExtParameters.this) {
                this.unsubscribeAll();
                BVideoAlarmExtParameters.this.cleanupMetaData();
            }
        }

        AlarmExtSubscriber() {
            this.subscribe((BComponent)BVideoAlarmExtParameters.this.getAlarmExt());
        }
    }
}

