/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.alarm;

import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.ui.Binder;
import com.tridium.ui.UiEnv;
import com.tridium.videoDriver.VideoDriverLexicon;
import com.tridium.videoDriver.alarm.AlarmConsoleExt;
import com.tridium.videoDriver.alarm.BIVideoAlarmRecorder;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.ui.camera.BVideoPtzDialogPane;
import com.tridium.videoDriver.ui.playback.BVideoPlayback;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.gx.IRectGeom;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BWindowEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAlarmConsoleVideoPlayerDialog
extends BDialog {
    public static final Type TYPE;
    protected boolean closed;
    protected Binder binder;
    protected BVideoPlayback videoPlayback2;
    protected double preferredWidth;
    protected double preferredHeight;
    static /* synthetic */ Class class$com$tridium$videoDriver$alarm$BAlarmConsoleVideoPlayerDialog;

    public Type getType() {
        return TYPE;
    }

    void loadAsync(BAlarmConsole bAlarmConsole, BAlarmRecord bAlarmRecord, BOrd bOrd, BObject bObject) {
        if (bObject instanceof BIVideoCamera && bObject instanceof BIVideoSource) {
            BAbsTime bAbsTime = (BAbsTime)bAlarmRecord.getAlarmData().get("videoEventTimestamp");
            if (bAbsTime == null) {
                bAlarmRecord = AlarmConsoleExt.refreshAlarmRecord(bAlarmConsole, bAlarmRecord);
                bAbsTime = (BAbsTime)bAlarmRecord.getAlarmData().get("videoEventTimestamp");
            }
            String string = this.toSummaryString(bAlarmRecord, bAbsTime);
            if (bAbsTime == null || bAbsTime.isNull()) {
                bAbsTime = bAlarmRecord.getTimestamp();
                string = VideoDriverLexicon.LEX.getText("AlarmRecallTimeApproximate", new Object[]{string});
            }
            boolean bl = bObject instanceof BIVideoAlarmRecorder ^ true;
            this.videoPlayback2 = new BVideoPlayback(string, bAbsTime, bl);
            this.setContent((BWidget)this.videoPlayback2);
            this.hookViewToCamera(bObject, bAlarmRecord);
        }
    }

    protected void hookViewToCamera(BObject bObject, BAlarmRecord bAlarmRecord) {
        this.binder = BAlarmConsoleVideoPlayerDialog.hookViewToCamera(bObject, bAlarmRecord, this.videoPlayback2);
    }

    public static Binder hookViewToCamera(BObject bObject, BAlarmRecord bAlarmRecord, BVideoPlayback bVideoPlayback) {
        BISession bISession;
        ((BComponent)bObject).lease();
        bVideoPlayback.fw(403);
        Context context = null;
        try {
            bISession = BOrd.toSession((BObject)bObject);
            if (bISession != null) {
                context = bISession.getSessionContext();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        bVideoPlayback.prime();
        bVideoPlayback.relayout();
        bVideoPlayback.start();
        bVideoPlayback.loadValue(bObject, context);
        if (bVideoPlayback.getLoadError() != null) {
            throw new BajaRuntimeException(bVideoPlayback.getLoadError());
        }
        bISession = (Binder)bVideoPlayback.fw(302);
        bISession.start(((BComponent)bObject).getNavOrd().resolve(), context);
        return bISession;
    }

    protected BAlarmService getAlarmService() {
        return (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
    }

    protected void layoutWindow(BAlarmConsole bAlarmConsole) {
        IRectGeom iRectGeom = UiEnv.get().getScreenBounds((BWidget)bAlarmConsole);
        this.preferredWidth = iRectGeom.width() / (double)2;
        this.preferredHeight = this.preferredWidth * 0.75;
        this.setScreenSizeToPreferredSize();
        this.setBoundsCenteredOnOwner();
    }

    protected String toSummaryString(BAlarmRecord bAlarmRecord, BAbsTime bAbsTime) {
        StringBuffer stringBuffer = new StringBuffer(bAlarmRecord.getAlarmData().gets("msgText", ""));
        if (stringBuffer.toString().trim().length() > 0) {
            stringBuffer.append(" <-> ");
        }
        if (bAbsTime == null) {
            stringBuffer.append(bAlarmRecord.getTimestamp().toString((Context)BAlarmRecord.TIMESTAMP_FACETS));
        } else {
            stringBuffer.append(bAbsTime.toString((Context)BAlarmRecord.TIMESTAMP_FACETS));
        }
        stringBuffer.append(": (").append(bAlarmRecord.getAckState()).append(':').append(bAlarmRecord.getSourceState()).append(") ");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void windowClosing(BWindowEvent bWindowEvent) {
        try {
            try {
                if (this.binder != null) {
                    this.binder.stop();
                }
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.close();
            throw throwable;
        }
        {
            Object var3_4 = null;
            this.close();
            return;
        }
    }

    public void close() {
        this.closed = true;
        super.close();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void computePreferredSize() {
        this.setPreferredSize(this.preferredWidth, this.preferredWidth * 0.75);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BAlarmConsoleVideoPlayerDialog() {
    }

    public BAlarmConsoleVideoPlayerDialog(BAlarmConsole bAlarmConsole) {
        super((BWidget)bAlarmConsole, BVideoPtzDialogPane.LEX.getText("AlarmConsole.ShowVideo.Dialog.Title"), true);
        this.layoutWindow(bAlarmConsole);
        this.videoPlayback2 = new BVideoPlayback();
        this.videoPlayback2.drawView();
        this.videoPlayback2.overrideCurrentInfoMessage(VideoDriverLexicon.LEX.getText("AlarmConsoleExt.ResolvingCamera"));
        this.setContent((BWidget)this.videoPlayback2);
    }

    static {
        Class clazz = class$com$tridium$videoDriver$alarm$BAlarmConsoleVideoPlayerDialog;
        if (clazz == null) {
            clazz = class$com$tridium$videoDriver$alarm$BAlarmConsoleVideoPlayerDialog = BAlarmConsoleVideoPlayerDialog.class("[Lcom.tridium.videoDriver.alarm.BAlarmConsoleVideoPlayerDialog;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

