function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/ndriver/rc/util/columnUtil
 */
define(['baja!', 'underscore', 'Promise', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/PropertySheet', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyPathMgrColumn', 'nmodule/ndriver/rc/column/DiscoveryPropertyMgrColumn'], function (baja, _, Promise, fe, Column, PropertySheet, PropertyPathMgrColumn, DiscoveryPropertyMgrColumn) {
  'use strict';

  var PROXY_EXT = 'driver:ProxyExt',
    KEY_MGR = 'Mgr',
    MGR_EDIT = 'ed',
    MGR_UNSEEN = 'un',
    MGR_READONLY = 'ro',
    UNSEEN = Column.flags.UNSEEN,
    EDITABLE = Column.flags.EDITABLE,
    READONLY = Column.flags.READONLY;

  // Check if specified property's default value uses a custom field editor
  // see com.tridium.ndriver.ui.NMgrColumnUtil.java#hasCustomFE for the equivalent wb implementation
  var hasCustomFE = function hasCustomFE(property) {
    return fe.getDefaultConstructor(property.getType(), {
      formFactors: ['compact', 'mini']
    }).then(function (fieldEditor) {
      if (fieldEditor && !(fieldEditor instanceof PropertySheet)) {
        return true;
      }
      return false;
    });
  };

  /**
   * returns a path in dot notation form
   * @param {String} path
   *
   * @returns {String}
   */
  var pathToDotNotation = function pathToDotNotation(path) {
    // Convert the path to dot notation format, then remove any leading 'proxyExt.'
    // (This helps for the point manager where most columns are prop paths under
    // a control point starting with the control point's proxyExt property)
    // This is equivalent to initial processing in NMgrColumnUtil#getMgrColumnName.

    return path.replace(/\//g, '.').replace(/^proxyExt\./, '');
  };

  /**
   * make an ndriver column.
   *
   * @param {boolean} isDiscovery - true if creating for a discovery table.
   * @param {Array.<String>} path - the property path array
   * @param {baja.Property} property - the property the column is for
   * @param {Object} params - the params object for the column
   *
   * @returns {Promise.<Array.<module:nmodule/webEditors/rc/wb/table/model/Column>>}
   */
  var makeColumn = function makeColumn(isDiscovery, path, property, params) {
    if (isDiscovery) {
      return new DiscoveryPropertyMgrColumn(pathToDotNotation(path), path, params);
    }
    return new PropertyPathMgrColumn(pathToDotNotation(path), path, params);
  };
  var addColumn = function addColumn(complex, columns, slotParentType, path, isDiscovery, property, mgrEdit) {
    var flags,
      params = {};
    if (mgrEdit.indexOf(MGR_EDIT) > -1) {
      flags |= EDITABLE;
    }
    if (mgrEdit.indexOf(MGR_UNSEEN) > -1) {
      flags |= UNSEEN;
    }
    if (mgrEdit.indexOf(MGR_READONLY) > -1) {
      flags |= READONLY;
    }
    if (flags) {
      params.flags = flags;
    }
    params.moduleName = complex.getType().getModuleName();

    // For a frozen property, set the Type instance in order to resolve its display name/facets
    //  ( see nmodule/webEditors/rc/wb/table/model/columns/PropertyColumn [params.type] )
    if (slotParentType && property.isFrozen()) {
      params.type = slotParentType;
    }
    if (isDiscovery) {
      params.columnIndex = columns.length;
    }
    columns.push(makeColumn(isDiscovery, path + property.getName(), property, params));
  };
  var _recurse = function recurse(complex, columnsIn, slotParentType, path, isDiscovery) {
    var properties = complex.getSlots().properties().toArray();
    if (properties.length === 0) {
      return Promise.resolve(columnsIn);
    }
    return properties.reduce(function (resolveColumns, property, index) {
      return Promise.all([property.getType().isSimple(), property.getType().isStruct(), hasCustomFE(property), property.getType().isComplex(), resolveColumns]).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 5),
          isSimple = _ref2[0],
          isStruct = _ref2[1],
          hasCustomFE = _ref2[2],
          isComplex = _ref2[3],
          columns = _ref2[4];
        var mgrEdit = property.getFacets().get(KEY_MGR);

        // not using 'if(!mgrEdit)' here because an empty string means MGR is present as a Facet
        // but not set to ReadOnly, Unseen or Editable.
        var hasMgrEditFacet = typeof mgrEdit === 'string';
        if (hasMgrEditFacet) {
          if (isSimple || isStruct && hasCustomFE) {
            addColumn(complex, columns, slotParentType, path, isDiscovery, property, mgrEdit);
          } else if (isComplex) {
            // not sure if it's possible to end up with an object that isn't a
            // complex here, so the 'else if' could potentially just be 'else'
            // but it's been left because this is what NMgrColumnUtil.java#recurse does.
            return _recurse(property.$getValue(), columns, property.$getValue().getType(), path + property.getName() + '/', isDiscovery);
          }
        }
        return columns;
      });
    }, columnsIn);
  };

  /**
   * A utility class for dealing with ndriver columns
   *
   * API Status: **Private**
   * @exports nmodule/ndriver/rc/util/columnUtil
   */
  var exports = {};

  /*
   * Get the columns for a database or discovery table.
   *
   * @param  {String} complex - the object to create columns from.
   * @param  {Array.<module:nmodule/webEditors/rc/wb/table/model/Column>} columns
   *                         - the current list of columns to append to.
   * @param  {boolean} isDiscovery - true if creating for a discovery table.
   * @returns {Promise.<Array.<module:nmodule/webEditors/rc/wb/table/model/Column>>}
   */
  exports.getColumnsFor = function (complex, columns, isDiscovery) {
    return _recurse(complex, columns, complex.getType(),
    // slot parent type
    baja.hasType(complex, PROXY_EXT) ? 'proxyExt/' : '',
    // path
    isDiscovery);
  };
  return exports;
});
