function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * Copyright 2020 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/kitPx/rc/ux/ImageButton
 */
define(['baja!', 'bajaux/icon/iconUtils', 'bajaux/spandrel', 'nmodule/bajaui/rc/ux/Button', 'nmodule/webEditors/rc/util/htmlUtils', 'baja!gx:Image', 'css!nmodule/kitPx/rc/kitPx'], function (baja, iconUtils, spandrel, Button, htmlUtils) {
  'use strict';

  var escapeHtml = htmlUtils.escapeHtml;
  var NULL_IMAGE = baja.$("gx:Image");
  var HIDE_LABEL_CLASS = "-t-ImageButton-no-label";
  var HIDE_LABEL_ICON_CLASS = "-t-ImageButton-no-label-icon";
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-Button ux-ImageButton',
        textOverride: baja.Format.DEFAULT,
        disabled: NULL_IMAGE,
        normal: NULL_IMAGE,
        mouseOver: NULL_IMAGE,
        pressed: NULL_IMAGE
      }
    };
  };
  var isNullImage = function isNullImage(image) {
    return image.toString() === NULL_IMAGE.toString();
  };
  var getImageStyleString = function getImageStyleString(image) {
    if (isNullImage(image)) {
      return "";
    }
    var imageOrd = baja.Ord.make(image.valueOf());
    var url = escapeHtml(iconUtils.toUris(imageOrd)[0]);
    return "url(\"".concat(url, "\")");
  };

  /**
   * @class
   * @alias module:nmodule/kitPx/rc/ux/ImageButton
   * @extends module:nmodule/bajaui/rc/ux/Button
   */
  return /*#__PURE__*/function (_spandrel) {
    function ImageButton(params) {
      _classCallCheck(this, ImageButton);
      return _callSuper(this, ImageButton, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }
    _inherits(ImageButton, _spandrel);
    return _createClass(ImageButton, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        this.$registerEventHandlers(dom);
        return Button.prototype.doInitialize.apply(this, arguments);
      }
    }, {
      key: "render",
      value: function render() {
        //TODO: NCCB-45981 (possibly remove after)
        return Button.prototype.render.apply(this, arguments);
      }
    }, {
      key: "$setImage",
      value: function $setImage(image) {
        this.jq().find("button > .-t-ImageButton-backgroundImage").css("background-image", getImageStyleString(image));
      }

      /**
       * @private
       * @returns {boolean}
       */
    }, {
      key: "$canHover",
      value: function $canHover() {
        return window.matchMedia('(hover: hover)').matches;
      }
    }, {
      key: "$registerEventHandlers",
      value: function $registerEventHandlers(dom) {
        var _this = this;
        var isPressed = false,
          isMouseOver = false;
        var updateDisplay = function updateDisplay() {
          if (!_this.isEnabled()) {
            return;
          }
          var normalImage = _this.properties().getValue("normal"),
            mouseOverImage = _this.properties().getValue("mouseOver"),
            pressedImage = _this.properties().getValue("pressed"),
            button = _this.jq().find("button");
          button.toggleClass(HIDE_LABEL_CLASS, true);
          if (isPressed && !isNullImage(pressedImage)) {
            _this.$setImage(pressedImage);
          } else if (isMouseOver && !isNullImage(mouseOverImage)) {
            _this.$setImage(mouseOverImage);
          } else if (!isNullImage(normalImage)) {
            _this.$setImage(normalImage);
          } else {
            _this.$setImage(NULL_IMAGE);
            button.toggleClass(HIDE_LABEL_CLASS, false);
          }
        };
        dom.on('touchstart mousedown', function () {
          isPressed = true;
          updateDisplay();
        });
        dom.on('touchend mouseup', function () {
          isPressed = false;
          updateDisplay();
        });
        if (this.$canHover()) {
          dom.hover(function () {
            isMouseOver = true;
            updateDisplay();
          }, function () {
            isMouseOver = false;
            isPressed = false;
            updateDisplay();
          });
        }
      }
    }]);
  }(spandrel(function (value, _ref) {
    var properties = _ref.properties,
      renderSuper = _ref.renderSuper;
    return renderSuper().then(function (result) {
      var enabled = properties.enabled,
        disabled = properties.disabled,
        normal = properties.normal,
        pressed = properties.pressed,
        mouseOver = properties.mouseOver;
      var buttonClassList = result[0].kids[0].dom.classList;
      var backgroundImageDOM = document.createElement('div');
      backgroundImageDOM.classList.add("-t-ImageButton-backgroundImage");
      if (!enabled && !isNullImage(disabled)) {
        backgroundImageDOM.style.backgroundImage = getImageStyleString(disabled);
      } else if (!enabled && !isNullImage(normal)) {
        backgroundImageDOM.style.backgroundImage = getImageStyleString(normal);
      } else if (enabled && !isNullImage(normal)) {
        backgroundImageDOM.style.backgroundImage = getImageStyleString(normal);
        buttonClassList.add(HIDE_LABEL_CLASS);
      }
      result[0].kids[0].kids = {
        background: {
          dom: backgroundImageDOM
        },
        label: result[0].kids[0].kids.label
      };
      var isLabelIconVisible = isNullImage(normal) && isNullImage(mouseOver) && isNullImage(pressed);
      if (!isLabelIconVisible) {
        buttonClassList.add(HIDE_LABEL_ICON_CLASS);
      }
      return result;
    });
  }, {
    "extends": Button
  }));
});
