function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/kitPx/rc/ux/AnalogMeter
 */
define(['baja!', 'baja!gx:Brush,gx:Font,gx:Pen', 'lex!kitPx', 'bajaux/spandrel', 'underscore'], function (baja, types, lexs, spandrel, _) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    kitPxLex = _lexs[0];
  var range = _.range;
  var PI = Math.PI;
  var TWO_PI = PI * 2;
  var SLICES = ['e', 'ne', 'n', 'nw', 'w', 'sw', 's', 'se'];
  var defaultScaleFont = baja.$('gx:Font', kitPxLex.get('analogMeter.scale.font'));
  var defaultValueFont = baja.$('gx:Font', kitPxLex.get('analogMeter.value.font'));
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-AnalogMeter',
        arcAngle: baja.Integer.make(300),
        background: baja.$('gx:Brush', '#ccc'),
        fillCircle: true,
        foreground: baja.$('gx:Brush', '#000'),
        max: 100,
        min: 0,
        needleBrush: baja.$('gx:Brush', 'red'),
        needlePen: baja.$('gx:Pen'),
        numDivisions: baja.Integer.make(10),
        numSubDivisions: baja.Integer.make(5),
        scaleFont: baja.$('gx:Font'),
        scaleVisible: true,
        showSubDivisions: true,
        startAngle: baja.Integer.make(240),
        text: '',
        value: 0,
        valueFont: baja.$('gx:Font'),
        valueVisible: true
      }
    };
  };

  /**
   * @class
   * @alias module:nmodule/kitPx/rc/ux/AnalogMeter
   * @extends module:bajaux/Widget
   */
  return /*#__PURE__*/function (_spandrel) {
    function AnalogMeter(params) {
      _classCallCheck(this, AnalogMeter);
      return _callSuper(this, AnalogMeter, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }
    _inherits(AnalogMeter, _spandrel);
    return _createClass(AnalogMeter, [{
      key: "doLayout",
      value: function doLayout() {
        var _this$state = this.state(),
          _this$state$propertie = _this$state.properties,
          background = _this$state$propertie.background,
          foreground = _this$state$propertie.foreground,
          needleBrush = _this$state$propertie.needleBrush;
        var svg = this.$getSvgElement()[0];
        var face = this.$getFaceElement();
        var labels = this.$getLabelElements();
        var ticks = this.$getTickElements();
        var needle = this.$getNeedleElement();
        needleBrush.applyStrokeToSvgElement(needle[0], svg);
        if (face.length) {
          background.applyFillToSvgElement(face[0], svg);
        }
        [].concat(_toConsumableArray(face), _toConsumableArray(ticks)).forEach(function (el) {
          return foreground.applyStrokeToSvgElement(el, svg);
        });
        _toConsumableArray(labels).forEach(function (el) {
          return foreground.applyFillToSvgElement(el, svg);
        });
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getSvgElement",
      value: function $getSvgElement() {
        return this.jq().children('svg');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getFaceElement",
      value: function $getFaceElement() {
        return this.$getSvgElement().children('.-t-AnalogMeter-face');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getTickElements",
      value: function $getTickElements() {
        return this.$getSvgElement().children('.-t-AnalogMeter-ticks').children();
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getLabelElements",
      value: function $getLabelElements() {
        return this.$getSvgElement().find('text');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getNeedleElement",
      value: function $getNeedleElement() {
        return this.$getSvgElement().children('.-t-AnalogMeter-needle');
      }
    }]);
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties,
      rootElement = _ref.rootElement;
    var arcAngle = properties.arcAngle,
      background = properties.background,
      fillCircle = properties.fillCircle,
      foreground = properties.foreground,
      max = properties.max,
      min = properties.min,
      needleBrush = properties.needleBrush,
      needlePen = properties.needlePen,
      numDivisions = properties.numDivisions,
      startAngle = properties.startAngle,
      text = properties.text,
      value = properties.value,
      valueVisible = properties.valueVisible;
    var scaleVisible = properties.scaleVisible,
      numSubDivisions = properties.numSubDivisions,
      showSubDivisions = properties.showSubDivisions;
    var outerWidth = rootElement.clientWidth || 100;
    var outerHeight = rootElement.clientHeight || 100;
    var _calculateLayout = calculateLayout(properties, outerWidth, outerHeight),
      radius = _calculateLayout.radius,
      scaleFont = _calculateLayout.scaleFont,
      valueFont = _calculateLayout.valueFont,
      viewBox = _calculateLayout.viewBox;
    var totalTicks = numDivisions * numSubDivisions + 1;
    if (numDivisions <= 0) {
      totalTicks = 0;
      scaleVisible = false;
    } else if (numSubDivisions <= 0) {
      totalTicks = numDivisions + 1;
      showSubDivisions = false;
    }
    var valueRatio = clamp((value - min) / (max - min), 0, 1);
    var startRadians = toRadians(startAngle);
    var smallTickArc = toRadians(arcAngle / (totalTicks - 1));
    var bigTickArc = toRadians(arcAngle / numDivisions);
    var needleAngleDegrees = startAngle - valueRatio * arcAngle;
    return spandrel.jsx("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: viewBox
    }, fillCircle && spandrel.jsx("circle", {
      className: "-t-AnalogMeter-face",
      cx: "0",
      cy: "0",
      r: radius - 0.5,
      $init: function $init(el) {
        background.applyFillToSvgElement(el);
        foreground.applyStrokeToSvgElement(el);
      }
    }), spandrel.jsx("line", {
      className: "-t-AnalogMeter-needle",
      $init: function $init(el) {
        needleBrush.applyStrokeToSvgElement(el);
        needlePen.applyToSvgElement(el);
      },
      x1: 0,
      y1: 0,
      x2: radius,
      y2: 0.001 // a perfectly horizontal line will not paint with a gradient
      ,
      style: {
        transform: "rotate(".concat(-needleAngleDegrees, "deg)")
      }
    }), spandrel.jsx("g", {
      className: "-t-AnalogMeter-ticks"
    }, range(0, totalTicks).map(function (i) {
      var isBigTick = !(i % numSubDivisions);
      if (!isBigTick && !showSubDivisions) {
        return;
      }
      var tickAngle = startRadians - i * smallTickArc;
      var endX = Math.cos(tickAngle) * radius;
      var endY = -Math.sin(tickAngle) * radius;
      var blankRatio = isBigTick ? 0.92 : 0.96;
      var endRatio = (radius - 0.5) / radius;
      return spandrel.jsx("line", {
        className: "-t-AnalogMeter-tick -t-AnalogMeter-".concat(isBigTick ? 'major' : 'minor', "-tick"),
        $init: function $init(el) {
          return foreground.applyStrokeToSvgElement(el);
        },
        x1: endX * blankRatio,
        y1: endY * blankRatio,
        x2: endX * endRatio,
        y2: endY * endRatio
      });
    })), scaleVisible && spandrel.jsx("g", {
      className: "-t-AnalogMeter-labels"
    }, range(0, numDivisions + 1).map(function (i) {
      var text = String(Math.floor(min + i * (max - min) / numDivisions));
      var labelAngle = startRadians - i * bigTickArc;
      var _getLabelAlign = getLabelAlign(labelAngle),
        textAnchor = _getLabelAlign.textAnchor,
        dominantBaseline = _getLabelAlign.dominantBaseline;
      return spandrel.jsx("text", {
        className: "-t-AnalogMeter-scale-label",
        x: Math.cos(labelAngle) * radius * 0.9,
        y: -Math.sin(labelAngle) * radius * 0.9,
        $init: function $init(el) {
          scaleFont.applyToElement(el);
          foreground.applyFillToSvgElement(el);
        },
        style: {
          textAnchor: textAnchor,
          dominantBaseline: dominantBaseline
        }
      }, text);
    })), valueVisible && spandrel.jsx("text", {
      className: "-t-AnalogMeter-text",
      x: 0,
      y: 0,
      $init: function $init(el) {
        return valueFont.applyToElement(el);
      }
    }, text));
  }));
  function calculateLayout(properties, elementWidth, elementHeight) {
    var scaleFont = properties.scaleFont,
      scaleVisible = properties.scaleVisible,
      valueFont = properties.valueFont,
      valueVisible = properties.valueVisible;
    if (scaleFont.isNull()) {
      scaleFont = defaultScaleFont;
    }
    if (valueFont.isNull()) {
      valueFont = defaultValueFont;
    }
    var radius, viewBox;
    if (isSemiCircularMode(properties)) {
      var maxDiameter = Math.min(elementWidth, elementHeight * 2);
      var heightReservedForText = valueVisible ? valueFont.getSize() : scaleVisible ? scaleFont.getSize() / 2 : 0;
      var verticalSpaceAvailableForRadius = elementHeight - heightReservedForText;
      radius = Math.min(maxDiameter / 2, verticalSpaceAvailableForRadius);
      viewBox = "".concat(Math.min(-radius, -elementWidth / 2), " ").concat(-verticalSpaceAvailableForRadius, " ").concat(elementWidth, " ").concat(elementHeight);
    } else {
      var diameter = Math.min(elementWidth, elementHeight);
      radius = diameter / 2;
      viewBox = "".concat(-elementWidth / 2, " ").concat(-elementHeight / 2, " ").concat(elementWidth, " ").concat(elementHeight);
    }
    return {
      radius: radius,
      scaleFont: scaleFont,
      valueFont: valueFont,
      viewBox: viewBox
    };
  }

  /**
   * When fillCircle is false and arc and start angles are both <= 180, this kicks an AnalogMeter
   * into a semicircular, "speedometer-like" mode.
   * @param {object} properties
   * @returns {boolean}
   */
  function isSemiCircularMode(properties) {
    var arcAngle = properties.arcAngle,
      fillCircle = properties.fillCircle,
      startAngle = properties.startAngle;
    return arcAngle <= 180 && startAngle <= 180 && !fillCircle;
  }
  function getLabelAlign(angle) {
    // divide the circle into eight slices with the eastern slice going from -pi/16 to pi/16.
    angle = (angle + PI / 16) % TWO_PI;
    if (angle < 0) {
      angle = TWO_PI + angle;
    }
    var sliceIndex = Math.floor(angle / TWO_PI * 8);
    var slice = SLICES[sliceIndex];
    return {
      textAnchor: getTextAnchor(slice),
      dominantBaseline: getDominantBaseline(slice)
    };
  }
  function getTextAnchor(slice) {
    switch (slice) {
      case 'n':
      case 's':
        return 'middle';
      case 'ne':
      case 'e':
      case 'se':
        return 'end';
      case 'nw':
      case 'w':
      case 'sw':
        return 'start';
      default:
        throw new Error('unknown slice' + slice);
    }
  }
  function getDominantBaseline(slice) {
    switch (slice) {
      case 'e':
      case 'w':
        return 'middle';
      case 'nw':
      case 'n':
      case 'ne':
        return 'hanging';
      case 'sw':
      case 's':
      case 'se':
        return 'auto';
    }
  }
  function toRadians(degrees) {
    return degrees * PI / 180;
  }
  function clamp(num, min, max) {
    return Math.min(Math.max(num, min), max);
  }
});
