function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/**
 * API Status: **Private**
 * @module nmodule/kitPx/rc/binding/ActionBinding
 */
define(['baja!', 'Promise', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/bajaui/rc/baja/binding/Binding', 'nmodule/webEditors/rc/fe/feDialogs', 'log!uxMedia', 'css!nmodule/kitPx/rc/kitPx'], function (baja, Promise, switchboard, Binding, feDialogs, log) {
  'use strict';

  var logSevere = log.severe.bind(log);

  /**
   * Resolve the action argument.
   * If actionArg is the value is '', then resolve to undefined.
   * If actionArg is already a non-string Value, then resolve to it.
   * If actionArg is a string and getActionParameterDefault resolves to a Simple, decode it.
   *
   * @param {baja.Component} component
   * @param {baja.Slot}slot
   * @param {baja.Value|String} actionArg
   * @return {Promise}
   */
  function resolveActionArgument(component, slot, actionArg) {
    var paramType;
    if (actionArg === '') {
      return Promise.resolve();
    }
    if (!actionArg.getType().is("baja:String")) {
      return Promise.resolve(actionArg);
    }
    return component.getActionParameterDefault(slot).then(function (value) {
      paramType = value.getType();
      if (paramType.isSimple()) {
        return value.decodeAsync(actionArg);
      } else {
        logSevere("ActionBinding arg type mismatch " + actionArg.getType() + " != " + paramType);
      }
    })["catch"](function () {
      logSevere("ActionBinding parsing arg \"" + actionArg + "\" as \"" + paramType + "\"");
    });
  }

  /**
   * BajaScript implementation of a `kitPx:ActionBinding`.
   * @class
   * @alias module:nmodule/kitPx/rc/binding/ActionBinding
   * @extends module:nmodule/bajaui/rc/baja/binding/Binding
   */
  return /*#__PURE__*/function (_Binding) {
    function ActionBinding() {
      var _this;
      _classCallCheck(this, ActionBinding);
      _this = _callSuper(this, ActionBinding, arguments);
      switchboard(_this, {
        invokeActionOnTarget: {
          allow: 'oneAtATime',
          onRepeat: 'returnLast'
        }
      });
      return _this;
    }

    /**
     * Determines whether or not this binding is degraded
     * @returns {boolean} true if degraded, false if not.
     */
    _inherits(ActionBinding, _Binding);
    return _createClass(ActionBinding, [{
      key: "isDegraded",
      value: function isDegraded() {
        var target = this.getOrdTarget();
        return !this.isBound() || !target.canInvoke();
      }

      /**
       * Add event listeners for the widget:
       *
       * - on mousedown when not a right click, fire action when widgetEvent is `actionPerformed` or `mouseEvent`
       * - on mouseenter, fire action when widgetEvent is `mouseEvent`
       * - on focus, fire action when widgetEvent is `focusEvent`
       * - on initialized, fire action when widgetEvent is `started`
       *
       * @param {module:bajaux/Widget} widget
       */
    }, {
      key: "addListeners",
      value: function addListeners(widget) {
        var _this2 = this;
        this.addWidgetEvents(widget, {
          mouseenter: function mouseenter() {
            var widgetEvent = _this2.get('widgetEvent');
            if (widgetEvent === "mouseEvent") {
              return _this2.invokeActionOnTarget();
            }
          },
          mousedown: function mousedown(event) {
            if (event && event.button === 2) {
              return;
            }
            var widgetEvent = _this2.get('widgetEvent');
            if (widgetEvent === "actionPerformed" || widgetEvent === "mouseEvent") {
              return _this2.invokeActionOnTarget();
            }
          },
          initialized: function initialized() {
            var widgetEvent = _this2.get('widgetEvent');
            if (widgetEvent === "focusEvent") {
              var jq = widget.jq();
              if (jq.length > 0) {
                var dom = jq[0];

                //focus events do not bubble so a native event listener is used
                var focusHandler = function focusHandler() {
                  _this2.invokeActionOnTarget()["catch"](logSevere);
                };
                _this2.$focusHandler = focusHandler;
                dom.addEventListener('focus', focusHandler, true);
              }
            }
            if (widgetEvent === "started") {
              return _this2.invokeActionOnTarget();
            }
          },
          destroyed: function destroyed() {
            var jq = widget.jq();
            if (jq.length > 0) {
              jq[0].removeEventListener('focus', _this2.$focusHandler, true);
            }
            delete _this2.$focusHandler;
          }
        });
      }

      /**
       * Invoke the action on the Target
       * @return {Promise}
       */
    }, {
      key: "invokeActionOnTarget",
      value: function invokeActionOnTarget() {
        var ord = this.get('ord');
        if (ord.isNull()) {
          return Promise.resolve();
        }
        if (!this.isBound()) {
          logSevere("ActionBinding not bound to component " + ord);
          return Promise.resolve();
        }
        var actionArg = this.get('actionArg');
        var component = this.getOrdTarget().getComponent();
        var slot = this.getOrdTarget().getSlotInComponent();
        if (slot && slot.isAction()) {
          return resolveActionArgument(component, slot, actionArg).then(function (actionArgument) {
            return feDialogs.action({
              component: component,
              slot: slot,
              actionArgument: actionArgument
            });
          });
        } else {
          logSevere("ActionBinding not bound to action " + ord);
        }
        return Promise.resolve();
      }
    }]);
  }(Binding);
});
