/**************************************************************************
Copyright 2015 Honeywell International Sàrl
**************************************************************************/

/*var _typeof =
  typeof Symbol === "function" && typeof Symbol.iterator === "symbol"
    ? function(obj) {
        return typeof obj;
      }
    : function(obj) {
        return obj &&
          typeof Symbol === "function" &&
          obj.constructor === Symbol &&
          obj !== Symbol.prototype
          ? "symbol"
          : typeof obj;
      };*/

(function(global, factory) {
  if (typeof exports === "object" && typeof module !== undefined) {
    //check if is CommonJS
    module.exports = factory(
      require("./video-js"),
      require("./protocolFormater")
    );
  } else if (typeof define === "function" && define.amd) {
    //check if is AMD
    define(["./video-js", "./protocolFormater"], factory);
  } else {
    factory(global, factory);
  }
})(this, function(videojsJ) {
  if (typeof define === "function" && define.amd) videojs = videojsJ;

  var _createClass = (function() {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor) descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }
    return function(Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);
      if (staticProps) defineProperties(Constructor, staticProps);
      return Constructor;
    };
  })();

  var _get = function get(object, property, receiver) {
    if (object === null) object = Function.prototype;
    var desc = Object.getOwnPropertyDescriptor(object, property);
    if (desc === undefined) {
      var parent = Object.getPrototypeOf(object);
      if (parent === null) {
        return undefined;
      } else {
        return get(parent, property, receiver);
      }
    } else if ("value" in desc) {
      return desc.value;
    } else {
      var getter = desc.get;
      if (getter === undefined) {
        return undefined;
      }
      return getter.call(receiver);
    }
  };

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError(
        "this hasn't been initialised - super() hasn't been called"
      );
    }
    return call && (typeof call === "object" || typeof call === "function")
      ? call
      : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError(
        "Super expression must either be null or a function, not " +
          typeof superClass
      );
    }
    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
    if (superClass)
      Object.setPrototypeOf
        ? Object.setPrototypeOf(subClass, superClass)
        : (subClass.__proto__ = superClass);
  }

  //import videojs from 'video.js';
  //import {version as VERSION} from '../package.json';

  function getHiddenProp() {
    var prefixes = ["webkit", "moz", "ms", "o"];

    for (var i = 0; i < prefixes.length; i++) {
      if (prefixes[i] + "Hidden" in document) return prefixes[i] + "Hidden";
    }

    // otherwise it's not supported
    return null;
  }

  function getVisibilityState() {
    var prefixes = ["webkit", "moz", "ms", "o"];

    for (var i = 0; i < prefixes.length; i++) {
      if (prefixes[i] + "VisibilityState" in document)
        return prefixes[i] + "VisibilityState";
    }
    // otherwise it's not supported
    return null;
  }

  var registerPlugin = videojs.registerPlugin || videojs.plugin;

  var Tech = videojs.getComponent("Tech");
  var Html5 = videojs.getTech("Html5");

  var Fmp4 = (function(_Html) {
    _inherits(Fmp4, _Html);

    /**
     * Create an instance of this Tech.
     *
     * @param {Object} [options]
     *        The key/value store of player options.
     *
     * @param {Component~ReadyCallback} ready
     *        Callback function to call when the `Flash` Tech is ready.
     */
    function Fmp4(options, ready) {
      _classCallCheck(this, Fmp4);

      var _this = _possibleConstructorReturn(
        this,
        (Fmp4.__proto__ || Object.getPrototypeOf(Fmp4)).call(
          this,
          options,
          ready
        )
      );
      _this.queue_ = [];
      _this.web_socket_url_ = "";
      _this.web_socket_;
      _this.playing_ = false;
      _this.hiddentag = getHiddenProp();
      _this.hiddenstate = false;
      _this.visibleStatetag = getVisibilityState();
      _this.hiddenWebsocketonclose = false;
      _this.protocolHelper = null;
      _this.onNotification = null;
      _this.onTimePosition = null;
	  _this.playbackSpeed = null;
      _this.onSpeedChange = null;
      _this.supportedSpeeds = [
        "-16",
        "-8",
        "-4",
        "-2",
        "-1",
        "-1/2",
        "-1/5",
        "-1/10",
        "1/10",
        "1/5",
        "1/2",
        "1",
        "2",
        "4",
        "8",
        "16"
      ];
      _this.speedResetIndex = 14;
      _this.speedIndex = _this.speedResetIndex;
      _this.startTimePosition = null;
      _this.currentTimePosition = new Date().getTime();
      _this.waitSyncTimePosition = false;
      return _this;
    }

    _createClass(Fmp4, [
      {
        key: "dispose",
        value: function dispose() {
          this.close();
          _get(
            Fmp4.prototype.__proto__ || Object.getPrototypeOf(Fmp4.prototype),
            "dispose",
            this
          ).call(this);
        }
      },
      {
        key: "play",
        value: function play() {
          //Start the streaming`
          this.mediaSource_ = new MediaSource();
          this.el_.src = URL.createObjectURL(this.mediaSource_);
		  /*var o = document.getElementById("overlay");
		  
		  setInterval(()=>{
			  o.style.top = Math.random()*500 + 'px';
			  o.style.left = Math.random()*500 + 'px'; 
		  },4000)*/
          this.videoSourceBuffer_ = this.mediaSource_.addEventListener(
            "sourceopen",
            this.mediaSourceOpen.bind(this)
          );
          this.playing_ = true;
        }
      },
      {
        key: "pause",
        value: function pause() {
          if (this.web_socket_ !== undefined) {
            const pauseCommand = this.protocolHelper.getPauseControlCommand(
              true
            );
            this.web_socket_.send(pauseCommand);
            this.playing_ = false;
          }
        }
      },
      {
        key: "close",
        value: function close() {
          this.playing_ = false;
		  var elem = document.getElementById("changeText");
		  elem.innerHTML = "";;
          if (this.web_socket_ !== undefined) this.web_socket_.close();
          if (this.mediaSource_ !== null && this.mediaSource_ !== undefined)
            this.mediaSource_.removeEventListener(
              "sourceopen",
              this.mediaSourceOpen,
              false
            );
          if (
            this.videoSourceBuffer_ !== null &&
            this.videoSourceBuffer_ !== undefined
          ) {
            this.videoSourceBuffer_.removeEventListener(
              "update",
              this.sourceBufferupdate,
              false
            );
            this.videoSourceBuffer_.removeEventListener(
              "updateend",
              this.sourceBufferupdateend,
              false
            );
            this.videoSourceBuffer_.abort();
            this.videoSourceBuffer_ = null;
          }
          this.mediaSource_ = null;
          this.queue = [];
        }
      },
      {
        key: "src",
        value: function src(_src) {
          if (_src === undefined) {
            return this.currentSrc();
          }

          // Setting src through `src` not `setSrc` will be deprecated
          return this.setSrc(_src);
        }
      },
      {
        key: "setSrc",
        value: function setSrc(src) {
          var _this2 = this;
          this.web_socket_url = src;
          if (this.autoplay()) {
            this.setTimeout(function() {
              return _this2.play();
            }, 0);
          }
        }
      },
      {
        key: "mediaSourceOpen",
        value: function mediaSourceOpen() {
          if (this.mediaSource_ === null) return;
          this.videoSourceBuffer_ = this.mediaSource_.addSourceBuffer(
            'video/mp4; codecs="avc1.640029"'
          );
          this.mediaSource_.duration = Infinity;
          this.mediaSource_.removeEventListener(
            "sourceopen",
            this.mediaSourceOpen,
            false
          );
          this.videoSourceBuffer_.addEventListener(
            "update",
            this.sourceBufferupdate.bind(this)
          );
          this.videoSourceBuffer_.addEventListener(
            "updateend",
            this.sourceBufferupdateend.bind(this)
          );

          this.videoSourceBuffer_.addEventListener("abort", function() {});

          this.videoSourceBuffer_.addEventListener("error", console.error);
          this.videoSourceBuffer_.mode = "sequence";

          this.setupwebsocket();
          this.hiddenflag = getHiddenProp();
          this.visibleState = getVisibilityState();

          var visibilityChange;
          if (typeof document.hidden !== "undefined") {
            this.hiddentag = "hidden";
            visibilityChange = "visibilitychange";
            this.visibleStatetag = "visibilityState";
          } else if (typeof document.mozHidden !== "undefined") {
            this.hiddentag = "mozHidden";
            visibilityChange = "mozvisibilitychange";
            this.visibleStatetag = "mozVisibilityState";
          } else if (typeof document.msHidden !== "undefined") {
            this.hiddentag = "msHidden";
            visibilityChange = "msvisibilitychange";
            this.visibleStatetag = "msVisibilityState";
          } else if (typeof document.webkitHidden !== "undefined") {
            this.hiddentag = "webkitHidden";
            visibilityChange = "webkitvisibilitychange";
            this.visibleStatetag = "webkitVisibilityState";
          }

          var _this3 = this;
          document.addEventListener(
            visibilityChange,
            this.onvisibilityChange.bind(this)
          );
        }
      },
      {
        key: "processMP4Box",
        value: function processMP4Box(mp4_box) {
          this.hiddenflag = getHiddenProp();
          this.visibleState = getVisibilityState();
          if (
            document[this.hiddentag] === false &&
            document[this.visibleStatetag] !== "hidden"
          ) {
            this.queue_.push(mp4_box);
            if (this.playing_) {
              this.sourceBufferupdate();
              if (this.el_.paused) {
                this.el_.play();
                this.el_.currentTime = 0;
              }
            }
          }
        }
      },
      {
        key: "onvisibilityChange",
        value: function onvisibilityChange() {
          if (
            document[this.hiddentag] === true ||
            document[this.visibleStatetag] === "hidden"
          ) {
            this.hiddenstate = true;
            this.hiddenWebsocketonclose = true;
          } else {
            if (
              this.hiddenstate === true &&
              this.hiddenWebsocketonclose === true
            ) {
              if (this.web_socket_ !== undefined) {
                console.log("web_socket_.close");
                this.web_socket_.close();
              }

              this.hiddenstate = false;
              this.hiddenWebsocketonclose = false;
            }
          }
        }
      },
      {
        key: "sourceBufferupdate",
        value: function sourceBufferupdate() {
          if (
            this.videoSourceBuffer_ !== null &&
            this.queue_.length > 0 &&
            !this.videoSourceBuffer_.updating
          ) {
            this.videoSourceBuffer_.appendBuffer(this.queue_.shift());
          }
        }
      },
      {
        key: "sourceBufferupdateend",
        value: function sourceBufferupdateend() {
          if (this.el_ === null) {
            return;
          }

          if (this.el_.currentTime === 0 && this.el_.seekable.length > 0) {
            this.el_.currentTime = this.el_.seekable.end(0) - 0.1;
          }

          this.clearvideocache();

          if (this.el_.paused) {
            this.el_.play();
            this.el_.currentTime = 0;
          }
        }
      },
      {
        key: "clearvideocache",
        value: function clearvideocache() {
          if (this.videoSourceBuffer_.buffered.length <= 0) return;
          var start_time = this.videoSourceBuffer_.buffered.start(0);

          if (this.el_.currentTime - start_time > 10) {
            if (!this.videoSourceBuffer_.updating) {
              this.videoSourceBuffer_.remove(start_time, start_time + 5);
            }
          }

          if (this.el_.buffered.end(0) - this.el_.currentTime > 4) {
            this.setCurrentTime(this.el_.currentTime + 2);
          }
        }
      },
      {
        key: "setupwebsocket",
        value: function setupwebsocket() {
          var sub_protocol = "lws-video";
          this.web_socket_ = new WebSocket(this.web_socket_url, sub_protocol);
		  console.log(this.web_socket_url);
          this.web_socket_.binaryType = "arraybuffer";

          var self = this;
		
          this.web_socket_.onopen = function(evt) {
            console.log("web_socket_.onopen");
            self.adjustSpeed(self.playbackSpeed);
          };

          this.web_socket_.onmessage = function(message) {
            if (typeof message.data === "string") {
              self.processStringMessage(message.data);
            } else if (message.data instanceof ArrayBuffer) {
              self.processMP4Box(message.data);
            }
          };

          this.web_socket_.onerror = function(evt) {
            console.log("web_socket_.onerror");
            if (self.stateCallback !== undefined) {
              self.stateCallback("web_socket_.onerror");
            }
          };

          this.web_socket_.onclose = function(evt) {
            console.log("web_socket_.onclose");
            self.startTimePosition = null;
            if (self.playing_) {
              self.setupwebsocket();
            }
          };
        }

        /**
         * Indicates whether the media is currently seeking to a new position or not.
         *
         * @return {boolean}
         *         - True if seeking to a new position
         *         - False otherwise
         */
      },
      {
        key: "seeking",
        value: function seeking() {
          return this.lastSeekTarget_ !== undefined;
        }

        /**
         * Returns the current time in seconds that the media is at in playback.
         *
         * @param {number} time
         *        Current playtime of the media in seconds.
         */
      },
      {
        key: "setCurrentTime",
        value: function setCurrentTime(time) {
          try {
            this.el_.currentTime = time;
          } catch (e) {
            log(e, "Video is not ready. (Video.js)");
            // this.warning(VideoJS.warnings.videoNotReady);
          }
        }

        /**
         * Get the current source
         *
         * @method currentSrc
         * @return {Tech~SourceObject}
         *         The current source
         */
      },
      {
        key: "currentSrc",
        value: function currentSrc() {
          if (this.currentSource_) {
            return this.currentSource_.src;
          }
          return this.el_.currentSrc;
        }

        /**
    * Get the total duration of the current media.
    *
    * @return {number}
    8          The total duration of the current media.
    */
      },
      {
        key: "duration",
        value: function duration() {
          //TODO
          return Infinity;
        }

        /**
         * Determine the time ranges that can be seeked to in the media.
         *
         * @return {TimeRange}
         *         Returns the time ranges that can be seeked to.
         */
      },
      {
        key: "seekable",
        value: function seekable() {
          return this.el_.seekable;
        }

        /**
         * Get and create a `TimeRange` object for buffering.
         *
         * @return {TimeRange}
         *         The time range object that was created.
         */
      },
      {
        key: "buffered",
        value: function buffered() {
          return this.el_.buffered;
        }
      },
      {
        key: "clearAllVideoCache",
        value: function clearAllVideoCache() {
          if (this.videoSourceBuffer_.buffered.length <= 0) return;
          var startTime = this.videoSourceBuffer_.buffered.start(0);
          var endTime = this.videoSourceBuffer_.buffered.end(0);
          if (!this.videoSourceBuffer_.updating) {
            this.videoSourceBuffer_.remove(startTime, endTime);
          }
        }
      },
      {
        key: "seekTo",
        value: function seekTo(secondsOffset) {
          if (this.web_socket_ !== undefined) {
            const seekCommand = this.protocolHelper.getSeekCommand(
              secondsOffset,
              this.currentTimePosition
            );
            this.web_socket_.send(seekCommand);

            this.clearAllVideoCache();
            this.waitSyncTimePosition = true;
          }
        }
      },
      {
        key: "rewind",
        value: function rewind() {
          if (this.web_socket_ !== undefined) {
            const rewindCommand = this.protocolHelper.getDirectionChangingCommand(
              true
            );
            this.web_socket_.send(rewindCommand);

            this.clearAllVideoCache();
            this.waitSyncTimePosition = true;
          }
        }
      },
      {
        key: "adjustSpeed",
        value: function adjustSpeed(newSpeedIndex) {
          const speedCommand = this.protocolHelper.getSpeedCommand(
            this.supportedSpeeds[newSpeedIndex]
          );
          this.web_socket_.send(speedCommand);
          this.speedIndex = newSpeedIndex;
          this.clearAllVideoCache();
          if (this.onSpeedChange) {
            this.onSpeedChange(this.supportedSpeeds[newSpeedIndex]);
          }
        }
      },
      {
        key: "fasterSpeed",
        value: function fasterSpeed() {
          if (
            this.web_socket_ !== undefined &&
            this.speedIndex < this.supportedSpeeds.length - 1
          ) {
            this.adjustSpeed(this.speedIndex + 1);
          }
        }
      },
      {
        key: "slowerSpeed",
        value: function slowerSpeed() {
          if (this.web_socket_ !== undefined && this.speedIndex > 0) {
            this.adjustSpeed(this.speedIndex - 1);
          }
        }
      },
      {
        key: "resetSpeed",
        value: function resetSpeed() {
          if (
            this.web_socket_ !== undefined &&
            this.speedIndex !== this.speedResetIndex
          ) {
            this.adjustSpeed(this.speedResetIndex);
          }
        }
      },
      {
        key: "resume",
        value: function resume() {
          if (this.web_socket_ !== undefined) {
            const resumeCommand = this.protocolHelper.getPauseControlCommand(
              false
            );
            this.web_socket_.send(resumeCommand);
            this.playing_ = true;
          }
        }
      },
      {
        key: "setTechOption",
        value: function setTechOption(option) {
          this.protocolHelper = protocolFormater(option);
          if (option.speedConfig !== undefined) {
            this.supportedSpeeds = option.supportedSpeeds;
            this.speedResetIndex = option.defaultSpeedIndex;
          }
          this.onNotification = option.onNotification;
          this.onTimePosition = option.onTimePosition;
          this.onSpeedChange = option.onSpeedChange;
		  this.playbackSpeed = option.playbackSpeed;
        }
      },
      {
        key: "processStringMessage",
        value: function processStringMessage(data) {
          const notifyData = JSON.parse(data);
          if (notifyData.MessageType === "TIMEPOSITION") {
            if (
              this.waitSyncTimePosition !== true ||
              notifyData.Sync === true
            ) {
              this.currentTimePosition = notifyData.Timestamp;
			  
              if (this.startTimePosition === null) {
                this.startTimePosition = notifyData.Timestamp;
              }
              if (notifyData.Sync === true) {
                this.waitSyncTimePosition = false;
                this.setCurrentTime(
                  (notifyData.Timestamp - this.startTimePosition) / 1000
                );
              }
              if (this.onTimePosition) {
                this.onTimePosition(notifyData);
              }
            }
          } else if (this.onNotification) {
            this.onNotification(notifyData);
          }
        }
      }
    ]);

    return Fmp4;
  })(Html5);

  // Add Source Handler pattern functions to this tech

  Tech.withSourceHandlers(Fmp4);

  Fmp4.nativeSourceHandler.canHandleSource = function(source, options) {
    if (source.type === "video/fmp4") return true;
    else {
      if (source.type) {
        return Html5.nativeSourceHandler.canPlayType(source.type);
      }
    }
    return false;
  };

  Fmp4.nativeSourceHandler.handleSource = function(source, tech, options) {
    tech.setSrc(source.src);
  };

  /**
   * noop for native source handler dispose, as cleanup will happen automatically.
   */
  Fmp4.nativeSourceHandler.dispose = function() {};

  // Register the native source handler
  Fmp4.registerSourceHandler(Fmp4.nativeSourceHandler);

  videojs.registerTech("Fmp4", Fmp4);

  //export default Fmp4;
});
