/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */
/**
 * API Status: **Private**
 * @exports nmodule/driver/rc/wb/mgr/schedule/scheduleMgrUtils
 * @since Niagara 4.14
 */
define([], function () {
  'use strict';

  var scheduleMgrUtils = {};

  /**
   * Returns the ext slot value inside a subject component
   * @param {baja.Component} component
   * @returns {baja.Component|null}
   */
  scheduleMgrUtils.getExt = function (component) {
    //return the ext component inside given component
    var ext = component.get("ext");
    if (ext != null && ext.getType().is('driver:ScheduleImportExt')) {
      return ext;
    }
    var cursor = component.getSlots();
    while (cursor.next()) {
      var slot = cursor.get();
      if (slot.isProperty() && slot.getType().is('driver:ScheduleImportExt')) {
        return component.get(slot);
      }
    }
    return null;
  };
  return scheduleMgrUtils;
});
//# sourceMappingURL=scheduleMgrUtils.js.map
