function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/driver/rc/wb/mgr/point/PointLearn
 * @since Niagara 4.14
 */
define(['baja!', 'nmodule/driver/rc/wb/mgr/point/PointLearnNode', 'Promise'], function (baja, PointLearnNode, Promise) {
  'use strict';

  /**
   * @class
   * @alias module:nmodule/driver/rc/wb/mgr/point/PointLearn
   */
  return /*#__PURE__*/function () {
    /**
     * 
     * @param {string} bqlQuery the discover BQL query string
     */
    function PointLearn(bqlQuery) {
      _classCallCheck(this, PointLearn);
      this.$bqlQuery = bqlQuery;
    }

    /**
     * 
     * @returns {baja.Ord}
     */
    return _createClass(PointLearn, [{
      key: "getBqlQuery",
      value: function getBqlQuery() {
        return this.$bqlQuery;
      }

      /**
       * Subclass must implement 
       * @abstract
       * @returns {Promise.<Object>}
       */
    }, {
      key: "getBqlResult",
      value: function getBqlResult() {
        throw new Error('getBqlResult() function not implemented.');
      }

      /**
       * @abstract
       * @param {baja.Component} value the interim decoded Component representing one data row
       * @returns {module:nmodule/driver/rc/wb/mgr/point/PointLearnNode}
       */
    }, {
      key: "makeNode",
      value: function makeNode(value) {
        throw new Error('makeNode() function not implemented.');
      }

      /**
       * @param {object} params 
       * @param {module:nmodule/webEditors/rc/wb/table/tree/TreeTableModel} params.learnModel
       * @returns {Promise}
       */
    }, {
      key: "bqlDiscover",
      value: function bqlDiscover(params) {
        var _this = this;
        var learnModel = params.learnModel;
        return this.getBqlResult().then(function (result) {
          //Store the results so that they can be accessed later by the manager
          _this.$bqlResults = result;
          return result && _this.$updateTable(result.contents, learnModel);
        });
      }

      /**
       * @private
       * @param {Array.<Object>|Object} data 
       * @param {module:nmodule/webEditors/rc/wb/table/tree/TreeTableModel} learnModel 
       * @returns {Promise}
       */
    }, {
      key: "$updateTable",
      value: function $updateTable(data, learnModel) {
        var _this2 = this;
        if (Array.isArray(data)) {
          return Promise.all(data.map(function (d) {
            return baja.bson.decodeAsync(d);
          })).then(function (values) {
            return values.map(function (value) {
              return _this2.makeNode(value);
            });
          }).then(function (nodes) {
            return learnModel.clearRows().then(function () {
              return learnModel.insertRows(nodes, 0);
            });
          });
        } else {
          return Promise.resolve();
        }
      }
    }]);
  }();
});
//# sourceMappingURL=PointLearn.js.map
