function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/driver/rc/wb/mgr/history/HistoryExportModel
 */

define(['Promise', "nmodule/driver/rc/rpc/driverHistory", 'nmodule/driver/rc/wb/mgr/history/historyMgrUtils', 'nmodule/webEditors/rc/wb/mgr/model/MgrModel', 'nmodule/webEditors/rc/wb/table/model/source/ContainerComponentSource'], function (Promise, driverHistory, historyMgrUtils, MgrModel, ContainerComponentSource) {
  'use strict';

  var getDriverHistoryInfo = driverHistory.getDriverHistoryInfo;
  var getArchiveMgrColumns = historyMgrUtils.getArchiveMgrColumns;

  /**
   * Base class for history export managers (Niagara, Bacnet, etc.)
   * @alias module:nmodule/driver/rc/wb/mgr/history/HistoryExportModel
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrModel
   */
  return /*#__PURE__*/function (_MgrModel) {
    function HistoryExportModel() {
      _classCallCheck(this, HistoryExportModel);
      return _callSuper(this, HistoryExportModel, arguments);
    }
    _inherits(HistoryExportModel, _MgrModel);
    return _createClass(HistoryExportModel, null, [{
      key: "make",
      value:
      /**
       * @param {baja.Component} historyContainer a `HistoryDeviceExt` or `IArchiveFolder`
       * @param {object} [params]
       * @param {Function} [params.mgrModelConstructor] what type of MgrModel to instantiate
       * @param {Array.<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>} [params.newTypes] what kind
       *  of new types this history export manager can instantiate
       * @param {Array.<module:nmodule/webEditors/rc/wb/mgr/model/MgrColumn>} [params.columns] what
       *  columns this history export manager will have
       * @returns Promise.<module:nmodule/driver/rc/wb/mgr/HistoryExportModel>}
       */
      function make(historyContainer) {
        var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          _ref$mgrModelConstruc = _ref.mgrModelConstructor,
          Super = _ref$mgrModelConstruc === void 0 ? HistoryExportModel : _ref$mgrModelConstruc,
          _ref$newTypes = _ref.newTypes,
          newTypes = _ref$newTypes === void 0 ? [] : _ref$newTypes,
          _ref$columns = _ref.columns,
          columns = _ref$columns === void 0 ? getArchiveMgrColumns() : _ref$columns,
          _ref$includeTypes = _ref.includeTypes,
          includeTypes = _ref$includeTypes === void 0 ? ['driver:HistoryExport'] : _ref$includeTypes;
        return getDriverHistoryInfo(historyContainer).then(function (_ref2) {
          var archiveFolderType = _ref2.archiveFolderType,
            supportsArchiveFolders = _ref2.supportsArchiveFolders;
          if (supportsArchiveFolders) {
            includeTypes.push(archiveFolderType);
          }
          return new Super({
            componentSource: new ContainerComponentSource({
              container: historyContainer,
              filter: includeTypes
            }),
            columns: columns,
            filter: includeTypes,
            newTypes: newTypes
          });
        });
      }
    }]);
  }(MgrModel);
});
//# sourceMappingURL=HistoryExportModel.js.map
