function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/driver/rc/wb/mgr/history/HistoryExportLearn
 * @since Niagara 4.14
 */

define(['baja!', 'underscore', 'Promise', 'nmodule/driver/rc/wb/mgr/history/HistoryExportLearnNode'], function (baja, _, Promise, HistoryExportLearnNode) {
  'use strict';

  /**
   * Builds history learn model.
   * @class
   * @alias module:nmodule/driver/rc/wb/mgr/history/HistoryExportLearn
   */
  return /*#__PURE__*/function () {
    function HistoryExportLearn() {
      _classCallCheck(this, HistoryExportLearn);
    }
    return _createClass(HistoryExportLearn, [{
      key: "discover",
      value:
      /**
       * @param {object} params
       * @param {module:nmodule/driver/rc/wb/mgr/history/HistoryExportLearnModel} params.learnModel
       * @returns {Promise}
       */
      function discover(params) {
        var _this = this;
        var learnModel = params.learnModel;
        return this.$resolveHistorySpace().then(function (results) {
          return results && _this.$updateTable(results, learnModel);
        });
      }

      /**
       * @private
       * @returns {Promise.<Array.<baja.NavNode>>} a promise that will be resolved
       * once the nav children of historySpace have been retrieved.
       */
    }, {
      key: "$resolveHistorySpace",
      value: function $resolveHistorySpace() {
        return baja.Ord.make("history:").get().then(function (historySpace) {
          return historySpace.getNavChildren().then(function (devices) {
            return Promise.all(devices.map(function (device) {
              return device.getNavChildren();
            })).then(function (children) {
              return devices;
            });
          });
        });
      }

      /**
       * @private
       * @param {Array.<Object>|Object} data the data returned from the station
       * @param learnModel
       * @returns {Promise}
       */
    }, {
      key: "$updateTable",
      value: function $updateTable(data, learnModel) {
        if (Array.isArray(data)) {
          return Promise.all(data.map(function (device) {
            return new HistoryExportLearnNode(device);
          })).then(function (devices) {
            return learnModel.clearRows().then(function () {
              return learnModel.insertRows(devices);
            });
          });
        }
        return Promise.resolve();
      }
    }]);
  }();
});
//# sourceMappingURL=HistoryExportLearn.js.map
