/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/**
 * @module nmodule/driver/rc/wb/mgr/PointMgr
 */
define(['baja!', 'underscore', 'nmodule/driver/rc/wb/mgr/DriverMgr', 'baja!driver:ProxyExt'], function (baja, _, DriverMgr) {
  'use strict';

  var CONTROL_POINT_TYPE = baja.lt('control:ControlPoint');

  /**
   * Return the BStatus if the row's subject is a control point. This is used when setting the
   * status color css on the row.
   *
   * @param {*} subject - the subject for a row in the table. Normally either a BControlPoint subclasss or BFolder.
   * @returns {baja.Status} - the status for the point, or null if the row is not a control point.
   */
  function getControlPointStatus(subject) {
    return baja.hasType(subject, baja.lt(CONTROL_POINT_TYPE)) ? subject.getOut().getStatus() : null;
  }

  /**
   * API Status: **Development**
   * 
   * Instance for managing points inside a container.
   *
   * @class
   * @alias module:nmodule/driver/rc/wb/mgr/PointMgr
   * @extends module:nmodule/driver/rc/wb/mgr/DriverMgr
   *
   * @param {Object} [params] an object containing the constructor parameters.
   * @param {String} [params.keyName] the key name used for lexicon entries for this view.
   * @param {String} [params.moduleName] the module name used for lexicon entries for this view.
   * @param {Number} [params.subscriptionDepth] the depth to subscribe the component tree. If not
   * specified, the default depth will be 3, which will subscribe to the first level of properties
   * on a point's proxy extension.
   * @param {module:nmodule/webEditors/rc/wb/util/subscriptionUtil~SubscriptionFilter} [params.subscriptionFilter]
   * Starting in Niagara 4.13, if the optional subscriptionFilter function is provided, it will be called for each
   * potentially subscribable BComponent with its current depth. By returning true only for the desired components,
   * the subscription will subscribe to what is needed.
   * @param {module:nmodule/webEditors/rc/wb/util/subscriptionUtil~SubscribeCallback} [params.subscribeCallback]
   * Starting in Niagara 4.13, if the optional subscribeCallback function is provided, it will receive a callback when a component is subscribed.
   * This can allow you to add additional subscriptions outside the normal depth and filter results.
   */
  var PointMgr = function PointMgr(params) {
    var that = this;

    // Set the subscription depth, if one is specified in the parameters. If it's not specified,
    // we'll default to 3, so we get the first level of properties on the point's proxy
    // extension.

    DriverMgr.call(that, _.defaults(params, {
      subscriptionDepth: 3,
      editableTypes: [CONTROL_POINT_TYPE],
      getComponentStatus: getControlPointStatus
    }));
  };
  PointMgr.prototype = Object.create(DriverMgr.prototype);
  PointMgr.prototype.constructor = PointMgr;

  /**
   * Function to return an array of types to be offered upon the execution
   * of the command to add new instances.
   *
   * @returns {Array.<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>}
   */
  PointMgr.prototype.getNewTypes = function () {
    var model = this.getMainTable().value();
    return model.getNewTypes();
  };
  return PointMgr;
});
//# sourceMappingURL=PointMgr.js.map
