/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

define(['baja!', 'Promise'], function (baja, Promise) {
  'use strict';

  /**
   * RPC methods for interacting with driver history objects.
   *
   * @exports nmodule/driver/rc/rpc/driverHistory
   */
  var exports = {};

  /**
   * @param {baja.Component} comp
   * @returns {Promise.<module:nmodule/driver/rc/rpc/driverHistory~DriverHistoryInfo>}
   */
  exports.getDriverHistoryInfo = function (comp) {
    if (!comp.isMounted()) {
      return Promise.reject(new Error('component not mounted'));
    }
    return baja.rpc({
      typeSpec: 'driver:DriverHistoryRpc',
      method: 'getDriverHistoryInfo',
      args: [comp.getNavOrd().toString()]
    });
  };
  return exports;

  /**
   * @typedef {object} module:nmodule/driver/rc/rpc/driverHistory~DriverHistoryInfo
   * @property {string} archiveFolderType
   * @property {boolean} supportsArchiveFolders
   */
});
//# sourceMappingURL=driverHistory.js.map
