function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/driver/rc/fe/TuningPolicyEditor
 */

define(['baja!', 'jquery', 'underscore', 'bajaux/events', 'bajaux/spandrel', 'bajaux/Widget', 'Promise', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/baja/util/slotUtils'], function (baja, $, _, events, spandrel, Widget, Promise, compUtils, slotUtils) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-TuningPolicyEditor'
      },
      rows: []
    };
  };

  /**
   * A manager field editor for selecting Tuning Policies
   *
   * @class
   * @alias module:nmodule/driver/rc/fe/TuningPolicyEditor
   * @extends module:bajaux/Widget
   * @since Niagara 4.12
   */
  var TuningPolicyEditor = /*#__PURE__*/function (_spandrel) {
    function TuningPolicyEditor(params) {
      _classCallCheck(this, TuningPolicyEditor);
      return _callSuper(this, TuningPolicyEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }
    _inherits(TuningPolicyEditor, _spandrel);
    return _createClass(TuningPolicyEditor, [{
      key: "doLoad",
      value: function doLoad(param) {
        var _arguments = arguments,
          _this = this;
        return this.$loadPolicies().then(function (policyListObj) {
          if (policyListObj) {
            _this.$tuningPolicies = policyListObj;
          }
          return _superPropGet(TuningPolicyEditor, "doLoad", _this, 3)(_arguments);
        });
      }

      /**
       * Returns the tuning policies for the identified ords
       * @private
       * @returns {Array} array of tuning policies names and display names
       */
    }, {
      key: "$loadPolicies",
      value: function $loadPolicies() {
        var _this2 = this;
        return this.$getOrdBase().then(function (comp) {
          return _this2.$createPolicyArray(comp);
        });
      }

      /**
       * Describes where in the station this editor is being used
       * @private
       * @returns {Promise.<baja.Component|undefined>} promise to be resolved with a
       * Component to use as a base when resolving ORDs, or `undefined` if not
       * present
       */
    }, {
      key: "$getOrdBase",
      value: function $getOrdBase() {
        return Promise.resolve(this.properties().getValue('ordBase') || this.getComplex && this.getComplex());
      }

      /**
       * @private
       * @param {baja.Complex} comp
       * @returns {Promise.<object>} resolves an object of tuning policies names and display names
       */
    }, {
      key: "$createPolicyArray",
      value: function $createPolicyArray(comp) {
        var policyListObj = {};
        if (this.$comp !== comp && comp) {
          this.$comp = comp;
          var network = compUtils.closest(comp, "driver:DeviceNetwork");
          if (network) {
            return network.lease().then(function () {
              var policyMap = network.get("tuningPolicies");
              return policyMap.lease().then(function () {
                policyMap.getSlots().is('driver:TuningPolicy').each(function (slot) {
                  if (!slotUtils.isHidden(slot) && !slotUtils.isHidden(policyMap.getPropertyInParent())) {
                    policyListObj[slot.getName()] = policyMap.getDisplayName(slot);
                  }
                });
                return policyListObj;
              });
            });
          } else {
            return policyListObj;
          }
        } else {
          return policyListObj;
        }
      }

      /**
       * @private
       * @param {string} strValue
       * @returns {object}
       */
    }, {
      key: "$buildEditor",
      value: function $buildEditor(strValue) {
        return [spandrel.jsx("div", {
          "class": "-t-TuningPolicyEditor-layout",
          spandrelKey: "tuningpolicy-layout"
        }, spandrel.jsx("any", {
          "class": "-t-TuningPolicyEditor-stringVal",
          value: strValue,
          spandrelKey: "strVal",
          properties: {
            datalist: this.$tuningPolicies,
            filterWhileTyping: false
          }
        }))];
      }

      /**
       * @private
       */
    }, {
      key: "$getStrVal",
      value: function $getStrVal() {
        return this.queryWidget('tuningpolicy-layout/**/strVal');
      }
    }, {
      key: "doRead",
      value: function doRead() {
        return this.$getStrVal().read();
      }
    }]);
  }(spandrel(function (strValue, params) {
    return this.$buildEditor(strValue, params.formFactor);
  }, {
    strategy: 'niagara'
  }));
  return TuningPolicyEditor;
});
//# sourceMappingURL=TuningPolicyEditor.js.map
