function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/driver/rc/fe/LinearConversionEditor
 */
define(['nmodule/webEditors/rc/fe/baja/BaseEditor', 'jquery', 'Promise', 'baja!', 'baja!driver:LinearConversion', 'nmodule/webEditors/rc/fe/fe', 'lex!driver', 'bajaux/events', 'hbs!nmodule/driver/rc/fe/templates/LinearConversionEditor', 'css!nmodule/driver/rc/driver'], function (BaseEditor, $, Promise, baja, types, fe, lexs, events, templateEditor) {
  'use strict';

  var driverLex = lexs[0];
  var DESTROY_EVENT = events.DESTROY_EVENT,
    INITIALIZE_EVENT = events.INITIALIZE_EVENT,
    LOAD_EVENT = events.LOAD_EVENT,
    ENABLE_EVENT = events.ENABLE_EVENT,
    DISABLE_EVENT = events.DISABLE_EVENT,
    MODIFY_EVENT = events.MODIFY_EVENT,
    READONLY_EVENT = events.READONLY_EVENT,
    WRITABLE_EVENT = events.WRITABLE_EVENT;

  /**
   * LinearConversionEditor is a bajaux field editor a BProxyConversion
   * property. This property is a proxy conversion type that
   * additionally takes scale and offset parameters. It is
   * part of a composite Proxy Extension component of any protocol point.
   *
   * @private
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/driver/rc/fe/LinearConversionEditor
   */
  var LinearConversionEditor = function LinearConversionEditor() {
    BaseEditor.apply(this, arguments);
  };

  //extend and set up prototype chain
  LinearConversionEditor.prototype = Object.create(BaseEditor.prototype);
  LinearConversionEditor.prototype.constructor = LinearConversionEditor;

  /**
   * Initial is a one-time setup activity. The select html control is
   * initialized with all possible proxy extension types available to be set.
   *
   * @param {jQuery} dom the DOM element into which to load this widget
   * @return {Promise}
   */
  LinearConversionEditor.prototype.doInitialize = function (dom) {
    var that = this;
    //Disable events from bubbling up
    dom.on([DESTROY_EVENT, INITIALIZE_EVENT, LOAD_EVENT, ENABLE_EVENT, DISABLE_EVENT, READONLY_EVENT, WRITABLE_EVENT].join(' '), '.editor', false);
    dom.on(MODIFY_EVENT, '.editor', function () {
      that.setModified(true);
      return false;
    });
    dom.html(templateEditor({
      labels: {
        scale: driverLex.get("LinearConversion.scale"),
        offset: driverLex.get("LinearConversion.offset")
      }
    }));
    return Promise.all([fe.buildFor({
      value: 0.0,
      dom: $(".js-scale", dom.children(".js-scaleEditor")),
      properties: {
        prelabel: driverLex.get("LinearConversion.scale"),
        uxFieldEditor: "webEditors:StringEditor"
      }
    }), fe.buildFor({
      value: 0.0,
      dom: $(".js-offset", dom.children(".js-offsetEditor")),
      properties: {
        prelabel: driverLex.get("LinearConversion.offset"),
        uxFieldEditor: "webEditors:StringEditor"
      }
    })]);
  };
  /**
   * Get the scale editor widget
   * @returns {module:nmodule/webEditors/rc/fe/baja/BaseEditor} the scale editor
   */
  LinearConversionEditor.prototype.$getScaleEditor = function () {
    return this.jq().find(".js-scale").data("widget");
  };

  /**
   * Get the offset editor widget
   * @returns {module:nmodule/webEditors/rc/fe/baja/BaseEditor} the offset editor
   */
  LinearConversionEditor.prototype.$getOffsetEditor = function () {
    return this.jq().find(".js-offset").data("widget");
  };

  /**
   * The field editor is of type driver:LinearConversion and loaded into
   * by any confirming types. The loaded in value is then set as default
   * values of the scale and offset widgets.
   *
   * @param {baja.Simple} value `driver:LinearConversion` instance to load
   * @return {Promise}
   */
  LinearConversionEditor.prototype.doLoad = function (value) {
    var vals = value.encodeToString() === "" ? [1, 0] : value.encodeToString().split(";");
    return Promise.all([this.$getScaleEditor().load(parseFloat(vals[0])), this.$getOffsetEditor().load(parseFloat(vals[1]))]);
  };

  /**
   * driver:LinearConversion is the type that is set so it matches
   * the loaded in value type.
   *
   * @returns {Promise} promise to be resolved with the current value
   */
  LinearConversionEditor.prototype.doRead = function () {
    return Promise.all([this.$getScaleEditor().read(), this.$getOffsetEditor().read()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        scale = _ref2[0],
        offset = _ref2[1];
      return baja.$("driver:LinearConversion", scale, offset);
    });
  };

  /**
   * Enables or disables the scale and offset text boxes.
   *
   * @param {Boolean} enabled
   */
  LinearConversionEditor.prototype.doEnabled = function (enabled) {
    return this.getChildEditors().setAllEnabled(enabled);
  };

  /**
   * Disables or enables the scale and offset text boxes.
   *
   * @param {Boolean} readonly
   */
  LinearConversionEditor.prototype.doReadonly = function (readonly) {
    return this.getChildEditors().setAllReadonly(readonly);
  };

  /**
   * Destroy all the child editors
   * @returns {*}
   */
  LinearConversionEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };
  return LinearConversionEditor;
});
//# sourceMappingURL=LinearConversionEditor.js.map
