function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/schedule/rc/model/TimeOfDay
 */
define([], function () {
  'use strict';

  var MS = 1,
    SEC = 1000 * MS,
    MIN = 60 * SEC,
    HR = 60 * MIN,
    DAY = 24 * HR,
    REGEX = /(2[0-3]|[0-1][0-9]):([0-5][0-9])(:(\d{2})(\.(\d{3}))?)?/;

  /**
   * Vanilla representation of a time of day intended to be more or less API
   * compatible with `baja.Time`.
   *
   * @class
   * @alias module:nmodule/schedule/rc/model/TimeOfDay
   */
  var TimeOfDay = function TimeOfDay(hour, min, sec, ms) {
    var millis;
    if (hour instanceof TimeOfDay) {
      return hour;
    }
    if (typeof hour === 'string') {
      millis = strToMillis(this, hour);
    } else {
      if (_typeof(hour) === 'object') {
        if (hour.getType && hour.getType().is('baja:Time')) {
          millis = hour.getTimeOfDayMillis();
        } else if (typeof hour.millis === 'number') {
          millis = hour.millis;
        } else {
          millis = MS * (hour.ms || 0) + SEC * (hour.sec || 0) + MIN * (hour.min || 0) + HR * hour.hour;
        }
      } else {
        millis = MS * (ms || 0) + SEC * (sec || 0) + MIN * (min || 0) + HR * (hour || 0);
      }
    }
    millis = Math.floor(Math.max(millis, 0)) % DAY;
    Object.defineProperty(this, '$millis', {
      value: millis,
      configurable: false,
      writable: false,
      enumerable: false
    });
    hour = this.$hour = Math.floor(millis / HR);
    millis -= hour * HR;
    min = this.$min = Math.floor(millis / MIN);
    millis -= min * MIN;
    sec = this.$sec = Math.floor(millis / SEC);
    millis -= sec * SEC;
    this.$ms = millis;
  };

  /**
   * Get the hour part.
   * @returns {number}
   */
  TimeOfDay.prototype.getHour = function () {
    return this.$hour;
  };

  /**
   * Get the minute part.
   * @returns {number}
   */
  TimeOfDay.prototype.getMinute = function () {
    return this.$min;
  };

  /**
   * Get the second part.
   * @returns {number}
   */
  TimeOfDay.prototype.getSecond = function () {
    return this.$sec;
  };

  /**
   * Get the millisecond part.
   * @returns {number}
   */
  TimeOfDay.prototype.getMillisecond = function () {
    return this.$ms;
  };

  /**
   * Get the number of milliseconds past midnight.
   * @returns {number}
   */
  TimeOfDay.prototype.getTimeOfDayMillis = function () {
    return this.$millis;
  };
  TimeOfDay.prototype.equals = function (obj) {
    return obj instanceof TimeOfDay && this.$millis === obj.$millis;
  };
  TimeOfDay.prototype.valueOf = function () {
    return this.getTimeOfDayMillis();
  };
  TimeOfDay.prototype.toJson = function () {
    return {
      hour: this.$hour,
      min: this.$min,
      sec: this.$sec,
      ms: this.$ms
    };
  };
  TimeOfDay.prototype.toString = function () {
    return pad(this.$hour, 2) + ':' + pad(this.$min, 2);
    //+ ':' + pad(this.$sec, 2) + '.' + pad(this.$ms, 3);
  };
  TimeOfDay.MILLIS_IN_SECOND = SEC;
  TimeOfDay.MILLIS_IN_MINUTE = MIN;
  TimeOfDay.MILLIS_IN_HOUR = HR;
  TimeOfDay.MILLIS_IN_DAY = DAY;
  function strToMillis(time, str) {
    var m = REGEX.exec(str);
    if (!m) {
      throw new Error('time format must be HH:mm:ss.sss');
    }
    return (time.$hour = +m[1]) * HR + (time.$min = +m[2]) * MIN + (time.$sec = +(m[4] || 0)) * SEC + (time.$ms = +(m[6] || 0)) * MS;
  }
  function pad(num, length) {
    var str = String(num);
    while (str.length < length) {
      str = '0' + str;
    }
    return str;
  }
  return TimeOfDay;
});
