function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/schedule/rc/fe/Scheduler
 */
define(['baja!', 'lex!baja', 'jquery', 'Promise', 'underscore', 'bajaux/events', 'bajaux/mixin/responsiveMixIn', 'bajaux/Properties', 'bajaux/mixin/subscriberMixIn', 'bajaux/util/SaveCommand', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/webEditors/rc/fe/baja/TabbedCompositeEditor', 'nmodule/webEditors/rc/fe/baja/util/DepthSubscriber', 'nmodule/webEditors/rc/fe/config/CompositeBuilder', 'nmodule/schedule/rc/baja/model/ScheduleTranslator', 'nmodule/schedule/rc/baja/fe/BajaWeekEditor', 'nmodule/schedule/rc/fe/ScheduleSummaryView', 'nmodule/schedule/rc/fe/SpecialEventsEditor', 'nmodule/schedule/rc/fe/menu/DayScheduleContextMenu', 'nmodule/schedule/rc/fe/menu/WeekScheduleContextMenu', 'nmodule/schedule/rc/servlets/ssc', 'nmodule/schedule/rc/util/scheduleUtils', 'css!nmodule/schedule/rc/fe/schedule'], function (baja, lexs, $, Promise, _, events, responsiveMixIn, Properties, subscribable, SaveCommand, switchboard, TabbedCompositeEditor, DepthSubscriber, CompositeBuilder, ScheduleTranslator, BajaWeekEditor, ScheduleSummaryView, SpecialEventsEditor, DayScheduleContextMenu, WeekScheduleContextMenu, ssc, scheduleUtils) {
  'use strict';

  var bajaLex = lexs[0],
    MODIFY_EVENT = events.MODIFY_EVENT;
  var tpl = function tpl(ed) {
    return "\n    <div class=\"ux-tab-bar-container ux-fixed-header\"></div>\n    <div class=\"ux-tab-panel-container ux-fullscreen-support ux-body ux-tab-content ux-no-scroll\">\n      <div class=\"week-panel ux-fullscreen ux-tab-inner-content\"></div>\n      <div class=\"specialEvents-panel ux-fullscreen ux-tab-inner-content\"></div>\n      <div class=\"scheduleSummary-panel ux-fullscreen ux-tab-inner-content\"></div>\n    </div>";
  };

  /**
   * Scheduler
   *
   * A Tabbed Editor that has three tabs (weekly schedule, special events, summary)
   *
   * @class
   * @alias module:nmodule/schedule/rc/fe/Scheduler
   * @extends module:nmodule/webEditors/rc/fe/baja/TabbedCompositeEditor
   * @param {Object} params
   */
  var Scheduler = function Scheduler(params) {
    var that = this;
    switchboard(this, {
      $reloadSummary: {
        allow: 'oneAtATime',
        onRepeat: 'returnLast'
      }
    });
    TabbedCompositeEditor.call(that, $.extend({}, {
      moduleName: 'schedule',
      keyName: 'Scheduler'
    }, params));

    // TODO Testk
    that.getCommandGroup().add(new SaveCommand());

    // TODO Test
    subscribable(this);
    this.$subscriber = new DepthSubscriber(7);
    responsiveMixIn(this, {
      'scheduler-sm': {
        maxWidth: 760
      }
    });
  };
  Scheduler.prototype = Object.create(TabbedCompositeEditor.prototype);
  Scheduler.prototype.constructor = Scheduler;
  var getTimeLabels = _.once(function () {
    return Promise.all([3, 6, 9, 12, 15, 18, 21].map(function (hour) {
      return baja.Time.make({
        hour: hour
      }).toTimeString();
    }));
  });
  Scheduler.prototype.doInitialize = function (dom) {
    var that = this;
    dom.addClass('Scheduler ux-fullscreen').html(tpl(this));

    // TODO Test
    dom.on(MODIFY_EVENT, '.ux-tab-panel-container', function () {
      that.setModified(true);
      that.$reloadSummaryOnShowTabPanel = true;
      return false;
    });
    return TabbedCompositeEditor.prototype.doInitialize.call(that, dom.find('.ux-tab-bar-container'));
  };
  Scheduler.prototype.doLoad = function (weeklySchedule) {
    var _this = this;
    var orgArguments = arguments;
    var navOrd = weeklySchedule.getNavOrd();
    return ssc.loadScheduleInfo(navOrd).then(function (_ref) {
      var snapshot = _ref.snapshot,
        refBase = _ref.refBase,
        options = _ref.options;
      _this.$snapshot = snapshot;
      _this.$refBase = refBase;
      _this.$sourceOrd = weeklySchedule.getNavOrd();
      _this.$translator = new ScheduleTranslator(snapshot.get('facets'));
      _this.$options = options;
      return _this.$translator.toModel(snapshot);
    }).then(function (model) {
      _this.$model = model;
      return TabbedCompositeEditor.prototype.doLoad.apply(_this, orgArguments);
    }).then(function () {
      // TODO Test
      new WeekScheduleContextMenu(_this.$getWeekEditor()).arm();
      new DayScheduleContextMenu(_this.$getSpecialEventsEditor().$getDayEditor()).arm();
      var builder = _this.getBuilder(),
        weekEd = builder.getEditorFor('week'),
        eventsEd = builder.getEditorFor('specialEvents');
      weekEd.on('defaultOutputChanged', function (value) {
        return eventsEd.properties().add('defaultOutput', value);
      });
      weekEd.on('facetsChanged', function (value) {
        eventsEd.properties().add('facets', value);
        _this.$translator.facets(value);
      });
      if (_this.$options.readonly) {
        return _this.setReadonly(true);
      }
    });
  };

  /**
   * Show the Tab Panel and if the is a pending reload summary request from a modification, reload the summary view.
   * @param {String} choice
   * @returns {Promise}
   * @private
   */
  Scheduler.prototype.$showTabPanel = function (choice) {
    var _this2 = this;
    return Promise.resolve(TabbedCompositeEditor.prototype.$showTabPanel.apply(this, arguments)).then(function () {
      if (choice === "scheduleSummary" && _this2.$reloadSummaryOnShowTabPanel) {
        _this2.$reloadSummaryOnShowTabPanel = false;
        return _this2.$reloadSummary()["catch"](baja.error);
      }
    });
  };

  /**
   * When the Scheduler is modified, update the Schedule Summary after waiting
   * for the tab be be shown.
   * @returns {Promise}
   * @private
   */
  Scheduler.prototype.$reloadSummary = function () {
    var builder = this.getBuilder(),
      summaryEd = builder.getEditorFor('scheduleSummary');
    return this.read().then(function (value) {
      return summaryEd.load(value);
    });
  };
  Scheduler.prototype.makeBuilder = function () {
    var that = this,
      builder = new CompositeBuilder();
    builder.getKeys = function () {
      return ['week', 'specialEvents', 'scheduleSummary'];
    };
    builder.getDomFor = function (key) {
      return that.jq().find(".".concat(key, "-panel"));
    };
    builder.getValueFor = function (key) {
      switch (key) {
        case 'week':
          return that.$model;
        case 'specialEvents':
          return that.$snapshot.get('schedule').get('specialEvents');
        case 'scheduleSummary':
          return that.$snapshot;
      }
    };
    builder.getTabFor = function (key) {
      switch (key) {
        case 'week':
          return {
            module: 'schedule',
            lex: 'scheduler.weeklySchedule'
          };
        case 'specialEvents':
          return {
            module: 'schedule',
            lex: 'scheduler.specialEvents'
          };
        case 'scheduleSummary':
          return {
            module: 'schedule',
            lex: 'scheduler.scheduleSummary'
          };
      }
    };
    builder.getConfigFor = function (key) {
      var snapshot = that.$snapshot,
        defaultOutput = snapshot.get('defaultOutput'),
        facets = snapshot.get('facets'),
        effectiveValue = scheduleUtils.getNewBlockValue(defaultOutput, facets);
      switch (key) {
        case 'week':
          return getTimeLabels().then(function (timeLabels) {
            return {
              type: BajaWeekEditor,
              properties: Properties.extend(facets.toObject(), {
                effectiveValue: effectiveValue,
                firstDayOfWeek: bajaLex.get('weekday.firstDayOfWeek'),
                snapshot: snapshot,
                timeLabels: timeLabels,
                translator: that.$translator,
                sourceOrd: that.$sourceOrd
              })
            };
          });
        case 'specialEvents':
          return getTimeLabels().then(function (timeLabels) {
            return {
              type: SpecialEventsEditor,
              properties: {
                defaultOutput: defaultOutput.newCopy(),
                effectiveValue: effectiveValue,
                facets: facets,
                refBase: that.$refBase,
                sourceOrd: that.$sourceOrd,
                includeReference: true,
                timeLabels: timeLabels,
                translator: that.$translator
              }
            };
          });
        case 'scheduleSummary':
          return {
            type: ScheduleSummaryView,
            properties: {
              facets: facets,
              refBase: that.$refBase,
              sourceOrd: that.$sourceOrd
            }
          };
      }
    };
    return builder;
  };
  Scheduler.prototype.$getPropertiesElement = function () {
    return this.jq().find('.properties');
  };
  Scheduler.prototype.$getTabElement = function (key) {
    return this.jq().children('.ux-tab-panel-container').children('.' + key + '-panel');
  };
  Scheduler.prototype.$getWeekEditor = function () {
    return this.getBuilder().getEditorFor('week');
  };

  /**
   * Read the WeekSchedule and ignore any validation errors. This allows the
   * Summary Tab to get the current value of all valid changes without bothering
   * the user about any changes that are not yet valid.
   */
  Scheduler.prototype.$doReadWeekSchedule = function () {
    var that = this,
      weekEd = that.$getWeekEditor();
    return weekEd.read().then(function (weekSchedule) {
      return that.$translator.fromModel(weekSchedule);
    });
  };

  /**
   * Save the WeekSchedule and report any validation errors.
   */
  Scheduler.prototype.$doSaveWeekSchedule = function () {
    var that = this,
      weekEd = that.$getWeekEditor();
    return weekEd.save().then(function () {
      return weekEd.read();
    }).then(function (weekSchedule) {
      return that.$translator.fromModel(weekSchedule);
    });
  };
  Scheduler.prototype.$getSpecialEventsEditor = function () {
    return this.getBuilder().getEditorFor('specialEvents');
  };
  Scheduler.prototype.$doReadSpecialEvents = function () {
    return this.$getSpecialEventsEditor().read();
  };
  Scheduler.prototype.$doSaveSpecialEvents = function () {
    var specialEventsEd = this.$getSpecialEventsEditor();
    return specialEventsEd.save().then(function () {
      return specialEventsEd.read();
    });
  };
  Scheduler.prototype.$getScheduleSummaryView = function () {
    return this.getBuilder().getEditorFor('scheduleSummary');
  };

  /**
   * Collect the current state of the Scheduler for any field editors
   * that properly validate, but do not save them. This includes the weekly
   * schedule, special events, and any changes to facets so that the Summary Tab
   * can use this to display the current events as they are being edited.
   * @returns {Promise}
   */
  Scheduler.prototype.doRead = function () {
    var that = this;
    return Promise.all([that.$doReadWeekSchedule(), that.$doReadSpecialEvents(), that.$translator.facets()]).then(function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 3),
        weekSchedule = _ref3[0],
        specialEvents = _ref3[1],
        facets = _ref3[2];
      that.$snapshot.get('schedule').set({
        slot: 'week',
        value: weekSchedule
      });
      that.$snapshot.get('schedule').set({
        slot: 'specialEvents',
        value: specialEvents
      });
      that.$snapshot.set({
        slot: 'facets',
        value: facets
      });
      return that.$snapshot;
    });
  };
  Scheduler.prototype.doSave = function () {
    var that = this;
    return Promise.all([that.$doSaveWeekSchedule(), that.$doSaveSpecialEvents(), that.getChildEditors().saveAll()]).then(function (_ref4) {
      var _ref5 = _slicedToArray(_ref4, 2),
        weekSchedule = _ref5[0],
        specialEvents = _ref5[1];
      that.$snapshot.get('schedule').set({
        slot: 'week',
        value: weekSchedule
      });
      that.$snapshot.get('schedule').set({
        slot: 'specialEvents',
        value: specialEvents
      });
      return ssc.save(that.value().getNavOrd(), that.$snapshot);
    });
  };
  Scheduler.prototype.doDestroy = function () {
    this.jq().removeClass('ux-fullscreen Scheduler');
    return TabbedCompositeEditor.prototype.doDestroy.apply(this, arguments);
  };
  Scheduler.prototype.doReadonly = function (readonly) {
    return this.getChildWidgets().setAllReadonly(readonly);
  };
  Scheduler.prototype.doEnabled = function (enabled) {
    return this.getChildWidgets().setAllEnabled(enabled);
  };
  return Scheduler;
});
