/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Tony Richards
 * @since Niagara 4.4
 */

/**
 * API Status: **Private**
 * @module nmodule/schedule/rc/baja/fe/ReferenceScheduleOrdEditor
 */
define(['baja!', 'jquery', 'underscore', 'bajaux/events', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/schedule/rc/servlets/ssc'], function (baja, $, _, events, fe, BaseEditor, OrderedMapEditor, ssc) {
  'use strict';

  var DESTROY_EVENT = events.DESTROY_EVENT,
    INITIALIZE_EVENT = events.INITIALIZE_EVENT,
    LOAD_EVENT = events.LOAD_EVENT,
    ENABLE_EVENT = events.ENABLE_EVENT,
    DISABLE_EVENT = events.DISABLE_EVENT,
    MODIFY_EVENT = events.MODIFY_EVENT,
    READONLY_EVENT = events.READONLY_EVENT,
    WRITABLE_EVENT = events.WRITABLE_EVENT;

  /**
   * @class
   * @alias module:nmodule/schedule/rc/baja/fe/ReferenceScheduleOrdEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @param params
   */
  var ReferenceScheduleOrdEditor = function ReferenceScheduleOrdEditor(params) {
    var _this = this;
    BaseEditor.apply(this, arguments);

    /**
     * Get the underlying OrderedMap that maps the ord path to Ord for all
     * CalendarSchedule objects in the station.
     *
     * @returns {Promise.<OrderedMap>} the ordered map that contains the path ->
     *     Ord mapping for all CalendarSchedule objects in the station.
     */
    this.getOrderedMap = _.once(function () {
      return ssc.findCalendarSchedules(_this.properties().getValue("sourceOrd")).then(function (ordList) {
        var map = new baja.OrderedMap();
        ordList.forEach(function (ord) {
          map.put(String(ord), ord);
        });
        return map;
      });
    });
  };
  ReferenceScheduleOrdEditor.prototype = Object.create(BaseEditor.prototype);
  ReferenceScheduleOrdEditor.prototype.constructor = ReferenceScheduleOrdEditor;
  ReferenceScheduleOrdEditor.prototype.doInitialize = function (dom) {
    var that = this;
    //Disable events from bubbling up
    dom.on([DESTROY_EVENT, INITIALIZE_EVENT, LOAD_EVENT, ENABLE_EVENT, DISABLE_EVENT, READONLY_EVENT, WRITABLE_EVENT].join(' '), '.editor', false);
    dom.on(MODIFY_EVENT, '.editor', function () {
      that.setModified(true);
      return false;
    });
    return that.getOrderedMap().then(function (orderedMap) {
      return fe.buildFor({
        dom: $('<div class="calendarList"/>').appendTo(dom),
        type: OrderedMapEditor,
        value: orderedMap
      }).then(function (orderedMapEditor) {
        that.$orderedMapEditor = orderedMapEditor;
      });
    });
  };
  ReferenceScheduleOrdEditor.prototype.doLoad = function (value) {
    this.$orderedMapEditor.setSelectedKey(value.toString());
  };
  ReferenceScheduleOrdEditor.prototype.doRead = function () {
    if (this.$orderedMapEditor.getSelectedKey()) {
      return this.$orderedMapEditor.read();
    } else {
      return this.value();
    }
  };
  ReferenceScheduleOrdEditor.prototype.doEnabled = function (enabled) {
    return this.getChildEditors().setAllEnabled(enabled);
  };
  ReferenceScheduleOrdEditor.prototype.doReadonly = function (readonly) {
    return this.getChildEditors().setAllReadonly(readonly);
  };
  ReferenceScheduleOrdEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };
  return ReferenceScheduleOrdEditor;
});
