function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */
define(['lex!schedule', 'Promise', 'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor', 'nmodule/schedule/rc/baja/fe/DateScheduleEditor', 'nmodule/schedule/rc/util/scheduleUtils'], function (lexs, Promise, ComplexCompositeEditor, DateScheduleEditor, scheduleUtils) {
  'use strict';

  var scheduleLex = lexs[0],
    checkValidDateRange = scheduleUtils.checkValidDateRange;

  /**
   * Editor for a `schedule:DateRangeSchedule`.
   *
   * @class
   * @alias module:nmodule/schedule/rc/fe/DateRangeScheduleEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor
   */
  var DateRangeScheduleEditor = function DateRangeScheduleEditor() {
    var that = this;
    ComplexCompositeEditor.apply(that, arguments);
    that.validators().add(function () {
      if (!that.value()) {
        return;
      }
      var builder = that.getBuilder();
      return Promise.all([builder.getEditorFor('start').read(), builder.getEditorFor('end').read()]).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
          start = _ref2[0],
          end = _ref2[1];
        if (!checkValidDateRange(start, end)) {
          throw new Error(scheduleLex.get('daterange.startAfterEnd'));
        }
      });
    });
  };
  DateRangeScheduleEditor.prototype = Object.create(ComplexCompositeEditor.prototype);
  DateRangeScheduleEditor.prototype.constructor = DateRangeScheduleEditor;

  /**
   * Use the default editors for the `start` and `end` `DateRangeSchedule`s,
   * using the same form factor as the `DateRangeScheduleEditor` itself.
   *
   * @returns {Array.<Object>}
   */
  DateRangeScheduleEditor.prototype.getSlotFilter = function () {
    var formFactor = this.getFormFactor();
    return [{
      slot: 'start',
      formFactor: formFactor,
      type: DateScheduleEditor
    }, {
      slot: 'end',
      formFactor: formFactor,
      type: DateScheduleEditor
    }];
  };
  return DateRangeScheduleEditor;
});
