function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 * @author Nutan Naik
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/weather/rc/wb/baja/nws/NwsWeatherProvideEditor
 * @since Niagara 4.14
 */

define(['baja!', 'baja!weather:NwsWeatherProvider', 'lex!weather', 'jquery', 'Promise', 'underscore', 'bajaux/spandrel', 'bajaux/mixin/subscriberMixIn', 'nmodule/webEditors/rc/fe/baja/BooleanEditor'], function (baja, types, lexs, $, Promise, _, spandrel, subscriberMixIn, BooleanEditor) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-NwsWeatherProvideEditor'
      }
    };
  };
  var _lexs = _slicedToArray(lexs, 1),
    weatherLex = _lexs[0];
  var ENABLED_TXT = weatherLex.get("airQuality.enabled");
  var DISABLED_TXT = weatherLex.get("airQuality.disabled");
  var AIR_QUALITY_TXT = weatherLex.get("airQuality.label");

  /**
   * Editor for `NwsWeatherProvider`.
   *
   * @class
   * @alias module:nmodule/weather/rc/wb/baja/nws/NwsWeatherProvideEditor
   * @extends module:bajaux/spandrel/SpandrelWidget
   * @since Niagara 4.14
   **/
  var NwsWeatherProviderEditor = /*#__PURE__*/function (_spandrel) {
    function NwsWeatherProviderEditor(params) {
      var _this;
      _classCallCheck(this, NwsWeatherProviderEditor);
      _this = _callSuper(this, NwsWeatherProviderEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      subscriberMixIn(_this);
      return _this;
    }

    /**
       * Updates locations based on the selected state.
       * @private
       */
    _inherits(NwsWeatherProviderEditor, _spandrel);
    return _createClass(NwsWeatherProviderEditor, [{
      key: "$updateLocations",
      value: function $updateLocations() {
        var selectedVal = this.$getStateSelect().val();
        var locations = this.$getLocations(selectedVal);
        this.state({
          locations: locations,
          selectedState: selectedVal,
          selectedLocation: locations[0]
        });
        this.setModified(true);
      }

      /**
       * Updates locations based on the selected state.
       * @private
       */
    }, {
      key: "$updateLocation",
      value: function $updateLocation() {
        this.state({
          selectedLocation: this.$getLocationSelect().val()
        });
        this.setModified(true);
      }

      /**
       * Get the weather stations using rpc.
       *
       * @private
       * @returns {Array.<Object>}
       */
    }, {
      key: "$getNwsWeatherStations",
      value: function $getNwsWeatherStations() {
        return baja.rpc({
          typeSpec: "weather:WeatherRpc",
          method: "getNwsWeatherStations",
          args: []
        });
      }

      /**
       * Get all the states from weather stations.
       * @private
       * @return {Array.<String>}
       */
    }, {
      key: "$getStates",
      value: function $getStates() {
        var states = this.$weatherDetails.map(function (weatherObj) {
          return weatherObj.state;
        });
        return _.uniq(states).sort();
      }

      /**
       * Get all the locations for the state.
       * @private
       * @param {String} state
       * @return {Array.<String>}
       */
    }, {
      key: "$getLocations",
      value: function $getLocations(state) {
        var locations = this.$weatherDetails.filter(function (w) {
          return w.state === state && w.name && w.latitude && w.longitude;
        });
        return locations.map(function (location) {
          return location.name;
        }).sort();
      }

      /**
       * @returns {Promise.<baja.Component>}
       */
    }, {
      key: "doSave",
      value: function doSave(readValue) {
        var realNws = this.value();
        return Promise.all([realNws.set({
          slot: 'stationId',
          value: readValue.getStationId()
        }), realNws.set({
          slot: 'airQualityEnabled',
          value: readValue.getAirQualityEnabled()
        })]);
      }

      /**
       * @returns {baja.Component}
       * @param {Object} state
       */
    }, {
      key: "fromState",
      value: function fromState(state) {
        var selectedLocation = state.selectedLocation,
          selectedState = state.selectedState,
          airQualityEnabled = state.airQualityEnabled;
        var stationId = this.$getStationId(selectedLocation, selectedState);
        return baja.$('weather:NwsWeatherProvider', {
          stationId: stationId || "",
          airQualityEnabled: airQualityEnabled
        });
      }

      /**
       * @param {baja.Component} nws
       * @returns {Object}
       */
    }, {
      key: "toState",
      value: function toState(nws) {
        var _this2 = this;
        return this.$getNwsWeatherStations().then(function (weatherDetails) {
          var stationId = nws.getStationId();
          var selectedWeatherDetails = _.find(weatherDetails, function (w) {
            return w.id === stationId;
          });
          _this2.$weatherDetails = weatherDetails;
          var states = _this2.$getStates();
          var selectedState = selectedWeatherDetails && selectedWeatherDetails.state;
          var locations = _this2.$getLocations(selectedState);
          return {
            states: states,
            locations: locations,
            selectedState: selectedState,
            selectedLocation: selectedWeatherDetails && selectedWeatherDetails.name,
            airQualityEnabled: nws.getAirQualityEnabled()
          };
        });
      }

      /**
       * Returns the station id matching state and location.
       * @private
       * @param {String} location
       * @param {String} state
       * @return {String}
       */
    }, {
      key: "$getStationId",
      value: function $getStationId(location, state) {
        var station = _.find(this.$weatherDetails, function (w) {
          return w.state === state && w.name === location;
        });
        return station && station.id;
      }

      /**
       * Get the state select element.
       *
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getStateSelect",
      value: function $getStateSelect() {
        return this.jq().find('.-t-state-select');
      }

      /**
       * Get the location select element.
       *
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getLocationSelect",
      value: function $getLocationSelect() {
        return this.jq().find('.-t-location-select');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getAirQualityEnabledEditor",
      value: function $getAirQualityEnabledEditor() {
        return this.queryWidget('NwsWeatherProviderEditor-layout/**/airQualityEnabled');
      }
    }]);
  }(spandrel(function (value, _ref) {
    var self = _ref.self,
      states = _ref.states,
      locations = _ref.locations,
      selectedState = _ref.selectedState,
      selectedLocation = _ref.selectedLocation,
      airQualityEnabled = _ref.airQualityEnabled,
      writable = _ref.writable;
    var flags = value.getFlags('stationId');
    if (flags & baja.Flags.HIDDEN || flags & baja.Flags.READONLY) {
      writable = false;
    }
    var stateOptions = states.map(function (state) {
      return spandrel.jsx("option", {
        className: "ux-option",
        value: state,
        selected: state === selectedState
      }, state);
    });
    stateOptions.unshift(spandrel.jsx("option", {
      className: "ux-option",
      value: ""
    }));
    var locationOptions = locations.map(function (location) {
      return spandrel.jsx("option", {
        className: "ux-option",
        value: location,
        selected: location === selectedLocation
      }, location);
    });
    return [spandrel.jsx("div", {
      spandrelKey: "NwsWeatherProviderEditor-layout"
    }, spandrel.jsx("div", {
      className: "-t-NwsWeatherProvideEditor-selection"
    }, spandrel.jsx("select", {
      className: "-t-state-select ux-select",
      onChange: function onChange() {
        return self.$updateLocations();
      },
      disabled: !writable
    }, stateOptions), locations.length && spandrel.jsx("select", {
      className: "-t-location-select ux-select",
      onChange: function onChange() {
        return self.$updateLocation();
      },
      disabled: !writable
    }, locationOptions)), spandrel.jsx("div", null, spandrel.jsx("label", null, AIR_QUALITY_TXT + "  "), spandrel.jsx(BooleanEditor, {
      className: "-t-NwsWeatherProvideEditor-airQualityEditor",
      value: airQualityEnabled,
      properties: {
        trueText: ENABLED_TXT,
        falseText: DISABLED_TXT
      },
      bind: true,
      spandrelKey: "airQualityEnabled",
      enabled: writable
    })))];
  }));
  return NwsWeatherProviderEditor;
});
