function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/weather/rc/wb/baja/WeatherManagerModel
 */

define(['baja!', 'baja!weather:WeatherReport,weather:WeatherProvider', 'lex!weather', 'Promise', 'underscore', 'nmodule/niagaraDriver/rc/fe/RemoteStationEditor', 'nmodule/weather/rc/wb/baja/FoxWeatherProviderEditor', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/model/MgrModel', 'nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/MgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/model/source/ContainerComponentSource'], function (baja, types, lexs, Promise, _, RemoteStationEditor, FoxWeatherProviderEditor, MgrTypeInfo, MgrModel, IconMgrColumn, NameMgrColumn, PropertyMgrColumn, MgrColumn, Column, ContainerComponentSource) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    WEATHER_LEX = _lexs[0];
  var _Column$flags = Column.flags,
    EDITABLE = _Column$flags.EDITABLE,
    READONLY = _Column$flags.READONLY,
    UNSEEN = _Column$flags.UNSEEN;
  var WEATHER_REPORT_TYPE = baja.lt('weather:WeatherReport');
  var memoize = _.memoize;

  //region Custom Columns

  /**
   * MgrColumn for current weather conditions
   *
   * @inner
   * @class
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrColumn
   */
  var CurrentColumn = /*#__PURE__*/function (_MgrColumn) {
    function CurrentColumn() {
      _classCallCheck(this, CurrentColumn);
      return _callSuper(this, CurrentColumn, ["current", {
        type: WEATHER_REPORT_TYPE,
        flags: READONLY,
        displayName: WEATHER_LEX.get("current")
      }]);
    }
    _inherits(CurrentColumn, _MgrColumn);
    return _createClass(CurrentColumn, [{
      key: "buildCell",
      value: function buildCell(row, dom) {
        var value = this.getValueFor(row);
        if (value) {
          dom.text(value.toString());
        } else {
          dom.text(WEATHER_LEX.get('current.none'));
        }
      }
    }, {
      key: "getValueFor",
      value: function getValueFor(row) {
        return row.getSubject().getCurrent();
      }
    }]);
  }(MgrColumn);
  /**
   * MgrColumn for weather forecast
   *
   * @inner
   * @class
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrColumn
   */
  var ForecastColumn = /*#__PURE__*/function (_MgrColumn2) {
    function ForecastColumn(props) {
      var _this;
      _classCallCheck(this, ForecastColumn);
      var index = props && props.index || 0;
      var name = props && props.name;
      _this = _callSuper(this, ForecastColumn, [name, {
        type: WEATHER_REPORT_TYPE,
        flags: READONLY,
        displayName: WEATHER_LEX.get(name)
      }]);
      _this.$index = index;
      return _this;
    }
    _inherits(ForecastColumn, _MgrColumn2);
    return _createClass(ForecastColumn, [{
      key: "buildCell",
      value: function buildCell(row, dom) {
        var value = this.getValueFor(row);
        if (value) {
          dom.text(value.getDisplay());
        } else {
          dom.text(WEATHER_LEX.get('forecast.none'));
        }
      }
    }, {
      key: "getValueFor",
      value: function getValueFor(row) {
        var key = "day" + this.$index;
        return row.getSubject().get(key);
      }
    }]);
  }(MgrColumn);
  /**
   * MgrColumn for advisory conditions
   *
   * @inner
   * @class
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrColumn
   */
  var AdvisoryColumn = /*#__PURE__*/function (_MgrColumn3) {
    function AdvisoryColumn() {
      _classCallCheck(this, AdvisoryColumn);
      return _callSuper(this, AdvisoryColumn, ['advisory', {
        type: WEATHER_REPORT_TYPE,
        flags: READONLY,
        displayName: WEATHER_LEX.get('advisory')
      }]);
    }
    _inherits(AdvisoryColumn, _MgrColumn3);
    return _createClass(AdvisoryColumn, [{
      key: "buildCell",
      value: function buildCell(row, dom) {
        var value = this.getValueFor(row);
        if (value) {
          dom.text(value.getWeatherSummaryDisplay());
        } else {
          dom.text(WEATHER_LEX.get('advisory.none'));
        }
      }
    }, {
      key: "getValueFor",
      value: function getValueFor(row) {
        var current = row.getSubject().getCurrent();
        var advisoryContainer = current.getAdvisories();
        return advisoryContainer.getSlots().is("weather:Advisory").firstValue();
      }
    }]);
  }(MgrColumn);
  /**
   * MgrColumn for sunrise/sunset times
   *
   * @inner
   * @class
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrColumn
   */
  var SunriseSunsetColumn = /*#__PURE__*/function (_MgrColumn4) {
    function SunriseSunsetColumn() {
      _classCallCheck(this, SunriseSunsetColumn);
      return _callSuper(this, SunriseSunsetColumn, ['sunrise_sunset', {
        type: WEATHER_REPORT_TYPE,
        flags: READONLY,
        displayName: WEATHER_LEX.get("sunrise.sunset")
      }]);
    }
    _inherits(SunriseSunsetColumn, _MgrColumn4);
    return _createClass(SunriseSunsetColumn, [{
      key: "toDisplayName",
      value: function toDisplayName() {
        return WEATHER_LEX.get("sunrise.sunset");
      }
    }, {
      key: "buildCell",
      value: function buildCell(row, dom) {
        var current = this.getValueFor(row);
        if (current) {
          dom.text(WEATHER_LEX.get('sunrise.sunset.display', current.getSunriseDisplay(), current.getSunsetDisplay()));
        } else {
          dom.text(WEATHER_LEX.get("sunrise.sunset.none"));
        }
      }
    }, {
      key: "getValueFor",
      value: function getValueFor(row) {
        return row.getSubject().getCurrent();
      }
    }]);
  }(MgrColumn); //endregion Custom Columns
  var COLUMNS = [new IconMgrColumn(), new NameMgrColumn({
    flags: EDITABLE
  }), new CurrentColumn("current"), new ForecastColumn({
    index: 0,
    name: "today"
  }), new ForecastColumn({
    index: 1,
    name: "tomorrow"
  }), new AdvisoryColumn(), new SunriseSunsetColumn(), new PropertyMgrColumn("status", {
    type: WEATHER_REPORT_TYPE,
    flags: READONLY | UNSEEN
  }), new PropertyMgrColumn("provider", {
    type: WEATHER_REPORT_TYPE,
    flags: EDITABLE | UNSEEN
  })];

  /**
   * Data model for the Weather Manager
   * @since Niagara 4.14
   * @class
   * @alias module:nmodule/weather/rc/wb/baja/WeatherManagerModel
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrModel
   */
  return /*#__PURE__*/function (_MgrModel) {
    function WeatherManagerModel() {
      var _this2;
      _classCallCheck(this, WeatherManagerModel);
      _this2 = _callSuper(this, WeatherManagerModel, arguments);

      //In case there are lots of new instances created at the same time, memorize the results for the lifetime of the WeatherManagerModel instance.
      _this2.$resolveRemoteStationName = memoize(function () {
        return RemoteStationEditor.resolveRemoteStationNames(_this2.getComponentSource().getContainer());
      });
      _this2.$resolveFirstReportOrd = memoize(function (firstStationName) {
        return FoxWeatherProviderEditor.resolveFirstReportOrd(firstStationName);
      });
      return _this2;
    }
    _inherits(WeatherManagerModel, _MgrModel);
    return _createClass(WeatherManagerModel, [{
      key: "newInstance",
      value:
      /**
       * A `weather:WeatherReport` will be created and the typeInfo will determine the `provider`.
       * If a `weather:FoxWeatherProvider` is chosen, then we'll default the `stationName`
       * to the first station in the list, and we'll default the `ord` to the first available report.
       *
       * @param {module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo} typeInfo
       * @returns {Promise<baja.Value>}
       */
      function newInstance(typeInfo) {
        var _this3 = this;
        return typeInfo.newInstance().then(function (provider) {
          var report = baja.$('weather:WeatherReport', {
            provider: provider
          });
          if (!baja.hasType(provider, 'weather:FoxWeatherProvider')) {
            return report;
          }
          return _this3.$resolveRemoteStationName().then(function (stationNamesMap) {
            var firstStationName = stationNamesMap[0];
            if (!firstStationName) {
              return report;
            }
            report.getProvider().setStationName(firstStationName);
            return _this3.$resolveFirstReportOrd(firstStationName).then(function (reportOrd) {
              if (reportOrd) {
                report.getProvider().setOrd(reportOrd);
              }
              return report;
            });
          });
        });
      }

      /**
       * Gets the CurrentColumnClass for testing
       * @private
       * @returns {CurrentColumn}
       */
    }, {
      key: "$getCurrentColumnClass",
      value: function $getCurrentColumnClass() {
        return CurrentColumn;
      }

      /**
       * Gets the ForecastColumnClass for testing
       * @private
       * @returns {ForecastColumn}
       */
    }, {
      key: "$getForecastColumnClass",
      value: function $getForecastColumnClass() {
        return ForecastColumn;
      }

      /**
       * Gets the AdvisoryColumnClass for testing
       * @private
       * @returns {AdvisoryColumn}
       */
    }, {
      key: "$getAdvisoryColumnClass",
      value: function $getAdvisoryColumnClass() {
        return AdvisoryColumn;
      }

      /**
       * Gets the AdvisoryColumnClass for testing
       * @private
       * @returns {SunriseSunsetColumn}
       */
    }, {
      key: "$getSunriseSunsetColumnClass",
      value: function $getSunriseSunsetColumnClass() {
        return SunriseSunsetColumn;
      }
    }], [{
      key: "make",
      value: function make(weatherService) {
        return MgrTypeInfo.make({
          from: 'weather:WeatherProvider',
          concreteTypes: true
        }).then(function (newTypes) {
          return new WeatherManagerModel({
            columns: COLUMNS,
            componentSource: new ContainerComponentSource({
              container: weatherService,
              filter: ['weather:WeatherReport']
            }),
            newTypes: newTypes
          });
        });
      }
    }]);
  }(MgrModel);
});
