function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 * @author Sai Komaravolu
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/weather/rc/wb/baja/FoxWeatherProviderEditor
 */

define(['baja!', 'lex!weather', 'baja!weather:FoxWeatherProvider', 'bajaux/mixin/subscriberMixIn', 'dialogs', 'Promise', 'bajaux/spandrel', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/niagaraDriver/rc/fe/RemoteStationEditor', 'css!nmodule/weather/rc/weather'], function (baja, lexs, types, subscriberMixIn, dialogs, Promise, spandrel, OrderedMapEditor, RemoteStationEditor) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
      return {
        properties: {
          rootCssClass: '-t-FoxWeatherProviderEditor'
        }
      };
    },
    _lexs = _slicedToArray(lexs, 1),
    weatherLex = _lexs[0],
    PROGRESS_BAR_DELAY = 500;

  /**
   * Ux editor for baja:FoxWeatherProvider.
   *
   * @since Niagara 4.14
   * @class
   * @alias module:nmodule/weather/rc/wb/baja/FoxWeatherProviderEditor
   * @extends {module:bajaux/spandrel}
   */
  var FoxWeatherProviderEditor = /*#__PURE__*/function (_spandrel) {
    function FoxWeatherProviderEditor(params) {
      var _this;
      _classCallCheck(this, FoxWeatherProviderEditor);
      _this = _callSuper(this, FoxWeatherProviderEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      subscriberMixIn(_this);
      _this.validators().add(function () {
        return _this.$validateReportValue();
      });
      return _this;
    }
    _inherits(FoxWeatherProviderEditor, _spandrel);
    return _createClass(FoxWeatherProviderEditor, [{
      key: "toState",
      value: function toState(foxWeatherProvider) {
        var remoteStationName = foxWeatherProvider.getStationName(),
          reportOrd = foxWeatherProvider.getOrd();
        return this.$getUpdatedStateFromWeatherReportsRpc(remoteStationName, reportOrd, true);
      }
    }, {
      key: "doSave",
      value: function doSave() {
        var _this$state = this.state(),
          remoteStationName = _this$state.remoteStationName,
          reportOrd = _this$state.reportOrd;
        return Promise.all([this.value().set({
          slot: 'stationName',
          value: remoteStationName
        }), this.value().set({
          slot: 'ord',
          value: reportOrd || baja.Ord.DEFAULT
        })]);
      }

      /**
       * Rejects if the reportOrd set in state is empty and resolves when it is not.
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$validateReportValue",
      value: function $validateReportValue() {
        var _this$state2 = this.state(),
          reportOrd = _this$state2.reportOrd;
        if (!reportOrd) {
          return Promise.reject(new Error(weatherLex.get('FoxWeatherProvider.reportRequired.message')));
        }
        return Promise.resolve();
      }

      /**
       * @private
       * @param {string} remoteStationName
       * @returns {Promise.<String>}
       */
    }, {
      key: "$getWeatherReportsForStation",
      value: function $getWeatherReportsForStation(remoteStationName) {
        return baja.rpc({
          typeSpec: 'weather:WeatherRpc',
          method: 'getWeatherReportsForStation',
          args: [remoteStationName]
        });
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getRemoteStationEditor",
      value: function $getRemoteStationEditor() {
        return this.queryWidget('**/remoteStationName');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getReportEditor",
      value: function $getReportEditor() {
        return this.queryWidget('**/reportOrd');
      }

      /**
       * @private
       * @param {Event} event
       * @param {module:bajaux/Widget} editor
       * @returns {Promise}
       */
    }, {
      key: "$updateWeatherReports",
      value: function $updateWeatherReports(event, editor) {
        var _this2 = this;
        return editor.read().then(function (stationName) {
          var promise = _this2.$getUpdatedStateFromWeatherReportsRpc(stationName);
          dialogs.showLoading(PROGRESS_BAR_DELAY, promise);
          return promise.then(function (_ref) {
            var remoteStationName = _ref.remoteStationName,
              reportOrd = _ref.reportOrd,
              reportMap = _ref.reportMap;
            return _this2.state({
              remoteStationName: remoteStationName,
              reportOrd: reportOrd,
              reportMap: reportMap
            });
          });
        });
      }

      /**
       * @private
       * @param {string} remoteStationName
       * @param {baja.Ord} reportOrd
       * @param {boolean} fromLoad true if this is from a loaded value
       * @returns {Promise.<Object>}
       */
    }, {
      key: "$getUpdatedStateFromWeatherReportsRpc",
      value: function $getUpdatedStateFromWeatherReportsRpc(remoteStationName, reportOrd, fromLoad) {
        var _this3 = this;
        return this.$resolveReportMap(remoteStationName, reportOrd, fromLoad).then(function (reportMap) {
          return _this3.$getModifiedState(reportMap, remoteStationName, reportOrd, fromLoad);
        });
      }

      /**
       * @private
       * @param {string} remoteStationName
       * @param {baja.Ord} [reportOrd]
       * @param {boolean} [fromLoad=false]
       * @returns {Promise<baja.OrderedMap>}
       */
    }, {
      key: "$resolveReportMap",
      value: function $resolveReportMap(remoteStationName, reportOrd, fromLoad) {
        var _this4 = this;
        return this.$retrieveWeatherReportsRpc(remoteStationName, reportOrd, fromLoad).then(function (reportMap) {
          if (fromLoad && !_this4.$isReportFound(reportOrd, reportMap)) {
            var reportOrdString = reportOrd.equals(baja.Ord.DEFAULT) ? '' : reportOrd.toString();
            reportMap.put(reportOrdString, reportOrd);
          }
          return reportMap;
        });
      }

      /**
       * @private
       * @param {string} remoteStationName
       * @param {baja.Ord} [reportOrd]
       * @param {boolean} [fromLoad=false]
       * @returns {Promise<baja.OrderedMap>}
       */
    }, {
      key: "$retrieveWeatherReportsRpc",
      value: function $retrieveWeatherReportsRpc(remoteStationName, reportOrd, fromLoad) {
        var _this5 = this;
        return this.$getWeatherReportsForStation(remoteStationName).then(function (reportJson) {
          return _this5.$decodeReportJson(reportJson);
        }).then(function (vector) {
          var reportMap = new baja.OrderedMap();
          vector.getSlots().toValueArray().forEach(function (reportComponent) {
            reportMap.put(reportComponent.get('name'), reportComponent.get('ord'));
          });
          return reportMap;
        });
      }

      /**
       * @private
       * @param {string} reportJson
       * @returns {Promise}
       */
    }, {
      key: "$decodeReportJson",
      value: function $decodeReportJson(reportJson) {
        return baja.bson.decodeAsync(JSON.parse(reportJson));
      }

      /**
       * @private
       * @param {baja.OrderedMap} reportMap
       * @param {string} remoteStationName
       * @param {baja.Ord} reportOrd
       * @param {boolean} fromLoad true if this from a loaded value.
       */
    }, {
      key: "$getModifiedState",
      value: function $getModifiedState(reportMap, remoteStationName, reportOrd, fromLoad) {
        var selectedReport = fromLoad ? reportOrd : this.$getSelectedReport(reportOrd, reportMap);
        return {
          remoteStationName: remoteStationName,
          reportOrd: selectedReport,
          reportMap: reportMap
        };
      }
      /**
       * @private
       * @param {baja.Ord} reportOrd
       * @param {baja.OrderedMap} reportMap
       * @returns {baja.Ord|undefined}
       */
    }, {
      key: "$getSelectedReport",
      value: function $getSelectedReport(reportOrd, reportMap) {
        if (!reportOrd) {
          return reportMap.getFromIndex(0) || undefined;
        }
        if (this.$isReportFound(reportOrd, reportMap)) {
          return reportMap.getFromIndex(0);
        }
        return reportOrd;
      }

      /**
       * @private
       * @param {baja.Ord} reportOrd
       * @param {baja.OrderedMap} reportMap
       * @returns {boolean}
       */
    }, {
      key: "$isReportFound",
      value: function $isReportFound(reportOrd, reportMap) {
        return reportMap.getKeys().find(function (key) {
          return reportMap.get(key).equals(reportOrd);
        });
      }

      /**
       * @param {String} remoteStationName
       * @returns {Promise.<baja.Ord>}
       */
    }], [{
      key: "resolveFirstReportOrd",
      value: function resolveFirstReportOrd(remoteStationName) {
        var editor = new FoxWeatherProviderEditor();
        return editor.$resolveReportMap(remoteStationName).then(function (reportMap) {
          return reportMap.getFromIndex(0) || baja.Ord.DEFAULT;
        });
      }
    }]);
  }(spandrel(function (comp, _ref2) {
    var self = _ref2.self,
      remoteStationName = _ref2.remoteStationName,
      reportOrd = _ref2.reportOrd,
      reportMap = _ref2.reportMap;
    reportOrd = reportOrd || baja.Ord.DEFAULT;
    return spandrel.jsx("div", {
      className: "-t-FoxWeatherProviderEditor-wrapper"
    }, spandrel.jsx(RemoteStationEditor, {
      bind: true,
      spandrelKey: "remoteStationName",
      value: remoteStationName,
      properties: {
        allowCustomEntry: false
      },
      onUxModify: function onUxModify(event, editor) {
        return self.$updateWeatherReports(event, editor);
      }
    }), spandrel.jsx(OrderedMapEditor, {
      bind: true,
      lax: true,
      spandrelKey: "reportOrd",
      value: reportOrd,
      properties: {
        map: reportMap
      }
    }));
  }, {
    strategy: 'niagara'
  }));
  return FoxWeatherProviderEditor;
});
