function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/**
 * API Status: **Private**
 * @module nmodule/niagaraDriver/rc/wb/mgr/NiagaraStationUxManager
 */

define(['baja!', 'baja!baja:IMixIn,fox:FoxConnection,niagaraDriver:NiagaraNetwork,niagaraDriver:NiagaraStation,niagaraDriver:NiagaraStationFolder', 'log!nmodule.niagaraDriver.rc.wb.mgr.NiagaraStationUxManager', 'Promise', 'underscore', 'nmodule/driver/rc/wb/mgr/DeviceMgr', 'nmodule/niagaraDriver/rc/wb/mgr/commands/NiagaraCertManagerHyperlinkCommand', 'nmodule/niagaraDriver/rc/wb/mgr/NiagaraStationLearnContextMenu', 'nmodule/niagaraDriver/rc/wb/mgr/model/NiagaraStationLearnModel', 'nmodule/niagaraDriver/rc/wb/mgr/model/NiagaraStationManagerModel', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/servlets/userData', 'nmodule/webEditors/rc/wb/mgr/MgrLearn', 'nmodule/webEditors/rc/wb/mgr/model/mgrAgents', 'nmodule/webEditors/rc/wb/tree/TreeNode', 'nmodule/webEditors/rc/wb/util/subscriptionUtil'], function (baja, types, log, Promise, _, DeviceMgr, NiagaraCertManagerHyperlinkCommand, NiagaraStationLearnContextMenu, NiagaraStationLearnModel, NiagaraStationManagerModel, compUtils, userData, addMgrLearnSupport, mgrAgents, TreeNode, subscriptionUtil) {
  'use strict';

  var logSevere = log.severe.bind(log);
  var constant = _.constant;
  var HOST_NAME_USERDATA_KEY = 'StationMgr.useHostName';
  var get = userData.get,
    put = userData.put;
  var MIX_IN = 'baja:IMixIn';
  var FOX_CONNECTION = 'fox:FoxConnection';
  var NIAGARA_NETWORK = 'niagaraDriver:NiagaraNetwork';
  var NIAGARA_STATION = 'niagaraDriver:NiagaraStation';
  var NIAGARA_STATION_FOLDER = 'niagaraDriver:NiagaraStationFolder';
  var basicSubscriptionFilter = subscriptionUtil.basicSubscriptionFilter;
  function makeDiscoveryTableNode(station) {
    var stationName = station.getStationName();
    var node = new TreeNode(stationName, stationName);
    node.getIcon = constant(station.getIcon());
    node.mayHaveKids = constant(false);
    node.value = constant(station);
    return node;
  }
  function isEdgeLite(subject) {
    return baja.hasType(subject, 'niagaraDriver:NiagaraEdgeLiteStation');
  }

  /**
   * @returns {Promise}
   */
  function subscribeServerConnection(comp, sub) {
    return comp.getServerConnection().then(function (serverConnection) {
      return serverConnection && sub.subscribe(serverConnection);
    });
  }

  /**
   * @returns {Promise}
   */
  function subscribeMixins(comp, sub) {
    return mgrAgents.getMixInManagerSubscriptions(comp).then(function (comps) {
      comps = _.flatten(comps);
      if (comps.length) {
        return sub.subscribe(comps);
      }
    });
  }

  /**
   * A bajaux Device Manager View for NiagaraDriver
   *
   * @class
   * @extends module:nmodule/driver/rc/wb/mgr/DeviceMgr
   * @alias module:nmodule/niagaraDriver/rc/wb/mgr/NiagaraStationUxManager
   *
   */
  var NiagaraStationUxManager = /*#__PURE__*/function (_DeviceMgr) {
    function NiagaraStationUxManager() {
      var _this;
      _classCallCheck(this, NiagaraStationUxManager);
      _this = _callSuper(this, NiagaraStationUxManager, [{
        moduleName: 'niagaraDriver',
        keyName: 'NiagaraStationUxManager',
        folderType: NIAGARA_STATION_FOLDER,
        subscribeCallback: function subscribeCallback(_ref) {
          var comp = _ref.comp,
            sub = _ref.sub;
          var isDevice = comp.getType().is(NIAGARA_STATION);
          if (!isDevice) {
            return;
          }
          return Promise.all([subscribeServerConnection(comp, sub), subscribeMixins(comp, sub)]);
        },
        subscriptionFilter: function subscriptionFilter(filterParams) {
          if (basicSubscriptionFilter(Object.assign({
            allowedDepth: 2,
            componentTypes: [MIX_IN, FOX_CONNECTION]
          }, filterParams))) {
            return true;
          }
          return basicSubscriptionFilter(Object.assign({
            containerTypes: [NIAGARA_STATION_FOLDER, NIAGARA_NETWORK],
            componentTypes: [NIAGARA_STATION_FOLDER, NIAGARA_STATION]
          }, filterParams));
        }
      }]);
      addMgrLearnSupport(_this);
      return _this;
    }
    _inherits(NiagaraStationUxManager, _DeviceMgr);
    return _createClass(NiagaraStationUxManager, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this,
          _arguments = arguments;
        this.on('jobcomplete', function (job) {
          _this2.$doDiscoveryJobComplete(job)["catch"](logSevere);
        });
        return NiagaraCertManagerHyperlinkCommand.make().then(function (cmd) {
          _this2.$certHyperLinkCommand = cmd;
          if (baja.isOffline()) {
            // Returning "false" so that the $useHostName will be set to false
            return "false";
          }
          return get(HOST_NAME_USERDATA_KEY);
        }).then(function (useHostName) {
          _this2.$useHostName = useHostName === "true" || !useHostName;
          return _superPropGet(NiagaraStationUxManager, "doInitialize", _this2, 3)(_arguments);
        });
      }

      /**
       * Add the NiagaraCertManagerHyperlinkCommand
       * @since Niagara 4.13
       * @returns {Array<module:bajaux/commands/Command>}
       */
    }, {
      key: "makeCommands",
      value: function makeCommands() {
        var _this3 = this;
        return _superPropGet(NiagaraStationUxManager, "makeCommands", this, 1).apply(this, arguments).then(function (cmds) {
          return cmds.concat(_this3.$certHyperLinkCommand);
        });
      }
    }, {
      key: "componentChanged",
      value: function componentChanged(comp, prop) {
        var _this4 = this;
        if (comp.getType().is(FOX_CONNECTION)) {
          var connectionName = comp.getName();
          _.each(this.getModel().getRows(), function (row) {
            var rowConnectionName = row.data('serverConnectionName');
            if (rowConnectionName === connectionName) {
              _this4.getModel().getComponentSource().handleChanged(row.getSubject());
            }
          });
        } else {
          _superPropGet(NiagaraStationUxManager, "componentChanged", this, 3)(arguments);
        }
      }

      /**
       * @param {baja.Component} component
       * @returns {Promise.<module:nmodule/niagaraDriver/rc/wb/mgr/model/NiagaraStationManagerModel>}
       */
    }, {
      key: "makeModel",
      value: function makeModel(component) {
        return NiagaraStationManagerModel.make(component);
      }

      /**
       * @returns {Promise.<module:nmodule/webEditors/rc/wb/table/tree/TreeTableModel>}
       */
    }, {
      key: "makeLearnModel",
      value: function makeLearnModel() {
        return NiagaraStationLearnModel.make();
      }

      /**
       * @param {baja.Struct} subject a `fox:LearnStation`
       * @returns {Promise.resolve<Array.<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>>}
       */
    }, {
      key: "getTypesForDiscoverySubject",
      value: function getTypesForDiscoverySubject(subject) {
        var types = this.getModel().getNewTypes();

        // Bring edge lite to the top if the subject is also an edge lite
        if (subject.getNiagaraPlatformType()) {
          var edgeLiteIndex = -1;
          for (var i = 0; i < types.length; i++) {
            if (isEdgeLite(types[i])) {
              edgeLiteIndex = i;
              break;
            }
          }
          if (edgeLiteIndex !== -1) {
            var typeInfo = types[edgeLiteIndex];
            types.splice(edgeLiteIndex, 1);
            types.unshift(typeInfo);
          }
        }
        return Promise.resolve(types);
      }

      /**
       * @param {baja.Struct} discovery a `fox:LearnStation`
       * @returns {Object}
       */
    }, {
      key: "getProposedValuesFromDiscovery",
      value: function getProposedValuesFromDiscovery(discovery) {
        var targetAddress = this.getUseHostName() ? discovery.getHostName() : discovery.getHostAddress();
        var address = baja.Ord.make("ip:".concat(targetAddress));
        return {
          name: discovery.getStationName(),
          values: {
            useFoxs: discovery.getScheme() === 'foxs',
            address: address,
            port: baja.Integer.make(discovery.getFoxPort())
          }
        };
      }

      /**
       * @returns {Promise}
       */
    }, {
      key: "doDiscover",
      value: function doDiscover() {
        var _this5 = this;
        var network = this.getNetwork();
        return network.submitStationDiscoveryJob().then(function (ord) {
          ord = baja.Ord.make({
            base: baja.Ord.make('station:'),
            child: ord.relativizeToSession()
          });
          return _this5.setJob(ord);
        });
      }

      /**
       * Returns true if the database table and discovery table station
       * names match
       *
       * @param {module:nmodule/fox/rc/baja/LearnStation} learnStation
       * @param {module:nmodule/niagaraDriver/rc/nd/NiagaraStation} dbStation
       */
    }, {
      key: "isExisting",
      value: function isExisting(learnStation, dbStation) {
        if (!baja.hasType(dbStation, 'niagaraDriver:NiagaraStation')) {
          return false;
        }
        return dbStation.getName() === learnStation.getStationName();
      }

      /**
       *
       * @returns {baja.Component}
       */
    }, {
      key: "getNetwork",
      value: function getNetwork() {
        return compUtils.closest(this.value(), 'niagaraDriver:NiagaraNetwork');
      }

      /**
       *
       * @returns {object}
       */
    }, {
      key: "saveStateForOrd",
      value: function saveStateForOrd() {
        var obj = {};
        if (this.$discoveredStations) {
          obj.discoveredStations = this.$discoveredStations.map(function (station) {
            return baja.bson.encodeValue(station);
          });
        }
        return obj;
      }

      /**
       * @param {object} param
       * @param {Array} param.discoveredStations
       * @returns {Promise}
       */
    }, {
      key: "restoreStateForOrd",
      value: function restoreStateForOrd(_ref2) {
        var _this6 = this;
        var discoveredStations = _ref2.discoveredStations;
        if (discoveredStations) {
          return Promise.all(discoveredStations.map(function (station) {
            return baja.bson.decodeAsync(station);
          })).then(function (decodedStations) {
            _this6.$discoveredStations = decodedStations;
            return _this6.$updateLearnTableModel();
          });
        }
        return Promise.resolve();
      }
    }, {
      key: "armLearnTableContextMenu",
      value: function armLearnTableContextMenu(table, jq, selector) {
        new NiagaraStationLearnContextMenu(table, this).arm(jq, selector);
      }

      /**
       * @returns {boolean} true if using the host name for the address, false if host address is used.
       */
    }, {
      key: "getUseHostName",
      value: function getUseHostName() {
        return this.$useHostName;
      }

      /**
       * Update whether the discovery table should use the host name or host address for the address
       * column.
       *
       * @param {boolean} useHostName true if the discovery table should use the host name, false if
       * the discovery table should use the host address
       * @returns {Promise}
       */
    }, {
      key: "updateUseHostName",
      value: function updateUseHostName(useHostName) {
        var _this7 = this;
        this.$useHostName = useHostName;
        return this.$updateStationAddresses(useHostName).then(function () {
          return Promise.all([_this7.$updateLearnTableModel(), put(HOST_NAME_USERDATA_KEY, JSON.stringify(useHostName))]);
        });
      }

      /**
       * @private
       * @param {baja.Component} job
       * @returns {Promise}
       */
    }, {
      key: "$doDiscoveryJobComplete",
      value: function $doDiscoveryJobComplete(job) {
        var _this8 = this;
        // TODO lease the job?
        if (job.getType().is('niagaraDriver:StationDiscoveryJob')) {
          this.$discoveredStations = job.getSlots().is('fox:LearnStation').toValueArray();
          return this.$updateStationAddresses(this.$useHostName).then(function () {
            return _this8.$updateLearnTableModel();
          });
        }
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$updateLearnTableModel",
      value: function $updateLearnTableModel() {
        var learnModel = this.getLearnModel();
        if (this.$discoveredStations) {
          var nodes = this.$discoveredStations.map(makeDiscoveryTableNode);
          return learnModel.clearRows().then(function () {
            return learnModel.insertRows(nodes, 0);
          });
        }
        return Promise.resolve();
      }

      /**
       * @param {boolean }useHostName
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$updateStationAddresses",
      value: function $updateStationAddresses(useHostName) {
        var discoveredStations = this.$discoveredStations;
        if (discoveredStations) {
          return Promise.all(discoveredStations.map(function (learnStation) {
            return learnStation.invariant(useHostName);
          }));
        } else {
          return Promise.resolve();
        }
      }
    }]);
  }(DeviceMgr);
  return NiagaraStationUxManager;
});
