function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/niagaraDriver/rc/wb/mgr/NiagaraHistoryImportLearn
 */
define(['baja!', 'baja!niagaraDriver:NiagaraSystemHistoryImport', 'lex!history,niagaraDriver', 'Promise', 'nmodule/history/rc/historyUtil', 'nmodule/niagaraDriver/rc/rpc/history', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/wb/mgr/MgrLearn', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/model/columns/IconColumn', 'nmodule/webEditors/rc/wb/table/tree/TreeTableModel', 'nmodule/webEditors/rc/wb/tree/TreeNode'], function (baja, types, lexs, Promise, historyUtil, history, compUtils, MgrLearn, MgrTypeInfo, Column, IconColumn, TreeTableModel, TreeNode) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 2),
    historyLex = _lexs[0],
    niagaraDriverLex = _lexs[1];
  var closest = compUtils.closest;
  var discoverHistories = history.discoverHistories;
  var acceptSystemTags = historyUtil.acceptSystemTags;
  var REMOTE_PREFIX = niagaraDriverLex.get('historyImportManager.remote');
  var HISTORY_ICON = baja.Icon.make('module://icons/x16/history.png');
  var HISTORY_DEVICE_ICON = baja.Icon.make('module://icons/x16/device.png');

  /**
   * Discovery functionality for the Niagara History Import Manager.
   *
   * @class
   * @alias module:nmodule/niagaraDriver/rc/wb/mgr/NiagaraHistoryImportLearn
   * @since Niagara 4.14
   */
  var NiagaraHistoryImportLearn = /*#__PURE__*/function () {
    function NiagaraHistoryImportLearn() {
      _classCallCheck(this, NiagaraHistoryImportLearn);
    }
    return _createClass(NiagaraHistoryImportLearn, [{
      key: "makeLearnModel",
      value:
      /**
       * Creates the discovery table model.
       *
       * @returns {Promise<module:nmodule/webEditors/rc/wb/table/tree/TreeTableModel>}
       */
      function makeLearnModel() {
        return TreeTableModel.make({
          columns: [new HistoryIconColumn(), new DisplayNameColumn('displayName', {
            displayName: historyLex.get('historyId')
          }), new SystemTagsColumn('systemTags', {
            displayName: historyLex.get('historyExtManager.systemTags')
          })]
        });
      }

      /**
       * Makes the RPC call up to the station to discover histories and updates the contents of the
       * manager's discovery table.
       *
       * @returns {Promise}
       */
    }, {
      key: "doDiscover",
      value: function doDiscover() {
        var learnModel = this.$mgr.getLearnModel();
        return this.$fetchTreeNodes().then(function (nodes) {
          return learnModel.clearRows().then(function () {
            return learnModel.insertRows(nodes);
          });
        });
      }

      /**
       * @private
       * @returns {Promise.<Array.<module:nmodule/webEditors/rc/wb/tree/TreeNode>>} the TreeNodes that
       * will populate the discovery table, populated with discovered history data from the station.
       */
    }, {
      key: "$fetchTreeNodes",
      value: function $fetchTreeNodes() {
        return this.$rpcDiscovery().then(function (discoveredDevices) {
          return discoveredDevices.map(function (discoveredDevice) {
            return new DiscoveredHistoryDeviceTreeNode(discoveredDevice);
          });
        });
      }

      /**
       * @private
       * @returns {Promise.<Array.<module:nmodule/niagaraDriver/rc/rpc/history~DiscoveredHistoryDeviceInfo>>}
       */
    }, {
      key: "$rpcDiscovery",
      value: function $rpcDiscovery() {
        return discoverHistories(this.$histories);
      }

      /**
       * @param {module:nmodule/niagaraDriver/rc/rpc/history~DiscoveredHistoryInfo|*} discovery a
       * discovered history from the station in the discovery table
       * @param {baja.Component} component a `niagaraDriver:NiagaraHistoryImport` in the database
       * table
       * @returns {boolean} true if the discovered object represents the same history import as the
       * component
       */
    }, {
      key: "isExisting",
      value: function isExisting(discovery, component) {
        if (!isHistoryNode(discovery)) {
          return false;
        }
        if (isNiagaraSystemHistory(component)) {
          var systemTags = discovery.systemTags.getNames();
          var systemTagPatterns = component.get('systemTagPatterns');
          return acceptSystemTags(systemTags, systemTagPatterns);
        } else if (isHistoryImport(component)) {
          var discoveredHistoryId = discovery.historyId;
          var existingHistoryId = component.get('historyId');
          return discoveredHistoryId.equivalent(existingHistoryId) || discoveredHistoryId.toShorthand(this.$stationName).equivalent(existingHistoryId);
        } else {
          return false;
        }
      }

      /**
       * Discovered histories get added to the database in the form of a `NiagaraHistoryImport`.
       *
       * @param {module:nmodule/niagaraDriver/rc/rpc/history~DiscoveredHistoryInfo|*} discovery
       * @returns {Promise.Array.<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>}
       */
    }, {
      key: "getTypesForDiscoverySubject",
      value: function getTypesForDiscoverySubject(discovery) {
        return isHistoryNode(discovery) ? MgrTypeInfo.make(['niagaraDriver:NiagaraHistoryImport']) : Promise.resolve([]);
      }

      /**
       * When adding a discovered history to the database, generate a component name for the
       * `NiagaraHistoryImport` based on the discovered history ID.
       *
       * @param {module:nmodule/niagaraDriver/rc/rpc/history~DiscoveredHistoryInfo} discovery
       * @param {baja.Component} component the `NiagaraHistoryImport` to be added or matched
       * @returns {{ name: string, values: { historyId: module:nmodule/history/rc/baja/HistoryId } }}
       */
    }, {
      key: "getProposedValuesFromDiscovery",
      value: function getProposedValuesFromDiscovery(discovery, component) {
        var historyId = discovery.historyId;
        var shorthandId = historyId.toShorthand(this.$stationName);
        var name = component.getName();
        if (!name) {
          //adding new instance
          name = deriveDefaultNameFromHistoryId(shorthandId);
        }
        return {
          name: name,
          values: {
            historyId: shorthandId
          }
        };
      }
    }], [{
      key: "mixin",
      value:
      /**
       * Mixes in the discovery functionality to the manager instance.
       *
       * @param {module:nmodule/niagaraDriver/rc/wb/mgr/NiagaraHistoryImportUxManager} mgr
       * @returns {module:nmodule/niagaraDriver/rc/wb/mgr/NiagaraHistoryImportLearn}
       */
      function mixin(mgr) {
        MgrLearn(mgr);
        var learn = new NiagaraHistoryImportLearn();
        learn.$mgr = mgr;
        mgr.on('loaded', function (value) {
          var histories;
          if (baja.hasType(value, 'niagaraDriver:NiagaraHistoryDeviceExt')) {
            histories = value;
          } else if (baja.hasType(value, 'driver:ArchiveFolder')) {
            histories = closest(value, 'niagaraDriver:NiagaraHistoryDeviceExt');
            if (!histories) {
              throw new Error('not rooted under a NiagaraHistoryDeviceExt');
            }
          } else {
            throw new Error('NiagaraHistoryDeviceExt required');
          }
          var niagaraStation = closest(histories, 'niagaraDriver:NiagaraStation');
          if (!niagaraStation) {
            throw new Error('not rooted under a NiagaraStation');
          }
          learn.$histories = histories;
          learn.$stationName = niagaraStation.getName();
        });
        ['doDiscover', 'getProposedValuesFromDiscovery', 'getTypesForDiscoverySubject', 'isExisting', 'makeLearnModel'].forEach(function (functionName) {
          mgr[functionName] = learn[functionName].bind(learn);
        });
        return learn;
      }
    }]);
  }(); // region support classes
  var HistoryIconColumn = /*#__PURE__*/function (_IconColumn) {
    function HistoryIconColumn() {
      _classCallCheck(this, HistoryIconColumn);
      return _callSuper(this, HistoryIconColumn, arguments);
    }
    _inherits(HistoryIconColumn, _IconColumn);
    return _createClass(HistoryIconColumn, [{
      key: "getValueFor",
      value: function getValueFor(row) {
        var discovery = row.getSubject();
        return isHistoryNode(discovery) ? HISTORY_ICON : HISTORY_DEVICE_ICON;
      }
    }]);
  }(IconColumn);
  var DisplayNameColumn = /*#__PURE__*/function (_Column) {
    function DisplayNameColumn() {
      _classCallCheck(this, DisplayNameColumn);
      return _callSuper(this, DisplayNameColumn, arguments);
    }
    _inherits(DisplayNameColumn, _Column);
    return _createClass(DisplayNameColumn, [{
      key: "getValueFor",
      value: function getValueFor(row) {
        var discovery = row.getSubject();
        return discovery.deviceName || discovery.historyId.getHistoryDisplayName();
      }
    }]);
  }(Column);
  var SystemTagsColumn = /*#__PURE__*/function (_Column2) {
    function SystemTagsColumn() {
      _classCallCheck(this, SystemTagsColumn);
      return _callSuper(this, SystemTagsColumn, arguments);
    }
    _inherits(SystemTagsColumn, _Column2);
    return _createClass(SystemTagsColumn, [{
      key: "getValueFor",
      value: function getValueFor(row) {
        return row.getSubject().systemTags || '';
      }
    }]);
  }(Column);
  var DiscoveredHistoryTreeNode = /*#__PURE__*/function (_TreeNode) {
    /**
     * @param {module:nmodule/niagaraDriver/rc/rpc/history~DiscoveredHistoryInfo} discoveredHistory
     */
    function DiscoveredHistoryTreeNode(discoveredHistory) {
      var _this;
      _classCallCheck(this, DiscoveredHistoryTreeNode);
      var historyId = discoveredHistory.historyId;
      _this = _callSuper(this, DiscoveredHistoryTreeNode, [historyId.getHistoryName(), historyId.getHistoryDisplayName()]);
      _this.$history = discoveredHistory;
      return _this;
    }
    _inherits(DiscoveredHistoryTreeNode, _TreeNode);
    return _createClass(DiscoveredHistoryTreeNode, [{
      key: "value",
      value: function value() {
        return this.$history;
      }

      /**
       * @override
       * @returns {boolean} false - histories have no children
       */
    }, {
      key: "mayHaveKids",
      value: function mayHaveKids() {
        return false;
      }
    }]);
  }(TreeNode);
  var DiscoveredHistoryDeviceTreeNode = /*#__PURE__*/function (_TreeNode2) {
    /**
     * @param {module:nmodule/niagaraDriver/rc/rpc/history~DiscoveredHistoryDeviceInfo} discoveredDevice
     */
    function DiscoveredHistoryDeviceTreeNode(discoveredDevice) {
      var _this2;
      _classCallCheck(this, DiscoveredHistoryDeviceTreeNode);
      var deviceName = discoveredDevice.deviceName,
        histories = discoveredDevice.histories;
      var kids = histories.map(function (history) {
        return new DiscoveredHistoryTreeNode(history);
      });
      _this2 = _callSuper(this, DiscoveredHistoryDeviceTreeNode, [deviceName, deviceName, kids]);
      _this2.$discoveredDevice = discoveredDevice;
      return _this2;
    }
    _inherits(DiscoveredHistoryDeviceTreeNode, _TreeNode2);
    return _createClass(DiscoveredHistoryDeviceTreeNode, [{
      key: "value",
      value: function value() {
        return this.$discoveredDevice;
      }

      /**
       * @returns {boolean} true - devices contain child histories
       */
    }, {
      key: "isGroup",
      value: function isGroup() {
        return true;
      }
    }]);
  }(TreeNode); // endregion support classes
  // region support functions
  function isHistoryNode(discovery) {
    return !!discovery.historyId;
  }
  function isHistoryImport(component) {
    return baja.hasType(component, 'driver:HistoryImport');
  }
  function isNiagaraSystemHistory(component) {
    return baja.hasType(component, 'niagaraDriver:NiagaraSystemHistoryImport');
  }
  function deriveDefaultNameFromHistoryId(historyId) {
    var name = historyId.encodeToString();
    if (name.startsWith('^')) {
      name = REMOTE_PREFIX + '_' + name.substring(1);
    } else {
      name = name.substring(1);
    }
    return name.replace('/', '_');
  }

  // endregion support functions

  return NiagaraHistoryImportLearn;
});
