function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/niagaraDriver/rc/wb/mgr/NiagaraHistoryExportUxManager
 */

define(['baja!', 'Promise', 'baja!driver:ArchiveFolder,niagaraDriver:NiagaraHistoryExport,niagaraDriver:NiagaraHistoryDeviceExt', 'lex!niagaraDriver', 'nmodule/driver/rc/wb/mgr/history/HistoryExportManager', 'nmodule/history/rc/historyUtil', 'nmodule/niagaraDriver/rc/wb/mgr/model/NiagaraHistoryExportModel', 'nmodule/niagaraDriver/rc/wb/mgr/model/NiagaraHistoryExportLearnModel', 'nmodule/niagaraDriver/rc/wb/mgr/NiagaraHistoryExportLearn', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/wb/mgr/MgrLearn', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/util/subscriptionUtil'], function (baja, Promise, types, lexs, HistoryExportManager, historyUtil, NiagaraHistoryExportModel, NiagaraHistoryExportLearnModel, NiagaraHistoryExportLearn, compUtils, MgrLearn, MgrTypeInfo, subscriptionUtil) {
  'use strict';

  var SYSTEM_HISTORY_EXPORT_TYPESPEC = 'niagaraDriver:NiagaraSystemHistoryExport';
  var HISTORY_EXPORT_TYPESPEC = 'niagaraDriver:NiagaraHistoryExport';
  var _types = _slicedToArray(types, 3),
    ARCHIVE_FOLDER_TYPE = _types[0],
    NIAGARA_HISTORY_EXPORT = _types[1],
    NIAGARA_HISTORY_DEVICE_EXT = _types[2];
  var basicSubscriptionFilter = subscriptionUtil.basicSubscriptionFilter;
  var _lexs = _slicedToArray(lexs, 1),
    niagaraDriverLex = _lexs[0];
  var LEX_LOCAL = niagaraDriverLex.get("historyExportManager.local");
  function subscribeExport(comp, sub) {
    return sub.subscribe(comp.get('executionTime'));
  }
  /**
   * Base class for history export managers (Niagara, Bacnet, etc.)
   * @class
   * @alias module:nmodule/niagaraDriver/rc/wb/mgr/NiagaraHistoryExportUxManager
   * @extends module:nmodule/driver/rc/wb/mgr/history/HistoryExportManager
   * @since Niagara 4.14
   */
  return /*#__PURE__*/function (_HistoryExportManager) {
    function NiagaraHistoryExportUxManager(params) {
      var _this;
      _classCallCheck(this, NiagaraHistoryExportUxManager);
      _this = _callSuper(this, NiagaraHistoryExportUxManager, [Object.assign({
        moduleName: 'niagaraDriver',
        keyName: 'NiagaraHistoryExportUxManager',
        editableTypes: [baja.lt('niagaraDriver:NiagaraHistoryExport')],
        folderType: ARCHIVE_FOLDER_TYPE,
        getComponentStatus: function getComponentStatus(c) {
          return baja.Status.getStatusFromIStatus(c);
        },
        subscribeCallback: function subscribeCallback(_ref) {
          var comp = _ref.comp,
            sub = _ref.sub;
          var isExport = comp.getType().is(NIAGARA_HISTORY_EXPORT);
          if (!isExport) {
            return;
          }
          return subscribeExport(comp, sub);
        },
        subscriptionFilter: function subscriptionFilter(filterParams) {
          return basicSubscriptionFilter(Object.assign({
            containerTypes: [ARCHIVE_FOLDER_TYPE, NIAGARA_HISTORY_DEVICE_EXT],
            componentTypes: [NIAGARA_HISTORY_EXPORT]
          }, filterParams));
        }
      }, params)]);
      MgrLearn(_this);
      return _this;
    }

    /**
     * @param {baja.Component} historyContainer
     * @returns {Promise.<module:nmodule/niagaraDriver/rc/wb/mgr/model/NiagaraHistoryExportModel>}
     */
    _inherits(NiagaraHistoryExportUxManager, _HistoryExportManager);
    return _createClass(NiagaraHistoryExportUxManager, [{
      key: "makeModel",
      value: function makeModel(historyContainer) {
        return NiagaraHistoryExportModel.make(historyContainer, {
          folderType: ARCHIVE_FOLDER_TYPE
        });
      }
    }, {
      key: "makeLearnModel",
      value: function makeLearnModel() {
        return NiagaraHistoryExportLearnModel.make();
      }

      /**
       * Starts a discovery job.
       *
       * @returns {Promise}
       */
    }, {
      key: "doDiscover",
      value: function doDiscover() {
        var exportLearn = new NiagaraHistoryExportLearn();
        var params = {
          learnModel: this.getLearnModel(),
          targetOrd: this.value().getNavOrd().encodeToString()
        };
        return exportLearn.rpcDiscovery(params);
      }

      /**
       * Returns the types for discovery
       * @param {baja.Value} subject the subject that we are matching
       * @returns {Promise.<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>|Promise}
       */
    }, {
      key: "getTypesForDiscoverySubject",
      value: function getTypesForDiscoverySubject(subject) {
        if (!subject || subject.type !== 'history:History') {
          return Promise.resolve([]);
        }
        return Promise.resolve(MgrTypeInfo.make("niagaraDriver:NiagaraHistoryExport"));
      }

      /**
       * Returns an object with the proposed subject for the manager AddCommand & MatchCommand
       * @param {baja.Component} discovery
       * @param {module:baja/comp/ControlPoint} point when a match is done, it is the database point that we are matching to
       * @returns {Promise.<Object>}
       */
    }, {
      key: "getProposedValuesFromDiscovery",
      value: function getProposedValuesFromDiscovery(discovery, point) {
        var pointName = point && point.getName();
        var discHistoryId = discovery.historyId;
        return compUtils.getStationName().then(function (stationName) {
          var historyId = discHistoryId.toShorthand(stationName);
          var newName = historyId.encodeToString();
          newName = newName.startsWith("^") ? LEX_LOCAL + "_" + newName.substring(1) : newName.substring(1).replace("/", "_");
          return {
            name: pointName || newName,
            values: {
              historyId: historyId,
              systemTagPatterns: point && point.getSystemTagPatterns ? point.getSystemTagPatterns() : undefined
            }
          };
        });
      }

      /**
       * Returns true if the slot paths match
       *
       * @param {baja.Component} subject
       * @param {baja.Value} point
       * @returns {boolean}
       */
    }, {
      key: "isExisting",
      value: function isExisting(subject, point) {
        var pointType = point ? point.getType().getTypeSpec() : '';
        if (!subject || subject.type !== "history:History") {
          return false;
        }
        if (pointType === SYSTEM_HISTORY_EXPORT_TYPESPEC && subject.systemTagPatterns) {
          var tagPatterns = point.getSystemTagPatterns && point.getSystemTagPatterns();
          if (!tagPatterns) {
            return false;
          }
          var nameList = baja.NameList.DEFAULT.decodeFromString(subject.systemTagPatterns).getNames();
          return historyUtil.acceptSystemTags(nameList, tagPatterns);
        } else if (pointType === HISTORY_EXPORT_TYPESPEC) {
          var historyId = subject.historyId;
          var pointHistory = point.getHistoryId();
          var pointDevice = pointHistory.getDeviceName();
          var pointHistoryName = pointHistory.getHistoryName();
          return historyId.getHistoryName() === pointHistoryName && (historyId.getDeviceName() === pointDevice || pointDevice === "^");
        } else {
          return false;
        }
      }

      /**
       * @since Niagara 4.14
       * @param {*} learnSelection the subject selected in the learn table
       * @param {baja.Component} mainSelection the subject from the main table that the learnSelection
       * subject is being matched to
       * @returns {boolean}
       */
    }, {
      key: "isMatchable",
      value: function isMatchable(learnSelection, mainSelection) {
        return !mainSelection.getType().is('driver:ArchiveFolder') && learnSelection.type !== "history:HistoryDevice";
      }
    }]);
  }(HistoryExportManager);
});
