/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

define(['baja!', 'baja!history:HistoryId', 'Promise'], function (baja, types, Promise) {
  'use strict';

  /**
   * API Status: **Private**
   * @exports module:nmodule/niagaraDriver/rc/rpc/history
   */
  var exports = {};

  /**
   * @param {baja.Component} ext a `niagaraDriver:NiagaraHistoryDeviceExt` to discover histories from
   * @returns {Promise.<Array.<module:nmodule/niagaraDriver/rc/rpc/history~DiscoveredHistoryDeviceInfo>>} to
   * be resolved with an array of discovered history devices and their corresponding histories
   */
  exports.discoverHistories = function (ext) {
    if (!baja.hasType(ext, 'niagaraDriver:NiagaraHistoryDeviceExt')) {
      return Promise.reject(new Error('NiagaraHistoryDeviceExt required'));
    }
    return ext.rpc('discoverHistories').then(function (_ref) {
      var h = _ref.h;
      return h.map(function (_ref2) {
        var n = _ref2.n,
          h = _ref2.h;
        return {
          deviceName: n,
          histories: h.map(function (_ref3) {
            var i = _ref3.i,
              t = _ref3.t;
            return {
              historyId: baja.$('history:HistoryId', i),
              systemTags: baja.$('baja:NameList', t)
            };
          })
        };
      });
    });
  };
  return exports;

  /**
   * @typedef module:nmodule/niagaraDriver/rc/rpc/history~DiscoveredHistoryDeviceInfo
   * @property {string} deviceName
   * @property {Array.<module:nmodule/niagaraDriver/rc/rpc/history~DiscoveredHistoryInfo>} histories
   */

  /**
   * @typedef module:nmodule/niagaraDriver/rc/rpc/history~DiscoveredHistoryInfo
   * @property {module:nmodule/history/rc/baja/HistoryId} historyId
   * @property {string} systemTags
   */
});
