/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @module virt
 * @private
 */
define(["bajaScript/sys", "bajaScript/baja/virt/VirtualComponent", "bajaScript/baja/virt/VirtualComponentSpace", "bajaScript/baja/virt/VirtualGateway"], function defineVirt(baja, VirtualComponent, VirtualComponentSpace, VirtualGateway) {
  "use strict";

  var registerType = baja.registerType;
  function registerAll(obj) {
    baja.iterate(obj, function (ctor, typeSpec) {
      registerType(typeSpec, function () {
        return ctor;
      });
    });
  }
  registerAll({
    "baja:VirtualComponent": baja.VirtualComponent = VirtualComponent,
    "baja:VirtualComponentSpace": baja.VirtualComponentSpace = VirtualComponentSpace,
    "baja:VirtualGateway": baja.VirtualGateway = VirtualGateway
  });
  return baja;
});
