/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

define(["bajaScript/obj", "bajaScript/baja/nav/event", "bajaScript/baja/nav/NavContainer", "bajaScript/baja/nav/NavNodeContainer", "bajaScript/baja/nav/NavNode", "bajaScript/baja/nav/FileNavContainer", "bajaScript/baja/nav/NavFileSpace", "bajaScript/baja/nav/NavRoot"], function defineNav(baja, event, NavContainer, NavNodeContainer, NavNode, FileNavContainer, NavFileSpace, NavRoot) {
  "use strict";

  var registerType = baja.registerType;

  /**
   * Event Handling framework.
   * @namespace baja.event
   */
  baja.event = event;
  baja.NavContainer = NavContainer;
  baja.FileNavContainer = FileNavContainer;
  registerType("baja:NavContainer", function () {
    return NavContainer;
  });
  registerType("baja:NavFileSpace", function () {
    return NavFileSpace;
  });
  registerType("baja:NavRoot", function () {
    return NavRoot;
  });

  /**
   * Nav Root
   * @namespace baja.nav
   */
  baja.nav = new NavRoot({
    navName: "root",
    ord: "root:",
    // TODO: Implement root scheme
    icon: "module://icons/x16/planet.png"
  });

  /**
   * NavFileSpace.
   * @memberOf baja.nav
   * @type {module:baja/nav/NavFileSpace}
   */
  baja.nav.navfile = baja.nav.$addChildNode(new NavFileSpace());

  // Mix-in the event handlers for the Nav Root
  event.mixin(baja.nav);

  // These comments are left in for the benefit of JsDoc Toolkit...

  /**
   * Attach an event handler to listen for navigation events.
   * 
   * Please note, navigation events only cover 'add', 'remove', 'renamed' and 'reordered'.
   * 
   * For a list of all the event handlers and some of this method's more advanced 
   * features, please see {@link baja.Subscriber#attach}.
   *
   * @function baja.nav.attach
   *
   * @see baja.Subscriber
   * @see baja.nav.detach
   * @see baja.nav.getHandlers
   * @see baja.nav.hasHandlers
   *
   * @param {String} event handler name.
   * @param {Function} the event handler function.
   */

  /**
   * Detach an Event Handler.
   * 
   * If no arguments are used with this method then all events are removed.
   * 
   * For some of this method's more advanced features, please see {@link baja.Subscriber#detach}.
   *
   * @function baja.nav.detach
   *
   * @see baja.Subscriber
   * @see baja.nav.attach
   * @see baja.nav.getHandlers
   * @see baja.nav.hasHandlers
   *
   * @param {String} [hName] the name of the handler to detach.
   * @param {Function} [func] the function to remove. It's recommended to supply this just in case
   *                          other scripts have added event handlers.
   */

  /**
   * Return an array of event handlers.
   * 
   * To access multiple handlers, insert a space between the handler names.
   *
   * @function baja.nav.getHandlers
   *
   * @see baja.Subscriber
   * @see baja.nav.detach
   * @see baja.nav.attach
   * @see baja.nav.hasHandlers
   *
   * @param {String} hName the name of the handler
   * @returns {Array}
   */

  /**
   * Return true if there any handlers registered for the given handler name.
   * 
   * If no handler name is specified then test to see if there are any handlers registered at all.
   * 
   * Multiple handlers can be tested for by using a space character between the names.
   *
   * @function baja.nav.hasHandlers
   *
   * @see baja.Subscriber
   * @see baja.Component#detach
   * @see baja.Component#attach
   * @see baja.Component#getHandlers
   *
   * @param {String} [hName] the name of the handler. If undefined, then see if there are any 
   *                         handlers registered at all.
   * @returns {Boolean}
   */

  return baja;
});
