function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @module baja/tag/entityDecoder
 */
define(["bajaScript/sys", "bajaScript/baja/tag/Id", "bajaScript/baja/tag/Tag", "bajaScript/baja/tag/TagSet", "bajaScript/baja/tag/RelationSet", "bajaScript/baja/tag/Relation", "bajaScript/baja/tag/BasicEntity", "bajaPromises"], function (baja, Id, Tag, TagSet, RelationSet, Relation, BasicEntity, Promise) {
  "use strict";

  function decodeTag(val, name) {
    var type = name[name.length - 1],
      Float = baja.Float,
      Double = baja.Double;
    name = name.substring(0, name.length - 1);
    switch (type) {
      case "M":
        return new Tag(name);
      case "B":
        return new Tag(name, baja.$("baja:Boolean", val));
      case "D":
        return new Tag(name, baja.$("baja:Double", val));
      case "I":
        return new Tag(name, baja.$("baja:Integer", val));
      case "F":
        return new Tag(name, baja.$("baja:Float", val));
      case "L":
        return new Tag(name, baja.$("baja:Long", val));
      case "S":
      case "J":
        return new Tag(name, baja.$("baja:String").decodeFromString(val));
      case "A":
        return new Tag(name, baja.$("baja:AbsTime").decodeFromString(val));
      case "O":
        return new Tag(name, baja.$("baja:Ord").decodeFromString(val));
      case "Y":
        return baja.$("baja:DynamicEnum").decodeAsync(val).then(function (tagValue) {
          return new Tag(name, tagValue);
        });
      case "G":
        return baja.$("baja:EnumRange").decodeAsync(val).then(function (tagValue) {
          return new Tag(name, tagValue);
        });
      case "R":
        return new Tag(name, baja.$("baja:RelTime").decodeFromString(val));
      case "U":
        return new Tag(name, baja.$("baja:Unit").decodeFromString(val));
      case "Z":
        return new Tag(name, baja.$("baja:TimeZone").decodeFromString(val));
      case "N":
        switch (val) {
          case "fNaN":
            return new Tag(name, Float.NaN);
          case "fpInf":
            return new Tag(name, Float.POSITIVE_INFINITY);
          case "fnInf":
            return new Tag(name, Float.NEGATIVE_INFINITY);
          case "dNaN":
            return new Tag(name, Double.make(Number.NaN));
          case "dpInf":
            return new Tag(name, Double.POSITIVE_INFINITY);
          case "dnInf":
            return new Tag(name, Double.NEGATIVE_INFINITY);
        }
        break;
      default:
        throw new Error("Unknown value type: " + type);
    }
  }

  /*
   * @param {Array.<String>} tags an array of string encoded tags
   * @returns {Promise.<baja.TagSet>}
   */
  function decodeTags(tags) {
    var promises = [];
    baja.iterate(tags, function (val, name) {
      promises.push(Promise.resolve(decodeTag(val, name)));
    });
    return Promise.all(promises).then(function (tagsArray) {
      return new TagSet(tagsArray);
    });
  }

  /*
   * @param {Array.<Object>} relations an array of json encoded relations
   * @returns {Promise.<baja.RelationSet>}
   */
  function decodeRelations(relations) {
    var relationPromises = [];
    baja.iterate(relations, function (relationJson) {
      var tagPromises = [];
      if (relationJson.rtags) {
        baja.iterate(relationJson.rtags, function (val, name) {
          tagPromises.push(Promise.resolve(decodeTag(val, name)));
        });
      }
      relationPromises.push(Promise.all(tagPromises).then(function (rtags) {
        return new Relation(relationJson.rId, relationJson.entityOrd, new TagSet(rtags));
      }));
    });
    return Promise.all(relationPromises).then(function (relationsArray) {
      return new RelationSet(relationsArray);
    });
  }

  /*
   * @param {Object} entityJson a json encoded entity
   * @returns {Promise.<baja.tag.BasicEntity>}
   */
  function decodeEntity(entityJson) {
    return Promise.all([entityJson.tags ? decodeTags(entityJson.tags) : new TagSet(), entityJson.relations ? decodeRelations(entityJson.relations) : new RelationSet()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        tagSet = _ref2[0],
        relationSet = _ref2[1];
      return new BasicEntity(entityJson.ord, tagSet, relationSet);
    });
  }
  return {
    decodeEntity: decodeEntity,
    decodeTags: decodeTags,
    decodeRelations: decodeRelations
  };
});
