/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * Defines {@link baja.Cursor}.
 * @module baja/sys/structures/Cursor
 */
define([], function () {
  "use strict";

  var notImplementedStr = "Not implemented";

  /**
   * A generic cursor used for iteration.
   * 
   * @class
   * @alias baja.Cursor
   */
  var Cursor = function Cursor() {};

  /**
   * Return the current item.
   * 
   * @abstract
   * @returns the cursor value (null if none available).
   */
  Cursor.prototype.get = function () {
    throw new Error(notImplementedStr);
  };

  /**
   * Iterate through the Cursor and call a function on every item.
   *
   * @abstract
   * @param {Function} func function called on every iteration with the 
   * 'value' being used as an argument.
   */
  Cursor.prototype.each = function (func) {
    throw new Error(notImplementedStr);
  };
  return Cursor;
});
