/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * Defines {@link baja.VirtualScheme}.
 * @module baja/ord/VirtualScheme
 */
define(["bajaScript/sys", "bajaScript/baja/ord/SlotScheme", "bajaScript/baja/ord/VirtualPath"], function (baja, SlotScheme, VirtualPath) {
  "use strict";

  var subclass = baja.subclass,
    callSuper = baja.callSuper;

  /**
   * Virtual Slot Scheme for Virtual Components.
   *
   * @class
   * @alias baja.VirtualScheme
   * @extends baja.SlotScheme
   */
  var VirtualScheme = function VirtualScheme() {
    callSuper(VirtualScheme, this, arguments);
  };
  subclass(VirtualScheme, SlotScheme);

  /**
   * Default Virtual ORD Scheme instance.
   *
   * @private
   * @type {baja.VirtualScheme}
   */
  VirtualScheme.DEFAULT = new VirtualScheme();

  /**
   * Return an ORD Query for the scheme.
   *
   * @param {String} schemeName
   * @param {String} body
   * @returns {module:baja/ord/VirtualPath}
   */
  VirtualScheme.prototype.parse = function (schemeName, body) {
    return new VirtualPath(body);
  };
  return VirtualScheme;
});
