/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * Defines {@link baja.SingleScheme}.
 * @private
 * @module baja/ord/SingleScheme
 */
define(['bajaScript/sys', 'bajaScript/baja/ord/OrdScheme', 'bajaScript/baja/ord/ordUtil'], function (baja, OrdScheme, ordUtil) {
  'use strict';

  var subclass = baja.subclass;
  var callSuper = baja.callSuper;

  /**
   * @class
   * @alias baja.SingleScheme
   * @extends baja.UnknownScheme
   * @private
   */
  var SingleScheme = function SingleScheme() {
    callSuper(SingleScheme, this, arguments);
  };
  subclass(SingleScheme, OrdScheme);
  SingleScheme.DEFAULT = new SingleScheme();

  /**
   * @returns {boolean}
   */
  SingleScheme.prototype.isClientResolvable = function () {
    return false;
  };

  /**
   * @param {baja.Ord} ord
   * @param {module:baja/ord/OrdTarget} ordTarget
   * @param {object} cx
   * @returns {baja.Ord}
   */
  SingleScheme.prototype.convertToSubstituteOrd = function (ord, ordTarget, cx) {
    return ordUtil.convertToSubstituteComponentOrd(ord, ordTarget, cx);
  };
  return SingleScheme;
});
