/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/*eslint-env browser */

define([], function () {
  'use strict';

  /**
   * @API Status: **Private**
   *
   * @since Niagara 4.14
   * @exports nmodule/bajaScript/baja/obj/byteUtil
   */
  var byteUtil = {};

  /**
   * Convert a base64 string to a byte array.
   *
   * @param {string} base64String base64-encoded data
   * @returns {Uint8Array} bytes of the input data
   */
  byteUtil.base64StringToByteArray = function (base64String) {
    if (!base64String) {
      return new Uint8Array();
    }
    var binaryString = atob(base64String);
    var len = binaryString.length;
    var uint8Array = new Uint8Array(len);
    for (var i = 0; i < len; i++) {
      uint8Array[i] = binaryString.charCodeAt(i);
    }
    return uint8Array;
  };

  /**
   * Convert a byte array to a base64-encoded string
   *
   * @param {Uint8Array} byteArray data bytes
   * @returns {string} encoded input data
   */
  byteUtil.byteArrayToBase64String = function (byteArray) {
    if (!byteArray) {
      return '';
    }
    var binary = '';
    var len = byteArray.byteLength;
    for (var i = 0; i < len; i++) {
      binary += String.fromCharCode(byteArray[i]);
    }
    return btoa(binary);
  };
  return byteUtil;
});
