function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/**
 * Defines {@link baja.FacetsMap}.
 * @module baja/obj/FacetsMap
 */
define(['bajaScript/sys', 'bajaScript/baja/obj/Simple', 'bajaPromises'], function (baja, Simple, Promise) {
  'use strict';

  /**
   * Represents a `baja:FacetsMap` in BajaScript. `FacetsMap` is simply a
   * mapping of String names to `Facets` instances. It is mostly intended for
   * internal use by the framework.
   *
   * When creating a `Simple`, always use the `make()` method instead of
   * creating a new Object.
   *
   * @class
   * @alias baja.FacetsMap
   * @extends baja.Simple
   */
  var FacetsMap = /*#__PURE__*/function (_Simple) {
    function FacetsMap() {
      var _this;
      var obj = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      _classCallCheck(this, FacetsMap);
      _this = _callSuper(this, FacetsMap);
      if (_typeof(obj) !== 'object') {
        throw new Error('object required');
      }
      Object.values(obj).forEach(function (facets) {
        if (!baja.hasType(facets, 'baja:Facets')) {
          throw new Error('Facets required');
        }
      });
      _this.$obj = obj;
      return _this;
    }

    /**
     * @param {object} obj a mapping of string keys to `baja.Facets` instances
     * @returns {baja.FacetsMap}
     */
    _inherits(FacetsMap, _Simple);
    return _createClass(FacetsMap, [{
      key: "make",
      value:
      /**
       * @param {object} obj a mapping of string keys to `baja.Facets` instances
       * @returns {baja.FacetsMap}
       */
      function make(obj) {
        return FacetsMap.make.apply(FacetsMap, arguments);
      }

      /**
       * @returns {string[]} all string keys in this `FacetsMap` instance
       */
    }, {
      key: "list",
      value: function list() {
        return Object.keys(this.$obj);
      }

      /**
       * @param {string} key
       * @returns {baja.Facets} the `Facets` at that key, or `baja.Facets.NULL` if
       * not found
       */
    }, {
      key: "get",
      value: function get(key) {
        return this.$obj[key] || baja.Facets.NULL;
      }

      /**
       * @param {string} str
       * @param {Object} [params] 
       * @param {Boolean} [params.unsafe=false] if set to true, this will allow
       * decodeFromString to continue. If not, decodeFromString will throw an error. This flag is for
       * internal bajaScript use only. All external implementations should use decodeAsync instead.
       * @returns {baja.FacetsMap}
       */
    }, {
      key: "decodeFromString",
      value: function decodeFromString(str) {
        var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          _ref$unsafe = _ref.unsafe,
          unsafe = _ref$unsafe === void 0 ? false : _ref$unsafe;
        if (!unsafe) {
          throw new Error('FacetsMap#decodeAsync should be called instead to ensure all types are loaded for the decode');
        }
        var obj = parseEncoding(str);
        Object.keys(obj).forEach(function (key) {
          obj[key] = baja.Facets.DEFAULT.decodeFromString(obj[key], baja.Simple.$unsafeDecode);
        });
        return FacetsMap.make(obj);
      }

      /**
       * @param {string} str
       * @param {baja.comm.Batch} [batch]
       * @returns {Promise<baja.FacetsMap>}
       */
    }, {
      key: "decodeAsync",
      value: function decodeAsync(str, batch) {
        var obj = parseEncoding(str);
        return Promise.all(Object.keys(obj).map(function (key) {
          return Promise.resolve(baja.Facets.DEFAULT.decodeAsync(obj[key], batch)).then(function (facets) {
            obj[key] = facets;
          });
        })).then(function () {
          return FacetsMap.make(obj);
        });
      }

      /**
       * @returns {string}
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        var _this2 = this;
        return '{' + this.list().map(function (key) {
          return "".concat(escape(key), "=").concat(escape(_this2.get(key).encodeToString()), ";");
        }).join('') + '}';
      }

      /**
       * @returns {boolean} true if empty
       */
    }, {
      key: "isNull",
      value: function isNull() {
        return !this.list().length;
      }

      /**
       * @returns {baja.FacetsMap} the DEFAULT instance
       */
    }], [{
      key: "make",
      value: function make(obj) {
        var facetsMap = new FacetsMap(obj);
        return facetsMap.list().length ? facetsMap : DEFAULT;
      }
    }, {
      key: "DEFAULT",
      get: function get() {
        return DEFAULT;
      }

      /**
       * @returns {baja.FacetsMap} the NULL instance
       */
    }, {
      key: "NULL",
      get: function get() {
        return DEFAULT;
      }
    }]);
  }(Simple);
  var DEFAULT = new FacetsMap({});
  function escape(str) {
    return str.replace(/[{}=;]/g, function (s) {
      return '\\' + s;
    });
  }
  function unescape(str) {
    return str.replace(/\\(.)/g, function (m, c) {
      return c;
    });
  }

  /**
   * @param {string} str string encoding from `BFacetsMap#encodeToString`
   * @returns {object} mapping of string names to their corresponding
   * `baja.Facets` string encodings
   */
  function parseEncoding(str) {
    var obj = {};
    var _str$match = str.match(/^{(.*)}$/),
      _str$match2 = _slicedToArray(_str$match, 2),
      body = _str$match2[1];
    var escapedFacetsEncodings = splitOnUnescapedSeparator(body, ';');
    var pairs = escapedFacetsEncodings.map(function (str) {
      return splitOnUnescapedSeparator(str, '=');
    });
    pairs.forEach(function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 2),
        key = _ref3[0],
        value = _ref3[1];
      obj[unescape(key)] = unescape(value);
    });
    return obj;
  }

  // must be something that can never be in the actual string, or at least is vanishingly unlikely
  // to be in production data. watch out for tech support complaints from Penguins Inc.
  var SEPARATOR_REPLACEMENT = "\uD83D\uDC27\uE000\uD83D\uDC27\uE000\uD83D\uDC27";
  var replaceSeparator = function replaceSeparator(match, charBeforeSeparator) {
    return charBeforeSeparator + SEPARATOR_REPLACEMENT;
  };
  function splitOnUnescapedSeparator(str, separator) {
    // first match is the "real" character before the unescaped separator which we will put back in
    var unescapedSeparatorRegex = new RegExp("([^\\\\])".concat(separator), 'g');
    var withRealSeparatorsReplaced = str.replace(unescapedSeparatorRegex, replaceSeparator);
    var actualEncodings = withRealSeparatorsReplaced.split(SEPARATOR_REPLACEMENT);
    return actualEncodings.filter(function (s) {
      return s;
    }); // if last char is a separator, last string will be empty
  }
  return FacetsMap;
});
