/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * Defines {@link baja.Topic}.
 * @module baja/comp/Topic
 */
define(["bajaScript/sys", "bajaScript/baja/comp/Slot"], function (baja, Slot) {
  "use strict";

  var subclass = baja.subclass,
    callSuper = baja.callSuper;

  /**
   * Topic Slot.
   * 
   * `Topic` defines a `Slot` which indicates an event that
   * is fired on a `Component`.
   * 
   * A new object should never be directly created with this Constructor. All Slots are 
   * created internally by BajaScript.
   *
   * @class
   * @alias baja.Topic
   * @extends baja.Slot
   */
  var Topic = function Topic(slotName, displayName) {
    callSuper(Topic, this, [slotName, displayName]);
  };
  subclass(Topic, Slot);

  /** 
   * Is the Slot a Topic? Yes.
   *
   * @returns {Boolean}
   */
  Topic.prototype.isTopic = function () {
    return true;
  };
  return Topic;
});
