/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * Defines a `PropertyTopic` (not exposed on `baja` namespace).
 * @module baja/comp/PropertyTopic
 */
define(["bajaScript/sys", "bajaScript/baja/comp/DynamicProperty"], function (baja, DynamicProperty) {
  "use strict";

  var subclass = baja.subclass,
    callSuper = baja.callSuper;

  /**
   * PropertyTopic Slot.
   * 
   * A `Property` that is also a `Topic`. Typically this is used for dynamic `Topic`s.
   * 
   * A new object should never be directly created with this Constructor. All Slots are 
   * created internally by BajaScript.
   *
   * @class
   * @alias module:baja/comp/PropertyTopic
   * @extends module:baja/comp/DynamicProperty
   */
  var PropertyTopic = function PropertyTopic(slotName, displayName, display, flags, facets, value) {
    callSuper(PropertyTopic, this, arguments);
  };
  subclass(PropertyTopic, DynamicProperty);

  /**
   * Is the Property a Topic? Yes.
   *
   * @returns {Boolean}
   */
  PropertyTopic.prototype.isTopic = function () {
    return true;
  };

  /**
   * Return the Topic's event Type.
   *
   * @returns {Type} the event Type (or null if the Topic has not event Type).
   */
  PropertyTopic.prototype.getEventType = function () {
    return this.$val.getEventType();
  };
  return PropertyTopic;
});
