/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @module baja/boxcs/RenameOp
 * @private
 */
define(["bajaScript/sys", "bajaScript/baja/boxcs/SyncOp"], function (baja, SyncOp) {
  "use strict";

  var subclass = baja.subclass,
    callSuper = baja.callSuper;

  /**
   * @class Rename a dynamic Slot SyncOp.
   *
   * @name RenameOp
   * @extends SyncOp
   * @inner
   * @private
   *
   * @param comp the Component the Topic is being fired from.
   * @param {String} oldName the old name of the Slot.
   * @param {String} newName the new name of the Slot.
   */
  function RenameOp(comp, oldName, newName) {
    callSuper(RenameOp, this, arguments);

    // Encode argument to a data structure
    var a = {
      nm: this.getId(),
      h: comp.getHandle(),
      o: oldName,
      n: newName
    };
    this.$arg = a;
  }
  subclass(RenameOp, SyncOp);
  RenameOp.id = "r";

  /**
   * Decode and commit the SyncOp.
   *
   * @private
   *
   * @param comp the Component the rename will happen upon.
   * @param sp the syncOp data structure to be decoded.
   */
  RenameOp.decodeAndCommit = function (comp, sp) {
    if (comp !== null) {
      var name = sp.n,
        oldName = sp.o,
        displayName = sp.dn,
        display = sp.d,
        slot = comp.getSlot(oldName);
      if (slot !== null) {
        comp.rename({
          "slot": slot,
          "newName": name,
          "cx": {
            commit: true,
            displayName: displayName,
            display: display,
            serverDecode: true
          }
        });
      }
    }
  };
  return RenameOp;
});
