function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Robert Staley
 */

/**
 * API Status: **Private**
 * @module nmodule/saml/rc/fe/BooleanCheckboxEditor
 */
define(['baja!', 'lex!baja', 'log!nmodule.saml.rc.fe.BooleanCheckboxEditor', 'jquery', 'Promise', 'nmodule/webEditors/rc/fe/baja/BaseEditor'], function (baja, lexs, log, $, Promise, BaseEditor) {
  'use strict';

  var bajaLex = lexs[0],
    logError = log.severe.bind(log);
  function doFormat(pattern) {
    return baja.Format.format({
      pattern: pattern
    });
  }

  /**
   * A field editor rendering a checkbox for working with booleans.  This is essentially a copy of the current
   * webEditors BooleanEditor.  In the future the webEditors BooleanEditor will be updated to support rendering
   * a slider, or other, to facilitate editing booleans (NCCB-37311 Finish implementing improved BooleanEditor).
   * This editor is specifically for the SAML circle of trust manager "select all" checkbox.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/saml/rc/fe/BooleanCheckboxEditor
   */
  var BooleanCheckboxEditor = function BooleanCheckboxEditor(params) {
    BaseEditor.call(this, $.extend({
      keyName: 'BooleanCheckboxEditor'
    }, params));
  };
  BooleanCheckboxEditor.prototype = Object.create(BaseEditor.prototype);
  BooleanCheckboxEditor.prototype.constructor = BooleanCheckboxEditor;

  /**
   * Compute the true/false display text to use from the `trueText` /
   * `falseText` facets.
   *
   * @private
   * @returns {Promise} promise to be resolved with an array containing two
   * strings for trueText/falseText
   */
  BooleanCheckboxEditor.prototype.$getTrueFalseText = function () {
    var props = this.properties(),
      trueText = props.getValue('trueText') || bajaLex.get('true'),
      falseText = props.getValue('falseText') || bajaLex.get('false');
    return Promise.all([doFormat(trueText), doFormat(falseText)]);
  };

  /**
   * Return the checkbox element.
   *
   * @private
   * @returns {jQuery}
   */
  BooleanCheckboxEditor.prototype.$getCheckbox = function () {
    return this.jq().children('input');
  };

  /**
   * Update the current value of the display label with the `trueText` or
   * `falseText` facet, falling back to `true` and `false` from the `baja`
   * lexicon if either of those facets is not configured.
   * @private
   * @param {Boolean} value whether the the editor currently has true or false
   * loaded
   * @returns {Promise}
   */
  BooleanCheckboxEditor.prototype.$updateLabel = function (value) {
    var that = this;
    return that.$getTrueFalseText().then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        trueText = _ref2[0],
        falseText = _ref2[1];
      that.jq().children('label').text(value ? trueText : falseText);
    });
  };

  /**
   * Creates a checkbox input.
   * @param {JQuery} dom
   */
  BooleanCheckboxEditor.prototype.doInitialize = function (dom) {
    var that = this,
      id = this.generateId(),
      input = $('<input type="checkbox">').prop('id', id),
      label = $('<label></label>').prop('for', id);
    dom.html(input.add(label));
    dom.on('change', 'input:checkbox', function () {
      that.setModified(true);
      that.read().then(function (value) {
        return that.$updateLabel(value);
      })["catch"](logError);
    });
  };

  /**
   * Checks or unchecks the checkbox to reflect the loaded value.
   * @param {Boolean} val
   */
  BooleanCheckboxEditor.prototype.doLoad = function (val) {
    this.$getCheckbox().prop('checked', !!val);
    return this.$updateLabel(val);
  };

  /**
   * Returns the checked/unchecked state of the checkbox.
   * @returns {Boolean} the boolean checked state of the checkbox
   */
  BooleanCheckboxEditor.prototype.doRead = function () {
    return this.$getCheckbox().prop('checked');
  };

  /**
   * Enables or disables the checkbox element.
   *
   * @param {Boolean} enabled
   */
  BooleanCheckboxEditor.prototype.doEnabled = function (enabled) {
    this.$getCheckbox().prop('disabled', this.isReadonly() || !enabled);
  };

  /**
   * Disables or enables the checkbox element.
   *
   * @param {Boolean} readonly
   */
  BooleanCheckboxEditor.prototype.doReadonly = function (readonly) {
    this.$getCheckbox().prop('disabled', !this.isEnabled() || readonly);
  };
  return BooleanCheckboxEditor;
});
