function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Patrick Sager
 */

/* global sjcl */

/**
 * API Status: **Private**
 * @module nmodule/gauth/rc/GoogleSecretKeyEditor
 */
define(['baja!', 'baja!baja:Password', 'lex!gauth', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'bajaux/mixin/subscriberMixIn', 'Promise', 'dialogs', 'nmodule/gauth/ext/qrcode-generator/qrcode', 'nmodule/webEditors/rc/servlets/password', 'hbs!nmodule/gauth/rc/template/GoogleSecretKeyEditor', 'hbs!nmodule/gauth/rc/template/GoogleSecretKeyEditor-confirm', 'hbs!nmodule/gauth/rc/template/GoogleSecretKeyEditor-qrcode', 'hbs!nmodule/gauth/rc/template/GoogleSecretKeyEditor-verify', 'css!nmodule/gauth/rc/gauth', 'nmodule/gauth/ext/sjcl/sjcl.built.min'], function (baja, types, lexicons, BaseEditor, compUtils, subscriberMixin, Promise, dialogs, Qrcode, password, tplGoogleSecretKeyEditor, tplGoogleSecretKeyEditorConfirm, tplGoogleSecretKeyEditorQrcode, tplGoogleSecretKeyEditorVerify) {
  'use strict';

  var lex = lexicons[0];
  function generateToken(key, t) {
    // eslint-disable-next-line new-cap
    var hmac = new sjcl.misc.hmac(sjcl.codec.base32.toBits(key), sjcl.hash.sha1);
    var hash = hmac.encrypt([t & 0xFFFFFFFF00000000, t << 32]);
    var length = sjcl.bitArray.bitLength(hash);
    var offset = sjcl.bitArray.bitSlice(hash, length - 8)[0] >>> 24 & 0x0F;
    var truncatedHash = sjcl.bitArray.bitSlice(hash, offset * 8, offset * 8 + 32)[0];
    truncatedHash &= 0x7FFFFFFF;
    truncatedHash %= 1000000;
    return truncatedHash;
  }

  /**
   * Editor for generating a Google auth secret key.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/gauth/rc/GoogleSecretKeyEditor
   */
  var GoogleSecretKeyEditor = function GoogleSecretKeyEditor() {
    /** remember to call super constructor. Javascript won't do this for you */
    BaseEditor.apply(this, arguments);
    subscriberMixin(this);
  };

  //extend and set up prototype chain
  GoogleSecretKeyEditor.prototype = Object.create(BaseEditor.prototype);
  GoogleSecretKeyEditor.prototype.constructor = GoogleSecretKeyEditor;

  /**
   * Find the closest ancestor that is a baja:User, lease it if available,
   * and return a promise that resolves with the the user name, or resolve with
   * 'unknown' if no user found.
   *
   * @returns {Promise} to be resolved with the username, or 'unknown'
   */
  GoogleSecretKeyEditor.prototype.$getUserName = function () {
    var complex = this.getComplex();
    var user = complex && compUtils.closest(complex, 'baja:User');
    if (user) {
      return Promise.resolve(user.isMounted() && user.lease()).then(function () {
        return user.getName();
      });
    }
    return Promise.resolve('unknown');
  };

  /**
   * Find the closest ancestor that is a baja:Station, lease it if available,
   * and return a promise that resolves with the station name, or resolve with
   * 'unknown' if no station found.
   *
   * @returns {Promise} to be resolved with the station name, or 'unknown'
   */
  GoogleSecretKeyEditor.prototype.$getStationName = function () {
    // @since Niagara 4.14 calls the new compUtils.getStationName function
    return compUtils.getStationName(this.getComplex());
  };

  /**
   * If the complex is a gauth:GoogleAuthAuthenticator, make an rpc call
   * to isSecretKeyConfigured and resolve with the results, otherwise
   * resolve with false.
   *
   * @private
   * @returns {Promise} to be resolved with the results of the rpc call
   */
  GoogleSecretKeyEditor.prototype.$isSecretKeyConfigured = function () {
    var complex = this.getComplex();
    if (baja.hasType(complex, 'gauth:GoogleAuthAuthenticator') && complex.getNavOrd()) {
      return baja.rpc(complex.getNavOrd(), 'isSecretKeyConfigured');
    }
    return Promise.resolve(false);
  };

  /**
   * Check to make sure this password editor is operating in a secure
   * environment. Note that this is a client-side check only to prevent editor
   * from validating. If the station detects passwords from an insecure source
   * it must reject those passwords.
   *
   * @private
   * @returns {Promise}
   */
  GoogleSecretKeyEditor.prototype.$isSecure = function () {
    return Promise.resolve(baja.bson.$canEncodeSecurely());
  };

  /**
   *  initialize the editor
   *
   * @param {jQuery} dom
   * @returns {Promise}
   */
  GoogleSecretKeyEditor.prototype.doInitialize = function (dom) {
    var that = this;
    return that.$isSecretKeyConfigured().then(function (configured) {
      return configured;
    }, function (ignore) {
      return false;
    }).then(function (configured) {
      dom.html(tplGoogleSecretKeyEditor({
        displayName: configured ? lex.get('auth.regenerateKey') : lex.get('auth.generateKey')
      }));
      dom.on('click', 'button.generate', function () {
        var show = configured || that.$secretKey ? that.$showConfirmDialog : that.$generateQr;
        show.call(that)["catch"](dialogs.showOk);
      });
      return that.$isSecure();
    }).then(function (secure) {
      that.jq().find('button.generate').prop('disabled', !secure);
    });
  };

  /**
   * Show a dialog that explains to the user that regenerating the secret
   * key will invalidate devices configured with the existing key, and
   * allow them to confirm.
   *
   * @private
   * @returns {Promise}
   */
  GoogleSecretKeyEditor.prototype.$showConfirmDialog = function () {
    var that = this;
    return dialogs.showOkCancel({
      content: tplGoogleSecretKeyEditorConfirm({
        message: lex.get('auth.confirmRegenerate')
      })
    }).ok(function (dlg) {
      return dlg.close().promise().then(function () {
        return that.$generateQr();
      });
    }).promise();
  };

  /**
   * Generate a secret key, create a QR code for it, and display it in a dialog
   *
   * @private
   * @returns {Promise}
   */
  GoogleSecretKeyEditor.prototype.$generateQr = function () {
    var that = this;
    sjcl.random.startCollectors();
    var random = sjcl.random.randomWords(3);
    this.$secretKey = sjcl.codec.base32.fromBits(sjcl.bitArray.bitSlice(random, 0, 80));
    return Promise.all([this.$getUserName(), this.$getStationName()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        username = _ref2[0],
        stationName = _ref2[1];
      var qr = Qrcode(4, 'L');
      qr.addData('otpauth://totp/' + username + '@' + stationName + '?secret=' + that.$secretKey);
      qr.make();
      var tag = qr.createImgTag(4);
      return dialogs.showOkCancel({
        content: tplGoogleSecretKeyEditorQrcode({
          instructions: lex.get('auth.qrInstructions'),
          qrCode: tag,
          key: that.$secretKey + ' - ' + username + ' @ ' + stationName
        })
      }).ok(function (dlg) {
        return dlg.close().promise().then(function () {
          return that.$showVerifyDialog(false);
        });
      }).cancel(function (dlg) {
        that.$secretKey = undefined;
      }).promise();
    });
  };

  /**
   * Show a dialog prompting the user to verify correct setup
   * by entering the token provided by their authenticator.
   *
   * @private
   * @param {Boolean} error displays an error message indicating that the
   * user has entered an incorrect token if true.
   */
  GoogleSecretKeyEditor.prototype.$showVerifyDialog = function (error) {
    var that = this;
    return dialogs.showOkCancel({
      content: tplGoogleSecretKeyEditorVerify({
        instructions: lex.get('auth.confirmToken'),
        isError: error,
        error: lex.get('auth.incorrectToken')
      })
    }).ok(function (dlg) {
      return dlg.close().promise().then(function () {
        // If the token that the user supplies matches the token that
        // we generate, that means they have the correct secret key.
        // These tokens are time based and change every 30 seconds, so
        // check against 3 past tokens and 3 future tokens to account
        // for time differences between the user's mobile device and browser.
        var enteredToken = dlg.content().find('input').val();
        var t = Math.floor(Date.now() / 30000);
        var verified = false;
        for (var i = -3; i <= 3 && !verified; i++) {
          var expectedToken = generateToken(that.$secretKey, t + i);
          if (parseInt(enteredToken, 10) === expectedToken) {
            verified = true;
          }
        }
        if (verified) {
          that.setModified(true);
          that.jq().find('button.generate').text(lex.get('auth.regenerateKey'));
        } else {
          return that.$showVerifyDialog(true);
        }
      });
    }).cancel(function (dlg) {
      that.$secretKey = undefined;
    }).promise();
  };

  /**
   * Set the generate key button disabled if readonly, set it enabled if
   * not readonly, unless the connection is not secure.
   *
   * @param {Boolean} readonly
   * @returns {Promise}
   */
  GoogleSecretKeyEditor.prototype.doReadonly = function (readonly) {
    var that = this;
    return that.$isSecure().then(function (secure) {
      if (!readonly && !secure) {
        return;
      }
      that.jq().find('button.generate').prop('disabled', readonly);
    });
  };

  /**
   * Set the generate key button disabled if not enabled, set it enabled if
   * enabled, unless the connection is not secure.
   *
   * @param {Boolean} enabled
   * @returns {Promise}
   */
  GoogleSecretKeyEditor.prototype.doEnabled = function (enabled) {
    return this.doReadonly(!enabled);
  };

  /**
   * Returns a baja:Password with the value of the secret key that was generated,
   * or the default password if no key was generated or any of the dialogs were canceled.
   *
   * @returns {baja:Password} the secret key that was generated.
   */
  GoogleSecretKeyEditor.prototype.doRead = function () {
    return baja.$('baja:Password', this.$secretKey);
  };

  /**
   * @param {baja.Simple} pwd the `baja:Password` value to load
   */
  GoogleSecretKeyEditor.prototype.doLoad = function (pwd) {
    this.$secretKey = undefined;
  };

  /**
   * Sets the password slot on the complex to the value of the generated key
   * using the password rpc.
   * Starting in Niagara 4.14 the RPC is only called when the Complex being edited
   * is mounted.
   *
   * @returns {Promise|undefined}
   */
  GoogleSecretKeyEditor.prototype.saveToComplex = function (pw, params) {
    var complex = this.getComplex();
    if (this.$secretKey && complex && complex.isMounted()) {
      return password.setPassword(this.$secretKey, this.getSlot(), complex);
    }
  };
  return GoogleSecretKeyEditor;
});
