/**
 * Copyright (c) 2009-2015, Emily Stark, Mike Hamburg and Dan Boneh at Stanford University. All rights reserved.
 */
"use strict";var sjcl={cipher:{},hash:{},keyexchange:{},mode:{},misc:{},codec:{},exception:{corrupt:function(t){this.toString=function(){return"CORRUPT: "+this.message},this.message=t},invalid:function(t){this.toString=function(){return"INVALID: "+this.message},this.message=t},bug:function(t){this.toString=function(){return"BUG: "+this.message},this.message=t},notReady:function(t){this.toString=function(){return"NOT READY: "+this.message},this.message=t}}};sjcl.bitArray={bitSlice:function(t,e,i){return t=sjcl.bitArray._shiftRight(t.slice(e/32),32-(31&e)).slice(1),void 0===i?t:sjcl.bitArray.clamp(t,i-e)},extract:function(t,e,i){var s=Math.floor(-e-i&31);return(-32&(e+i-1^e)?t[e/32|0]<<32-s^t[e/32+1|0]>>>s:t[e/32|0]>>>s)&(1<<i)-1},concat:function(t,e){if(0===t.length||0===e.length)return t.concat(e);var i=t[t.length-1],s=sjcl.bitArray.getPartial(i);return 32===s?t.concat(e):sjcl.bitArray._shiftRight(e,s,0|i,t.slice(0,t.length-1))},bitLength:function(t){var e,i=t.length;return 0===i?0:(e=t[i-1],32*(i-1)+sjcl.bitArray.getPartial(e))},clamp:function(t,e){if(32*t.length<e)return t;var i=(t=t.slice(0,Math.ceil(e/32))).length;return e&=31,0<i&&e&&(t[i-1]=sjcl.bitArray.partial(e,t[i-1]&2147483648>>e-1,1)),t},partial:function(t,e,i){return 32===t?e:(i?0|e:e<<32-t>>>0)+1099511627776*t},getPartial:function(t){return Math.round(t/1099511627776)||32},equal:function(t,e){if(sjcl.bitArray.bitLength(t)!==sjcl.bitArray.bitLength(e))return!1;var i,s=0;for(i=0;i<t.length;i++)s|=t[i]^e[i];return 0===s},_shiftRight:function(t,e,i,s){var o,r,n;for(void 0===s&&(s=[]);32<=e;e-=32)s.push(i),i=0;if(0===e)return s.concat(t);for(o=0;o<t.length;o++)s.push(i|t[o]>>>e),i=t[o]<<32-e;return r=t.length?t[t.length-1]:0,n=sjcl.bitArray.getPartial(r),s.push(sjcl.bitArray.partial(e+n&31,32<e+n?i:s.pop(),1)),s},_xor4:function(t,e){return[t[0]^e[0],t[1]^e[1],t[2]^e[2],t[3]^e[3]]},byteswapM:function(t){var e,i;for(e=0;e<t.length;++e)i=t[e],t[e]=i>>>24|i>>>8&65280|(65280&i)<<8|i<<24;return t}},sjcl.codec.utf8String={fromBits:function(t){var e,i,s="",o=sjcl.bitArray.bitLength(t);for(e=0;e<o/8;e++)0==(3&e)&&(i=t[e/4]),s+=String.fromCharCode(i>>>8>>>8>>>8),i<<=8;return decodeURIComponent(escape(s))},toBits:function(t){t=unescape(encodeURIComponent(t));var e,i=[],s=0;for(e=0;e<t.length;e++)s=s<<8|t.charCodeAt(e),3==(3&e)&&(i.push(s),s=0);return 3&e&&i.push(sjcl.bitArray.partial(8*(3&e),s)),i}},sjcl.codec.base32={_chars:"ABCDEFGHIJKLMNOPQRSTUVWXYZ234567",_hexChars:"0123456789ABCDEFGHIJKLMNOPQRSTUV",BITS:32,BASE:5,REMAINING:27,fromBits:function(t,e,i){sjcl.codec.base32.BITS;var s,o=sjcl.codec.base32.BASE,r=sjcl.codec.base32.REMAINING,n="",h=0,c=sjcl.codec.base32._chars,a=0,l=sjcl.bitArray.bitLength(t);for(i&&(c=sjcl.codec.base32._hexChars),s=0;n.length*o<l;)n+=c.charAt((a^t[s]>>>h)>>>r),h<o?(a=t[s]<<o-h,h+=r,s++):(a<<=o,h-=o);for(;7&n.length&&!e;)n+="=";return n},toBits:function(t,e){t=t.replace(/\s|=/g,"").toUpperCase();var i,s,o=sjcl.codec.base32.BITS,r=sjcl.codec.base32.BASE,n=sjcl.codec.base32.REMAINING,h=[],c=0,a=sjcl.codec.base32._chars,l=0,u="base32";for(e&&(a=sjcl.codec.base32._hexChars,u="base32hex"),i=0;i<t.length;i++){if((s=a.indexOf(t.charAt(i)))<0){if(!e)try{return sjcl.codec.base32hex.toBits(t)}catch(t){}throw new sjcl.exception.invalid("this isn't "+u+"!")}n<c?(c-=n,h.push(l^s>>>c),l=s<<o-c):l^=s<<o-(c+=r)}return 56&c&&h.push(sjcl.bitArray.partial(56&c,l,1)),h}},sjcl.codec.base32hex={fromBits:function(t,e){return sjcl.codec.base32.fromBits(t,e,1)},toBits:function(t){return sjcl.codec.base32.toBits(t,1)}},sjcl.hash.sha1=function(t){t?(this._h=t._h.slice(0),this._buffer=t._buffer.slice(0),this._length=t._length):this.reset()},sjcl.hash.sha1.hash=function(t){return(new sjcl.hash.sha1).update(t).finalize()},sjcl.hash.sha1.prototype={blockSize:512,reset:function(){return this._h=this._init.slice(0),this._buffer=[],this._length=0,this},update:function(t){"string"==typeof t&&(t=sjcl.codec.utf8String.toBits(t));var e,i=this._buffer=sjcl.bitArray.concat(this._buffer,t),s=this._length,o=this._length=s+sjcl.bitArray.bitLength(t);if(9007199254740991<o)throw new sjcl.exception.invalid("Cannot hash more than 2^53 - 1 bits");if("undefined"!=typeof Uint32Array){var r=new Uint32Array(i),n=0;for(e=this.blockSize+s-(this.blockSize+s&this.blockSize-1);e<=o;e+=this.blockSize)this._block(r.subarray(16*n,16*(n+1))),n+=1;i.splice(0,16*n)}else for(e=this.blockSize+s-(this.blockSize+s&this.blockSize-1);e<=o;e+=this.blockSize)this._block(i.splice(0,16));return this},finalize:function(){var t,e=this._buffer,i=this._h;for(t=(e=sjcl.bitArray.concat(e,[sjcl.bitArray.partial(1,1)])).length+2;15&t;t++)e.push(0);for(e.push(Math.floor(this._length/4294967296)),e.push(0|this._length);e.length;)this._block(e.splice(0,16));return this.reset(),i},_init:[1732584193,4023233417,2562383102,271733878,3285377520],_key:[1518500249,1859775393,2400959708,3395469782],_f:function(t,e,i,s){return t<=19?e&i|~e&s:t<=39?e^i^s:t<=59?e&i|e&s|i&s:t<=79?e^i^s:void 0},_S:function(t,e){return e<<t|e>>>32-t},_block:function(t){var e,i,s,o,r,n,h,c,a=this._h;if("undefined"!=typeof Uint32Array){c=Array(80);for(var l=0;l<16;l++)c[l]=t[l]}else c=t;for(s=a[0],o=a[1],r=a[2],n=a[3],h=a[4],e=0;e<=79;e++)16<=e&&(c[e]=this._S(1,c[e-3]^c[e-8]^c[e-14]^c[e-16])),i=this._S(5,s)+this._f(e,o,r,n)+h+c[e]+this._key[Math.floor(e/20)]|0,h=n,n=r,r=this._S(30,o),o=s,s=i;a[0]=a[0]+s|0,a[1]=a[1]+o|0,a[2]=a[2]+r|0,a[3]=a[3]+n|0,a[4]=a[4]+h|0}},sjcl.hash.sha256=function(t){this._key[0]||this._precompute(),t?(this._h=t._h.slice(0),this._buffer=t._buffer.slice(0),this._length=t._length):this.reset()},sjcl.hash.sha256.hash=function(t){return(new sjcl.hash.sha256).update(t).finalize()},sjcl.hash.sha256.prototype={blockSize:512,reset:function(){return this._h=this._init.slice(0),this._buffer=[],this._length=0,this},update:function(t){"string"==typeof t&&(t=sjcl.codec.utf8String.toBits(t));var e,i=this._buffer=sjcl.bitArray.concat(this._buffer,t),s=this._length,o=this._length=s+sjcl.bitArray.bitLength(t);if(9007199254740991<o)throw new sjcl.exception.invalid("Cannot hash more than 2^53 - 1 bits");if("undefined"!=typeof Uint32Array){var r=new Uint32Array(i),n=0;for(e=512+s-(512+s&511);e<=o;e+=512)this._block(r.subarray(16*n,16*(n+1))),n+=1;i.splice(0,16*n)}else for(e=512+s-(512+s&511);e<=o;e+=512)this._block(i.splice(0,16));return this},finalize:function(){var t,e=this._buffer,i=this._h;for(t=(e=sjcl.bitArray.concat(e,[sjcl.bitArray.partial(1,1)])).length+2;15&t;t++)e.push(0);for(e.push(Math.floor(this._length/4294967296)),e.push(0|this._length);e.length;)this._block(e.splice(0,16));return this.reset(),i},_init:[],_key:[],_precompute:function(){var t,e,i=0,s=2;function o(t){return 4294967296*(t-Math.floor(t))|0}for(;i<64;s++){for(e=!0,t=2;t*t<=s;t++)if(s%t==0){e=!1;break}e&&(i<8&&(this._init[i]=o(Math.pow(s,.5))),this._key[i]=o(Math.pow(s,1/3)),i++)}},_block:function(t){var e,i,s,o,r=this._h,n=this._key,h=r[0],c=r[1],a=r[2],l=r[3],u=r[4],_=r[5],d=r[6],f=r[7];for(e=0;e<64;e++)e<16?i=t[e]:(s=t[e+1&15],o=t[e+14&15],i=t[15&e]=(s>>>7^s>>>18^s>>>3^s<<25^s<<14)+(o>>>17^o>>>19^o>>>10^o<<15^o<<13)+t[15&e]+t[e+9&15]|0),i=i+f+(u>>>6^u>>>11^u>>>25^u<<26^u<<21^u<<7)+(d^u&(_^d))+n[e],f=d,d=_,_=u,u=l+i|0,l=a,a=c,h=i+((c=h)&a^l&(c^a))+(c>>>2^c>>>13^c>>>22^c<<30^c<<19^c<<10)|0;r[0]=r[0]+h|0,r[1]=r[1]+c|0,r[2]=r[2]+a|0,r[3]=r[3]+l|0,r[4]=r[4]+u|0,r[5]=r[5]+_|0,r[6]=r[6]+d|0,r[7]=r[7]+f|0}},sjcl.cipher.aes=function(t){this._tables[0][0][0]||this._precompute();var e,i,s,o,r,n=this._tables[0][4],h=this._tables[1],c=t.length,a=1;if(4!==c&&6!==c&&8!==c)throw new sjcl.exception.invalid("invalid aes key size");for(this._key=[o=t.slice(0),r=[]],e=c;e<4*c+28;e++)s=o[e-1],(e%c==0||8===c&&e%c==4)&&(s=n[s>>>24]<<24^n[s>>16&255]<<16^n[s>>8&255]<<8^n[255&s],e%c==0&&(s=s<<8^s>>>24^a<<24,a=a<<1^283*(a>>7))),o[e]=o[e-c]^s;for(i=0;e;i++,e--)s=o[3&i?e:e-4],r[i]=e<=4||i<4?s:h[0][n[s>>>24]]^h[1][n[s>>16&255]]^h[2][n[s>>8&255]]^h[3][n[255&s]]},sjcl.cipher.aes.prototype={encrypt:function(t){return this._crypt(t,0)},decrypt:function(t){return this._crypt(t,1)},_tables:[[[],[],[],[],[]],[[],[],[],[],[]]],_precompute:function(){var t,e,i,s,o,r,n,h,c=this._tables[0],a=this._tables[1],l=c[4],u=a[4],_=[],d=[];for(t=0;t<256;t++)d[(_[t]=t<<1^283*(t>>7))^t]=t;for(e=i=0;!l[e];e^=s||1,i=d[i]||1)for(r=(r=i^i<<1^i<<2^i<<3^i<<4)>>8^255&r^99,h=16843009*_[o=_[s=_[u[l[e]=r]=e]]]^65537*o^257*s^16843008*e,n=257*_[r]^16843008*r,t=0;t<4;t++)c[t][e]=n=n<<24^n>>>8,a[t][r]=h=h<<24^h>>>8;for(t=0;t<5;t++)c[t]=c[t].slice(0),a[t]=a[t].slice(0)},_crypt:function(t,e){if(4!==t.length)throw new sjcl.exception.invalid("invalid aes block size");var i,s,o,r,n=this._key[e],h=t[0]^n[0],c=t[e?3:1]^n[1],a=t[2]^n[2],l=t[e?1:3]^n[3],u=n.length/4-2,_=4,d=[0,0,0,0],f=this._tables[e],p=f[0],y=f[1],b=f[2],g=f[3],v=f[4];for(r=0;r<u;r++)i=p[h>>>24]^y[c>>16&255]^b[a>>8&255]^g[255&l]^n[_],s=p[c>>>24]^y[a>>16&255]^b[l>>8&255]^g[255&h]^n[_+1],o=p[a>>>24]^y[l>>16&255]^b[h>>8&255]^g[255&c]^n[_+2],l=p[l>>>24]^y[h>>16&255]^b[c>>8&255]^g[255&a]^n[_+3],_+=4,h=i,c=s,a=o;for(r=0;r<4;r++)d[e?3&-r:r]=v[h>>>24]<<24^v[c>>16&255]<<16^v[a>>8&255]<<8^v[255&l]^n[_++],i=h,h=c,c=a,a=l,l=i;return d}},sjcl.prng=function(t){this._pools=[new sjcl.hash.sha256],this._poolEntropy=[0],this._reseedCount=0,this._robins={},this._eventId=0,this._collectorIds={},this._collectorIdNext=0,this._strength=0,this._poolStrength=0,this._nextReseed=0,this._key=[0,0,0,0,0,0,0,0],this._counter=[0,0,0,0],this._cipher=void 0,this._defaultParanoia=t,this._collectorsStarted=!1,this._callbacks={progress:{},seeded:{}},this._callbackI=0,this._NOT_READY=0,this._READY=1,this._REQUIRES_RESEED=2,this._MAX_WORDS_PER_BURST=65536,this._PARANOIA_LEVELS=[0,48,64,96,128,192,256,384,512,768,1024],this._MILLISECONDS_PER_RESEED=3e4,this._BITS_PER_RESEED=80},sjcl.prng.prototype={randomWords:function(t,e){var i,s,o=[],r=this.isReady(e);if(r===this._NOT_READY)throw new sjcl.exception.notReady("generator isn't seeded");for(r&this._REQUIRES_RESEED&&this._reseedFromPools(!(r&this._READY)),i=0;i<t;i+=4)(i+1)%this._MAX_WORDS_PER_BURST==0&&this._gate(),s=this._gen4words(),o.push(s[0],s[1],s[2],s[3]);return this._gate(),o.slice(0,t)},setDefaultParanoia:function(t,e){if(0===t&&"Setting paranoia=0 will ruin your security; use it only for testing"!==e)throw new sjcl.exception.invalid("Setting paranoia=0 will ruin your security; use it only for testing");this._defaultParanoia=t},addEntropy:function(t,e,i){i=i||"user";var s,o,r,n,h=(new Date).valueOf(),c=this._robins[i],a=this.isReady(),l=0;switch(void 0===(s=this._collectorIds[i])&&(s=this._collectorIds[i]=this._collectorIdNext++),void 0===c&&(c=this._robins[i]=0),this._robins[i]=(this._robins[i]+1)%this._pools.length,typeof t){case"number":void 0===e&&(e=1),this._pools[c].update([s,this._eventId++,1,e,h,1,0|t]);break;case"object":if("[object Uint32Array]"===(n=Object.prototype.toString.call(t))){for(r=[],o=0;o<t.length;o++)r.push(t[o]);t=r}else for("[object Array]"!==n&&(l=1),o=0;o<t.length&&!l;o++)"number"!=typeof t[o]&&(l=1);if(!l){if(void 0===e)for(o=e=0;o<t.length;o++)for(r=t[o];0<r;)e++,r>>>=1;this._pools[c].update([s,this._eventId++,2,e,h,t.length].concat(t))}break;case"string":void 0===e&&(e=t.length),this._pools[c].update([s,this._eventId++,3,e,h,t.length]),this._pools[c].update(t);break;default:l=1}if(l)throw new sjcl.exception.bug("random: addEntropy only supports number, array of numbers or string");this._poolEntropy[c]+=e,this._poolStrength+=e,a===this._NOT_READY&&(this.isReady()!==this._NOT_READY&&this._fireEvent("seeded",Math.max(this._strength,this._poolStrength)),this._fireEvent("progress",this.getProgress()))},isReady:function(t){var e=this._PARANOIA_LEVELS[void 0!==t?t:this._defaultParanoia];return this._strength&&this._strength>=e?this._poolEntropy[0]>this._BITS_PER_RESEED&&(new Date).valueOf()>this._nextReseed?this._REQUIRES_RESEED|this._READY:this._READY:this._poolStrength>=e?this._REQUIRES_RESEED|this._NOT_READY:this._NOT_READY},getProgress:function(t){var e=this._PARANOIA_LEVELS[t||this._defaultParanoia];return this._strength>=e?1:this._poolStrength>e?1:this._poolStrength/e},startCollectors:function(){if(!this._collectorsStarted){if(this._eventListener={loadTimeCollector:this._bind(this._loadTimeCollector),mouseCollector:this._bind(this._mouseCollector),keyboardCollector:this._bind(this._keyboardCollector),accelerometerCollector:this._bind(this._accelerometerCollector),touchCollector:this._bind(this._touchCollector)},window.addEventListener)window.addEventListener("load",this._eventListener.loadTimeCollector,!1),window.addEventListener("mousemove",this._eventListener.mouseCollector,!1),window.addEventListener("keypress",this._eventListener.keyboardCollector,!1),window.addEventListener("devicemotion",this._eventListener.accelerometerCollector,!1),window.addEventListener("touchmove",this._eventListener.touchCollector,!1);else{if(!document.attachEvent)throw new sjcl.exception.bug("can't attach event");document.attachEvent("onload",this._eventListener.loadTimeCollector),document.attachEvent("onmousemove",this._eventListener.mouseCollector),document.attachEvent("keypress",this._eventListener.keyboardCollector)}this._collectorsStarted=!0}},stopCollectors:function(){this._collectorsStarted&&(window.removeEventListener?(window.removeEventListener("load",this._eventListener.loadTimeCollector,!1),window.removeEventListener("mousemove",this._eventListener.mouseCollector,!1),window.removeEventListener("keypress",this._eventListener.keyboardCollector,!1),window.removeEventListener("devicemotion",this._eventListener.accelerometerCollector,!1),window.removeEventListener("touchmove",this._eventListener.touchCollector,!1)):document.detachEvent&&(document.detachEvent("onload",this._eventListener.loadTimeCollector),document.detachEvent("onmousemove",this._eventListener.mouseCollector),document.detachEvent("keypress",this._eventListener.keyboardCollector)),this._collectorsStarted=!1)},addEventListener:function(t,e){this._callbacks[t][this._callbackI++]=e},removeEventListener:function(t,e){var i,s,o=this._callbacks[t],r=[];for(s in o)o.hasOwnProperty(s)&&o[s]===e&&r.push(s);for(i=0;i<r.length;i++)delete o[s=r[i]]},_bind:function(t){var e=this;return function(){t.apply(e,arguments)}},_gen4words:function(){for(var t=0;t<4&&(this._counter[t]=this._counter[t]+1|0,!this._counter[t]);t++);return this._cipher.encrypt(this._counter)},_gate:function(){this._key=this._gen4words().concat(this._gen4words()),this._cipher=new sjcl.cipher.aes(this._key)},_reseed:function(t){this._key=sjcl.hash.sha256.hash(this._key.concat(t)),this._cipher=new sjcl.cipher.aes(this._key);for(var e=0;e<4&&(this._counter[e]=this._counter[e]+1|0,!this._counter[e]);e++);},_reseedFromPools:function(t){var e,i=[],s=0;for(this._nextReseed=i[0]=(new Date).valueOf()+this._MILLISECONDS_PER_RESEED,e=0;e<16;e++)i.push(4294967296*Math.random()|0);for(e=0;e<this._pools.length&&(i=i.concat(this._pools[e].finalize()),s+=this._poolEntropy[e],this._poolEntropy[e]=0,t||!(this._reseedCount&1<<e));e++);this._reseedCount>=1<<this._pools.length&&(this._pools.push(new sjcl.hash.sha256),this._poolEntropy.push(0)),this._poolStrength-=s,s>this._strength&&(this._strength=s),this._reseedCount++,this._reseed(i)},_keyboardCollector:function(){this._addCurrentTimeToEntropy(1)},_mouseCollector:function(t){var e,i;try{e=t.x||t.clientX||t.offsetX||0,i=t.y||t.clientY||t.offsetY||0}catch(t){i=e=0}0!=e&&0!=i&&this.addEntropy([e,i],2,"mouse"),this._addCurrentTimeToEntropy(0)},_touchCollector:function(t){var e=t.touches[0]||t.changedTouches[0],i=e.pageX||e.clientX,s=e.pageY||e.clientY;this.addEntropy([i,s],1,"touch"),this._addCurrentTimeToEntropy(0)},_loadTimeCollector:function(){this._addCurrentTimeToEntropy(2)},_addCurrentTimeToEntropy:function(t){"undefined"!=typeof window&&window.performance&&"function"==typeof window.performance.now?this.addEntropy(window.performance.now(),t,"loadtime"):this.addEntropy((new Date).valueOf(),t,"loadtime")},_accelerometerCollector:function(t){var e=t.accelerationIncludingGravity.x||t.accelerationIncludingGravity.y||t.accelerationIncludingGravity.z;if(window.orientation){var i=window.orientation;"number"==typeof i&&this.addEntropy(i,1,"accelerometer")}e&&this.addEntropy(e,2,"accelerometer"),this._addCurrentTimeToEntropy(0)},_fireEvent:function(t,e){var i,s=sjcl.random._callbacks[t],o=[];for(i in s)s.hasOwnProperty(i)&&o.push(s[i]);for(i=0;i<o.length;i++)o[i](e)}},sjcl.random=new sjcl.prng(6),function(){try{var t,e,i;if("undefined"!=typeof module&&module.exports&&(e=function(){try{return require("crypto")}catch(t){return null}}())&&e.randomBytes)t=e.randomBytes(128),t=new Uint32Array(new Uint8Array(t).buffer),sjcl.random.addEntropy(t,1024,"crypto.randomBytes");else if("undefined"!=typeof window&&"undefined"!=typeof Uint32Array){if(i=new Uint32Array(32),window.crypto&&window.crypto.getRandomValues)window.crypto.getRandomValues(i);else{if(!window.msCrypto||!window.msCrypto.getRandomValues)return;window.msCrypto.getRandomValues(i)}sjcl.random.addEntropy(i,1024,"crypto.getRandomValues")}}catch(t){"undefined"!=typeof window&&window.console&&(console.log("There was an error collecting entropy from the browser:"),console.log(t))}}(),sjcl.misc.hmac=function(t,e){this._hash=e=e||sjcl.hash.sha256;var i,s=[[],[]],o=e.prototype.blockSize/32;for(this._baseHash=[new e,new e],t.length>o&&(t=e.hash(t)),i=0;i<o;i++)s[0][i]=909522486^t[i],s[1][i]=1549556828^t[i];this._baseHash[0].update(s[0]),this._baseHash[1].update(s[1]),this._resultHash=new e(this._baseHash[0])},sjcl.misc.hmac.prototype.encrypt=sjcl.misc.hmac.prototype.mac=function(t){if(this._updated)throw new sjcl.exception.invalid("encrypt on already updated hmac called!");return this.update(t),this.digest(t)},sjcl.misc.hmac.prototype.reset=function(){this._resultHash=new this._hash(this._baseHash[0]),this._updated=!1},sjcl.misc.hmac.prototype.update=function(t){this._updated=!0,this._resultHash.update(t)},sjcl.misc.hmac.prototype.digest=function(){var t=this._resultHash.finalize(),e=new this._hash(this._baseHash[1]).update(t).finalize();return this.reset(),e};