function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * Copyright 2020 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/email/rc/types/EmailAddress
 */

define(['baja!', 'lex!email'], function (baja, lexs) {
  "use strict";

  var _lexs = _slicedToArray(lexs, 1),
    emailLex = _lexs[0];
  var containsUnallowedCharacters = function containsUnallowedCharacters(str) {
    if (!str) {
      return false;
    }
    return str.indexOf("|") !== -1 || str.indexOf(";") !== -1;
  };

  /**
   * Representation of a `email:EmailAddress`.
   * @alias module:nmodule/email/rc/type/EmailAddress
   */
  var EmailAddress = /*#__PURE__*/function (_baja$Simple) {
    /**
     * Creates a {module:nmodule/email/rc/type/EmailAddress} Object
     *
     * @param {Object} [obj]
     * @param {string} [obj.address] the email address
     * @param {string} [obj.personal] the person's name for the provided address
     */
    function EmailAddress(obj) {
      var _this;
      _classCallCheck(this, EmailAddress);
      _this = _callSuper(this, EmailAddress, [obj]);
      if (!obj) {
        _this.$address = null;
        _this.$personal = null;
        return _possibleConstructorReturn(_this);
      }
      if (containsUnallowedCharacters(obj.address)) {
        throw new Error(emailLex.get('illegalAddress', obj.address));
      }
      if (containsUnallowedCharacters(obj.personal)) {
        throw new Error(emailLex.get('illegalPersonalName', obj.personal));
      }
      _this.$address = obj.address ? obj.address.trim() : null;
      _this.$personal = obj.personal || null;
      return _this;
    }

    /**
     * Creates and returns a new EmailAddress object.
     *
     * Refer to constructor for obj description.
     *
     * @param {Object} [obj]
     * @returns {module:nmodule/email/rc/type/EmailAddress}
     */
    _inherits(EmailAddress, _baja$Simple);
    return _createClass(EmailAddress, [{
      key: "make",
      value: function make() {
        return EmailAddress.make.apply(EmailAddress, arguments);
      }

      /**
       * Determines whether or not the email address is null.
       * @returns {boolean}
       */
    }, {
      key: "isNull",
      value: function isNull() {
        return !this.getAddress() && !this.getPersonal();
      }

      /**
       * Decodes the EmailAddress object using a format of:
       * address|personal
       *
       * @param {string} str
       */
    }, {
      key: "decodeFromString",
      value: function decodeFromString(str) {
        if (!str) {
          return EmailAddress.NULL;
        }
        var barIndex = str.indexOf("|");
        if (barIndex === -1) {
          return EmailAddress.make({
            address: str
          });
        }
        return EmailAddress.make({
          address: str.substring(0, barIndex),
          personal: str.substring(barIndex + 1)
        });
      }

      /**
       * Encodes the EmailAddress to a string using a format of:
       * address|personal
       *
       * @returns {string}
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        if (this.isNull()) {
          return "";
        }
        var personal = this.getPersonal();
        var str = this.getAddress() || "";
        if (personal) {
          str += "|".concat(personal);
        }
        return str;
      }

      /**
       * The address for the EmailAddress
       *
       * @returns {string}
       */
    }, {
      key: "getAddress",
      value: function getAddress() {
        return this.$address || "";
      }

      /**
       * The personal name for the EmailAddress
       *
       * @returns {string}
       */
    }, {
      key: "getPersonal",
      value: function getPersonal() {
        return this.$personal || "";
      }
    }], [{
      key: "make",
      value: function make(obj) {
        return new EmailAddress(obj);
      }
    }]);
  }(baja.Simple);
  EmailAddress.DEFAULT = EmailAddress.make({
    address: null,
    personal: null
  });
  EmailAddress.NULL = EmailAddress.DEFAULT;
  return EmailAddress;
});
